/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import jakarta.inject.Inject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.CombinedXPath;
import org.glassfish.appclient.server.core.jws.DeveloperContentService;
import org.glassfish.appclient.server.core.jws.JavaWebStartInfo;
import org.glassfish.appclient.server.core.jws.XPathToDeveloperProvidedContentRefs;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.appclient.server.core.jws.servedcontent.TokenHelper;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
@PerLookup
public class DeveloperContentHandler {
    @Inject
    DeveloperContentService dcs;
    private ClassLoader loader;
    private ReadableArchive appClientArchive;
    private Map<String, StaticContent> staticContent;
    private Map<String, DynamicContent> dynamicContent;
    private TokenHelper tHelper;
    private URI appRootURI;
    private LSSerializer lsSerializer = null;
    private LSOutput lsOutput = null;
    private static DocumentBuilderFactory dbf = DeveloperContentHandler.documentBuilderFactory();
    private static DocumentBuilder db = DeveloperContentHandler.documentBuilder();
    private AppClientDeployerHelper helper;

    public void init(ClassLoader loader, TokenHelper tHelper, File appRootDir, ReadableArchive appClientArchive, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, AppClientDeployerHelper helper) {
        this.loader = loader;
        this.tHelper = tHelper;
        this.appRootURI = appRootDir.toURI();
        this.appClientArchive = appClientArchive;
        this.staticContent = staticContent;
        this.dynamicContent = dynamicContent;
        this.helper = helper;
    }

    String combineJNLP(String generatedJNLPTemplate, String developerJNLP) {
        Document devDOM;
        try {
            devDOM = this.developerDOMFromPath(developerJNLP);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (devDOM == null) {
            return generatedJNLPTemplate;
        }
        InputSource generatedJNLPSource = new InputSource(new StringReader(generatedJNLPTemplate));
        try {
            Document generatedJNLPDOM = db.parse(generatedJNLPSource);
            for (CombinedXPath combinedXPath : this.dcs.xPathsToCombinedContent()) {
                combinedXPath.process(devDOM, generatedJNLPDOM);
            }
            return this.toXML(generatedJNLPDOM);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private synchronized Document developerDOMFromPath(String devJNLPDoc) throws SAXException, IOException {
        Document result = null;
        if (devJNLPDoc != null) {
            InputStream devJNLPStream = JavaWebStartInfo.openEntry(this.appClientArchive, devJNLPDoc);
            if (devJNLPStream != null) {
                result = db.parse(devJNLPStream);
            } else {
                throw new FileNotFoundException(devJNLPDoc);
            }
        }
        return result;
    }

    private static synchronized Document developerDOMFromContent(String devContent) throws SAXException, IOException {
        return db.parse(new InputSource(new StringReader(devContent)));
    }

    private String toXML(Document dom) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        StringWriter writer = new StringWriter();
        this.writeXML(dom, writer);
        return ((Object)writer).toString();
    }

    private synchronized void writeXML(Node node, Writer writer) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.lsSerializer == null) {
            DOMImplementation domImpl = DOMImplementationRegistry.newInstance().getDOMImplementation("");
            DOMImplementationLS domLS = (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
            this.lsOutput = domLS.createLSOutput();
            this.lsOutput.setEncoding("UTF-8");
            this.lsSerializer = domLS.createLSSerializer();
        }
        this.lsOutput.setCharacterStream(writer);
        this.lsSerializer.write(node, this.lsOutput);
    }

    void addDeveloperContentFromPath(String devJNLPDocPath) {
        if (devJNLPDocPath == null || devJNLPDocPath.length() == 0) {
            return;
        }
        try {
            Document devDOM = this.developerDOMFromPath(devJNLPDocPath);
            this.addDeveloperContent(devJNLPDocPath, devDOM);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void addDeveloperContent(String devJNLPDocPath, String devJNLP) {
        try {
            Document devDOM = DeveloperContentHandler.developerDOMFromContent(devJNLP);
            this.addDeveloperContent(devJNLPDocPath, devDOM);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addDeveloperContent(String contentPath, Document devDOM) throws XPathExpressionException, URISyntaxException, IOException {
        URI codebaseURI = new URI(this.tHelper.appCodebasePath());
        for (XPathToDeveloperProvidedContentRefs c : this.dcs.xPathsToDevContentRefs()) {
            NodeList nodes = (NodeList)c.xPathExpr().evaluate(devDOM, XPathConstants.NODESET);
            if (nodes.getLength() <= 0) continue;
            for (int i = 0; i < nodes.getLength(); ++i) {
                String href = nodes.item(i).getNodeValue();
                if (href.startsWith("${")) continue;
                c.addToContentIfInApp(this, this.helper, contentPath, codebaseURI, href, this.loader, this.staticContent, this.dynamicContent, this.appRootURI, this.appClientArchive);
            }
        }
    }

    private static DocumentBuilderFactory documentBuilderFactory() {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        try {
            f.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        return f;
    }

    private static DocumentBuilder documentBuilder() {
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

