/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.notification.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.MachineMemoryUsageChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.List;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-machinemem")
@RunLevel(value=10)
public class MachineMemoryUsageHealthCheck
extends BaseThresholdHealthCheck<HealthCheckWithThresholdExecutionOptions, MachineMemoryUsageChecker>
implements MonitoringDataSource,
MonitoringWatchSource {
    private static final String MEMTOTAL = "MemTotal:";
    private static final String MEMFREE = "MemFree:";
    private static final String MEMAVAILABLE = "MemAvailable:";
    private static final String ACTIVEFILE = "Active(file):";
    private static final String INACTIVEFILE = "Inactive(file):";
    private static final String RECLAIMABLE = "SReclaimable:";
    private static final String KB = "kB";
    private final PysicalMemoryUsage stats = new PysicalMemoryUsage();

    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, MachineMemoryUsageChecker.class);
    }

    @Override
    public HealthCheckWithThresholdExecutionOptions constructOptions(MachineMemoryUsageChecker checker) {
        return super.constructThresholdOptions(checker);
    }

    @Override
    public String getDescription() {
        return "healthcheck.description.machineMemory";
    }

    @Override
    protected HealthCheckResult doCheckInternal() {
        HealthCheckResult result = new HealthCheckResult();
        long memTotal = 0L;
        try {
            double usedPercentage = this.stats.usedPercentage();
            result.add(new HealthCheckResultEntry(this.decideOnStatusWithRatio(usedPercentage), "Physical Memory Used: " + this.prettyPrintBytes(this.stats.getUsedMemory()) + " - Total Physical Memory: " + this.prettyPrintBytes(this.stats.getTotalMemory()) + " - Memory Used%: " + new DecimalFormat("#.00").format(usedPercentage) + "%"));
        }
        catch (IOException exception) {
            result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "Memory information cannot be read for retrieving physical memory usage values", exception));
        }
        catch (ArithmeticException exception) {
            result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "Error occurred while calculating memory usage values. Total memory is " + memTotal, exception));
        }
        catch (Exception exception) {
            result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "Operating system methods cannot be invoked for retrieving physical memory usage values", exception));
        }
        return result;
    }

    public void collect(MonitoringWatchCollector collector) {
        this.collectUsage(collector, "ns:health PhysicalMemoryUsage", "Physical Memory Usage", 5, false);
    }

    @MonitoringData(ns="health", intervalSeconds=12)
    public void collect(MonitoringDataCollector collector) {
        if (this.options != null && ((HealthCheckWithThresholdExecutionOptions)this.options).isEnabled()) {
            try {
                collector.collect((CharSequence)"PhysicalMemoryUsage", (long)this.stats.usedPercentage());
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static final class PysicalMemoryUsage {
        private volatile long totalMemory;
        private volatile long availableMemory;

        PysicalMemoryUsage() {
        }

        long getTotalMemory() {
            return this.totalMemory;
        }

        long getUsedMemory() {
            return this.totalMemory - this.availableMemory;
        }

        double usedPercentage() throws Exception {
            if (PysicalMemoryUsage.isLinux()) {
                this.updateLinux();
            } else {
                this.updateNonLinux();
            }
            long usedMemory = this.totalMemory - this.availableMemory;
            return this.totalMemory == 0L ? 0.0 : 100.0 * (double)usedMemory / (double)this.totalMemory;
        }

        private void updateLinux() throws IOException {
            List<String> lines = Files.readAllLines(Paths.get("/proc/meminfo", new String[0]), StandardCharsets.UTF_8);
            if (lines.isEmpty()) {
                this.totalMemory = 0L;
                this.availableMemory = 0L;
                return;
            }
            long otherAvailableMemory = 0L;
            this.availableMemory = 0L;
            for (String line : lines) {
                String[] parts = line.split("\\s+");
                if (parts.length <= 1) continue;
                switch (parts[0]) {
                    case "MemAvailable:": {
                        this.availableMemory = PysicalMemoryUsage.parseMemInfo(parts);
                        break;
                    }
                    case "MemTotal:": {
                        this.totalMemory = PysicalMemoryUsage.parseMemInfo(parts);
                        break;
                    }
                    case "Inactive(file):": 
                    case "Active(file):": 
                    case "SReclaimable:": 
                    case "MemFree:": {
                        otherAvailableMemory += PysicalMemoryUsage.parseMemInfo(parts);
                        break;
                    }
                }
            }
            if (this.availableMemory == 0L) {
                this.availableMemory = otherAvailableMemory;
            }
        }

        private void updateNonLinux() throws Exception {
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            this.totalMemory = PysicalMemoryUsage.invokeMethodFor(osBean, "getTotalPhysicalMemorySize");
            this.availableMemory = PysicalMemoryUsage.invokeMethodFor(osBean, "getFreePhysicalMemorySize");
        }

        private static boolean isLinux() {
            String osName = System.getProperty("os.name");
            return osName.startsWith("Linux") || osName.startsWith("FreeBSD") || osName.startsWith("OpenBSD") || osName.startsWith("gnu") || osName.startsWith("netbsd");
        }

        private static long parseMemInfo(String[] parts) {
            long memory = 0L;
            if (parts.length >= 2) {
                memory = Long.parseLong(parts[1]);
                if (parts.length > 2 && MachineMemoryUsageHealthCheck.KB.equals(parts[2])) {
                    memory *= 1024L;
                }
            }
            return memory;
        }

        private static Long invokeMethodFor(OperatingSystemMXBean osBean, String methodName) throws Exception {
            Method m = osBean.getClass().getDeclaredMethod(methodName, new Class[0]);
            m.setAccessible(true);
            return (Long)m.invoke((Object)osBean, new Object[0]);
        }
    }
}

