/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.RemoteType;
import com.sun.enterprise.util.cluster.SshAuthType;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="_update-node")
@I18n(value="update.node")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Node.class, opType=RestEndpoint.OpType.POST, path="_update-node", description="Update Node", params={@RestParam(name="name", value="$parent")})})
public class UpdateNodeCommand
implements AdminCommand {
    private static final Logger LOG = Logger.getLogger(UpdateNodeCommand.class.getName());
    @Inject
    Nodes nodes;
    @Inject
    Domain domain;
    @Param(name="name", primary=true)
    String name;
    @Param(name="nodedir", optional=true)
    String nodedir;
    @Param(name="nodehost", optional=true)
    String nodehost;
    @Param(name="installdir", optional=true)
    String installdir;
    @Param(name="sshport", optional=true)
    String sshport;
    @Param(name="sshuser", optional=true)
    String sshuser;
    @Param(name="sshnodehost", optional=true)
    String sshnodehost;
    @Param(name="sshauthtype", optional=true)
    String sshAuthType;
    @Param(name="sshkeyfile", optional=true)
    String sshkeyfile;
    @Param(name="sshkeypassphrase", optional=true, password=true)
    String sshkeypassphrase;
    @Param(name="sshpassword", optional=true, password=true)
    String sshpassword;
    @Param(name="windowsdomain", optional=true)
    String windowsdomain;
    @Param(name="dockerImage", optional=true)
    String dockerImage;
    @Param(name="dockerPasswordFile", optional=true)
    String dockerPasswordFile;
    @Param(name="dockerPort", optional=true)
    Integer dockerPort;
    @Param(name="useTls", optional=true)
    String useTls;
    @Param(name="type", optional=true)
    String type;

    public void execute(AdminCommandContext context) {
        HashMap<Object, Object> systemPropsMap;
        TokenResolver resolver;
        String resolvedInstallDir;
        File actualInstallDir;
        LOG.finest(() -> String.format("execute(context=%s)", context));
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        Node node = this.nodes.getNode(this.name);
        if (node == null) {
            String msg = Strings.get("noSuchNode", this.name);
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (StringUtils.ok((String)this.nodehost) && NetUtils.isThisHostLocal((String)this.nodehost) && StringUtils.ok((String)this.installdir) && !node.getType().equals(RemoteType.DOCKER.name()) && !(actualInstallDir = new File((resolvedInstallDir = (resolver = new TokenResolver(systemPropsMap = new HashMap<Object, Object>(System.getProperties()))).resolve(this.installdir)) + File.separatorChar + "glassfish/modules/admin-cli.jar")).exists()) {
            report.setMessage(Strings.get("invalid.installdir", this.installdir));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (node.nodeInUse()) {
            String badparam = null;
            String configNodedir = node.getNodeDir();
            String configInstalldir = node.getInstallDir();
            if (!UpdateNodeCommand.allowableChange(this.nodedir, configNodedir)) {
                badparam = "nodedir";
            }
            if (!UpdateNodeCommand.allowableChange(this.installdir, configInstalldir)) {
                badparam = "installdir";
            }
            if (StringUtils.ok((String)badparam)) {
                String msg = Strings.get("noUpdate.nodeInUse", this.name, badparam);
                logger.warning(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg);
                return;
            }
        }
        try {
            this.updateNodeElement(this.name);
        }
        catch (TransactionFailure e) {
            logger.log(Level.WARNING, Strings.get("failed.to.update.node {0}", this.name), e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }

    private void updateNodeElement(final String nodeName) throws TransactionFailure {
        LOG.fine(() -> String.format("updateNodeElement(nodeName=%s)", nodeName));
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction((ConfigBeanProxy)param);
                if (t != null) {
                    Nodes nodes = ((Domain)param).getNodes();
                    Node node = nodes.getNode(nodeName);
                    Node writeableNode = (Node)t.enroll((ConfigBeanProxy)node);
                    if (UpdateNodeCommand.this.windowsdomain != null) {
                        writeableNode.setWindowsDomain(UpdateNodeCommand.this.windowsdomain);
                    }
                    if (UpdateNodeCommand.this.nodedir != null) {
                        writeableNode.setNodeDir(UpdateNodeCommand.this.nodedir);
                    }
                    if (UpdateNodeCommand.this.nodehost != null) {
                        writeableNode.setNodeHost(UpdateNodeCommand.this.nodehost);
                    }
                    if (UpdateNodeCommand.this.installdir != null) {
                        writeableNode.setInstallDir(UpdateNodeCommand.this.installdir);
                    }
                    if (UpdateNodeCommand.this.type != null) {
                        writeableNode.setType(UpdateNodeCommand.this.type);
                    }
                    if (RemoteType.SSH.name().equals(UpdateNodeCommand.this.type) || RemoteType.DCOM.name().equals(UpdateNodeCommand.this.type)) {
                        SshConnector sshConnector = writeableNode.getSshConnector();
                        sshConnector = sshConnector == null ? (SshConnector)writeableNode.createChild(SshConnector.class) : (SshConnector)t.enroll((ConfigBeanProxy)sshConnector);
                        if (UpdateNodeCommand.this.sshport != null) {
                            sshConnector.setSshPort(UpdateNodeCommand.this.sshport);
                        }
                        if (UpdateNodeCommand.this.sshnodehost != null) {
                            sshConnector.setSshHost(UpdateNodeCommand.this.sshnodehost);
                        }
                        writeableNode.setSshConnector(sshConnector);
                        if (UpdateNodeCommand.this.sshAuthType != null || UpdateNodeCommand.this.sshuser != null || UpdateNodeCommand.this.sshkeyfile != null || UpdateNodeCommand.this.sshpassword != null || UpdateNodeCommand.this.sshkeypassphrase != null) {
                            SshAuth sshAuth = sshConnector.getSshAuth();
                            sshAuth = sshAuth == null ? (SshAuth)sshConnector.createChild(SshAuth.class) : (SshAuth)t.enroll((ConfigBeanProxy)sshAuth);
                            if (UpdateNodeCommand.this.sshuser != null) {
                                sshAuth.setUserName(UpdateNodeCommand.this.sshuser);
                            }
                            if (UpdateNodeCommand.this.sshkeypassphrase != null) {
                                sshAuth.setKeyPassphrase(UpdateNodeCommand.this.sshkeypassphrase);
                            }
                            if (UpdateNodeCommand.this.sshAuthType == null) {
                                if (UpdateNodeCommand.this.sshpassword != null) {
                                    sshAuth.setKeyfile(null);
                                    sshAuth.setPassword(UpdateNodeCommand.this.sshpassword);
                                }
                                if (UpdateNodeCommand.this.sshkeyfile != null) {
                                    sshAuth.setKeyfile(UpdateNodeCommand.this.sshkeyfile);
                                    sshAuth.setPassword(null);
                                }
                            } else if (SshAuthType.KEY.name().equals(UpdateNodeCommand.this.sshAuthType)) {
                                sshAuth.setKeyfile(UpdateNodeCommand.this.sshkeyfile);
                                sshAuth.setPassword(null);
                            } else if (SshAuthType.PASSWORD.name().equals(UpdateNodeCommand.this.sshAuthType)) {
                                sshAuth.setKeyfile(null);
                                sshAuth.setKeyPassphrase(null);
                                if (UpdateNodeCommand.this.sshpassword != null) {
                                    sshAuth.setPassword(UpdateNodeCommand.this.sshpassword);
                                }
                            }
                            sshConnector.setSshAuth(sshAuth);
                        }
                    }
                    if (UpdateNodeCommand.this.dockerImage != null) {
                        writeableNode.setDockerImage(UpdateNodeCommand.this.dockerImage);
                    }
                    if (UpdateNodeCommand.this.dockerPasswordFile != null) {
                        writeableNode.setDockerPasswordFile(UpdateNodeCommand.this.dockerPasswordFile);
                    }
                    if (UpdateNodeCommand.this.dockerPort != null) {
                        writeableNode.setDockerPort(Integer.toString(UpdateNodeCommand.this.dockerPort));
                    }
                    if (UpdateNodeCommand.this.useTls != null) {
                        writeableNode.setUseTls(UpdateNodeCommand.this.useTls);
                    }
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)this.domain);
    }

    private static boolean allowableChange(String newvalue, String currentvalue) {
        LOG.finest(() -> String.format("allowableChange(newvalue=%s, currentvalue=%s)", newvalue, currentvalue));
        if (newvalue == null) {
            return true;
        }
        if (!StringUtils.ok((String)currentvalue)) {
            return true;
        }
        if (newvalue.equals(currentvalue)) {
            return true;
        }
        if (newvalue.contains("$") || currentvalue.contains("$")) {
            HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
            TokenResolver resolver = new TokenResolver(systemPropsMap);
            String resolvedNewValue = resolver.resolve(newvalue);
            String resolvedCurrentValue = resolver.resolve(currentvalue);
            return resolvedNewValue.equals(resolvedCurrentValue);
        }
        return false;
    }
}

