/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.cluster;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import fish.payara.enterprise.config.serverbeans.DGServerRef;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import fish.payara.enterprise.config.serverbeans.DeploymentGroups;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="remove-instance-from-deployment-group")
@I18n(value="remove.instance.from.deployment.group")
@PerLookup
@ExecuteOn(value={RuntimeType.ALL}, ifFailure=FailurePolicy.Ignore, ifOffline=FailurePolicy.Ignore, ifNeverStarted=FailurePolicy.Ignore)
@RestEndpoints(value={@RestEndpoint(configBean=DeploymentGroups.class, opType=RestEndpoint.OpType.POST, path="remove-instance-from-deployment-group", description="Remove Instance From a Deployment Group")})
public class RemoveInstanceFromDeploymentGroupCommand
implements AdminCommand {
    @Param(name="instance")
    String instanceName;
    @Param(name="deploymentGroup")
    String deploymentGroupName;
    @Inject
    private Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    CommandRunner commandRunner;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        DeploymentGroup deploymentGroup = this.domain.getDeploymentGroupNamed(this.deploymentGroupName);
        if (deploymentGroup == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Deployment Group " + this.deploymentGroupName + " does not exist");
            return;
        }
        List<String> instances = Arrays.asList(this.instanceName.split(","));
        for (String instance : instances) {
            ParameterMap parameters;
            CommandRunner.CommandInvocation inv;
            Server server = this.domain.getServerNamed(instance);
            if (server == null) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Instance " + instance + " does not exist");
                return;
            }
            DGServerRef deploymentGroupServerRef = deploymentGroup.getDGServerRefByRef(instance);
            if (deploymentGroupServerRef == null) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage("Deployment Group " + this.deploymentGroupName + " does not contain server " + instance);
                return;
            }
            try {
                ConfigSupport.apply(dg1 -> {
                    dg1.getDGServerRef().remove(deploymentGroupServerRef);
                    return null;
                }, (ConfigBeanProxy)deploymentGroup);
            }
            catch (TransactionFailure e) {
                report.setMessage("Failed to remove instance from the deployment group");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
            }
            for (ApplicationRef applicationRef : deploymentGroup.getApplicationRef()) {
                inv = this.commandRunner.getCommandInvocation("delete-application-ref", report, context.getSubject());
                parameters = new ParameterMap();
                parameters.add((Object)"target", (Object)instance);
                parameters.add((Object)"name", (Object)applicationRef.getRef());
                inv.parameters(parameters).execute();
            }
            for (ResourceRef resourceRef : deploymentGroup.getResourceRef()) {
                inv = this.commandRunner.getCommandInvocation("delete-resource-ref", report, context.getSubject());
                parameters = new ParameterMap();
                parameters.add((Object)"target", (Object)instance);
                parameters.add((Object)"reference_name", (Object)resourceRef.getRef());
                inv.parameters(parameters).execute();
            }
        }
    }
}

