/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.opentracing;

import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.OpenTelemetryService;
import io.opentelemetry.opentracingshim.OpenTracingShim;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="opentracing-service")
public class OpenTracingService
implements EventListener {
    public static final String PAYARA_CORBA_RMI_TRACER_NAME = "__PAYARA_CORBA_RMI";
    private static final Map<String, Tracer> tracers = new ConcurrentHashMap<String, Tracer>();
    private static final Logger logger = Logger.getLogger(OpenTracingService.class.getName());
    @Inject
    ServiceLocator locator;
    @Inject
    OpenTelemetryService otel;
    @Inject
    Events events;

    @PostConstruct
    void postConstruct() {
        if (this.events != null) {
            this.events.register((EventListener)this);
        } else {
            logger.log(Level.WARNING, "OpenTracing service not registered to Payara Events: The Tracer for an application won't be removed upon undeployment");
        }
    }

    public void event(EventListener.Event<?> event) {
        ApplicationInfo info;
        Tracer tracer;
        if (event.is(Deployment.APPLICATION_UNLOADED) && (tracer = tracers.remove((info = (ApplicationInfo)event.hook()).getName())) != null) {
            tracer.close();
        }
    }

    public Tracer getTracer(String applicationName) {
        if (applicationName == null) {
            return null;
        }
        Tracer tracer = tracers.get(applicationName);
        if (tracer == null) {
            tracer = this.createTracer(applicationName);
        }
        return tracer;
    }

    private Tracer createTracer(String applicationName) {
        Tracer tracer = tracers.computeIfAbsent(applicationName, appName -> {
            if (this.otel == null) {
                return null;
            }
            this.otel.ensureAppInitialized((String)appName, null);
            return this.otel.getSdkDependency(applicationName, () -> tracers.remove(applicationName)).map(OpenTracingShim::createTracerShim).orElse((Tracer)NoopTracerFactory.create());
        });
        return tracer;
    }

    public boolean isEnabled() {
        RequestTracingService requestTracingService = this.getFromServiceHandle(this.locator, RequestTracingService.class);
        return requestTracingService != null && requestTracingService.isRequestTracingEnabled();
    }

    private <T> T getFromServiceHandle(ServiceLocator serviceLocator, Class<T> serviceClass) {
        ServiceHandle serviceHandle;
        if (serviceLocator != null && (serviceHandle = serviceLocator.getServiceHandle(serviceClass, new Annotation[0])) != null && serviceHandle.isActive()) {
            return (T)serviceHandle.getService();
        }
        return null;
    }

    public String getApplicationName(InvocationManager invocationManager) {
        ApplicationRegistry applicationRegistry;
        ComponentInvocation invocation = invocationManager.getCurrentInvocation();
        if (invocation == null) {
            return null;
        }
        String appName = invocation.getAppName();
        if (appName == null && (appName = invocation.getModuleName()) == null && (appName = invocation.getComponentId()) != null && (applicationRegistry = (ApplicationRegistry)Globals.getDefaultBaseServiceLocator().getService(ApplicationRegistry.class, new Annotation[0])).get(appName) == null) {
            String[] componentIds = appName.split("_/");
            appName = componentIds[0];
        }
        return appName;
    }

    public String getApplicationName(InvocationManager invocationManager, InvocationContext invocationContext) {
        String appName = invocationManager.getCurrentInvocation().getAppName();
        if (appName == null && (appName = invocationManager.getCurrentInvocation().getModuleName()) == null && (appName = invocationManager.getCurrentInvocation().getComponentId()) == null && invocationContext != null) {
            appName = this.getFullMethodSignature(invocationContext.getMethod());
        }
        return appName;
    }

    private String getFullMethodSignature(Method annotatedMethod) {
        return annotatedMethod.getDeclaringClass().getCanonicalName() + "#" + annotatedMethod.getName() + "(" + Arrays.toString(annotatedMethod.getParameterTypes()) + ")>" + annotatedMethod.getReturnType().getSimpleName();
    }
}

