/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jauth.jaspic.provider;

import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityDescriptor;
import com.sun.enterprise.security.jauth.AuthConfig;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import com.sun.enterprise.security.jauth.jaspic.provider.BaseAuthConfig;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;

public class ServerAuthConfig
extends BaseAuthConfig {
    private ServerAuthConfig(ServerAuthContext defaultContext) {
        super(defaultContext);
    }

    private ServerAuthConfig(List<MessageSecurityDescriptor> descriptors, ArrayList authContexts) {
        super(descriptors, authContexts);
    }

    public static ServerAuthConfig getConfig(String authLayer, MessageSecurityBindingDescriptor binding, CallbackHandler cbh) throws AuthException {
        ServerAuthConfig rvalue = null;
        String provider = null;
        List descriptors = null;
        ServerAuthContext defaultContext = null;
        if (binding != null) {
            String layer = binding.getAttributeValue("AuthLayer");
            if (authLayer != null && layer.equals(authLayer)) {
                provider = binding.getAttributeValue("ProviderID");
                descriptors = binding.getMessageSecurityDescriptors();
            }
        }
        if (descriptors == null || descriptors.size() == 0) {
            defaultContext = ServerAuthConfig.getAuthContext(authLayer, provider, null, null, cbh);
            if (defaultContext != null) {
                rvalue = new ServerAuthConfig(defaultContext);
            }
        } else {
            boolean hasPolicy = false;
            ArrayList<ServerAuthContext> authContexts = new ArrayList<ServerAuthContext>();
            for (int i = 0; i < descriptors.size(); ++i) {
                MessageSecurityDescriptor msd = (MessageSecurityDescriptor)descriptors.get(i);
                AuthPolicy requestPolicy = ServerAuthConfig.getAuthPolicy(msd.getRequestProtectionDescriptor());
                AuthPolicy responsePolicy = ServerAuthConfig.getAuthPolicy(msd.getResponseProtectionDescriptor());
                if (requestPolicy.authRequired() || responsePolicy.authRequired()) {
                    authContexts.add(ServerAuthConfig.getAuthContext(authLayer, provider, requestPolicy, responsePolicy, cbh));
                    hasPolicy = true;
                    continue;
                }
                authContexts.add(null);
            }
            if (hasPolicy) {
                rvalue = new ServerAuthConfig(descriptors, authContexts);
            }
        }
        return rvalue;
    }

    private static ServerAuthContext getAuthContext(String layer, String provider, AuthPolicy requestPolicy, AuthPolicy responsePolicy, CallbackHandler cbh) throws AuthException {
        AuthConfig authConfig = AuthConfig.getAuthConfig();
        return authConfig.getServerAuthContext(layer, provider, requestPolicy, responsePolicy, cbh);
    }

    public ServerAuthContext getAuthContext(SOAPMessageContext context) {
        return (ServerAuthContext)this.getContext(context);
    }
}

