/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.jacc.context.PolicyContextHandlerImpl;
import com.sun.enterprise.security.jauth.jaspic.provider.ServerAuthConfig;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.webservices.ClientPipeCreator;
import com.sun.enterprise.security.webservices.LogUtils;
import com.sun.enterprise.web.WebModule;
import com.sun.web.security.RealmAdapter;
import com.sun.xml.ws.assembler.metro.dev.ClientPipelineHook;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.security.jacc.PolicyContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.xml.soap.SOAPMessage;
import java.lang.ref.WeakReference;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.util.Base64;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.SecurityService;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.monitoring.AuthenticationListener;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecurityServiceImpl
implements SecurityService {
    protected static final Logger _logger = LogUtils.getLogger();
    private static final String AUTHORIZATION_HEADER = "authorization";
    private static ThreadLocal<WeakReference<SOAPMessage>> req = new ThreadLocal();
    @Inject
    private AppServerAuditManager auditManager;

    public Object mergeSOAPMessageSecurityPolicies(MessageSecurityBindingDescriptor desc) {
        try {
            return ServerAuthConfig.getConfig("SOAP", desc, null);
        }
        catch (Exception ae) {
            _logger.log(Level.SEVERE, "AS-WSSECURITY-00007", ae);
            return null;
        }
    }

    public boolean doSecurity(HttpServletRequest hreq, EjbRuntimeEndpointInfo epInfo, String realmName, WebServiceContextImpl context) {
        boolean authenticated = false;
        try {
            String method = hreq.getMethod();
            if (context != null) {
                context.setUserPrincipal(null);
            }
            WebServiceEndpoint endpoint = epInfo.getEndpoint();
            String rawAuthInfo = hreq.getHeader(AUTHORIZATION_HEADER);
            if (method.equals("GET") || !endpoint.hasAuthMethod()) {
                authenticated = true;
                boolean bl = true;
                return bl;
            }
            WebPrincipal webPrincipal = null;
            String endpointName = endpoint.getEndpointName();
            if (endpoint.hasBasicAuth() || rawAuthInfo != null) {
                if (rawAuthInfo == null) {
                    this.sendAuthenticationEvents(false, hreq.getRequestURI(), null);
                    authenticated = false;
                    boolean bl = false;
                    return bl;
                }
                List<Object> usernamePassword = this.parseUsernameAndPassword(rawAuthInfo);
                if (usernamePassword != null) {
                    webPrincipal = new WebPrincipal((String)usernamePassword.get(0), (char[])usernamePassword.get(1), SecurityContext.init());
                } else {
                    _logger.log(Level.WARNING, "AS-WSSECURITY-00009", endpointName);
                }
            } else {
                X509Certificate[] certs = (X509Certificate[])hreq.getAttribute("jakarta.servlet.request.X509Certificate");
                if (certs == null || certs.length < 1) {
                    certs = (X509Certificate[])hreq.getAttribute("org.apache.coyote.request.X509Certificate");
                }
                if (certs != null) {
                    webPrincipal = new WebPrincipal(certs, SecurityContext.init());
                } else {
                    _logger.log(Level.WARNING, "AS-WSSECURITY-00010", endpointName);
                }
            }
            if (webPrincipal == null) {
                this.sendAuthenticationEvents(false, hreq.getRequestURI(), null);
                boolean certs = authenticated;
                return certs;
            }
            RealmAdapter realmAdapter = new RealmAdapter(realmName, endpoint.getBundleDescriptor().getModuleID());
            authenticated = realmAdapter.authenticate(webPrincipal);
            if (!authenticated) {
                this.sendAuthenticationEvents(false, hreq.getRequestURI(), (Principal)webPrincipal);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("authentication failed for " + endpointName);
                }
            } else {
                this.sendAuthenticationEvents(true, hreq.getRequestURI(), (Principal)webPrincipal);
            }
            epInfo.prepareInvocation(false);
            WebServiceContextImpl ctxt = (WebServiceContextImpl)epInfo.getWebServiceContext();
            ctxt.setUserPrincipal((Principal)webPrincipal);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.auditManager != null && this.auditManager.isAuditOn()) {
                this.auditManager.ejbAsWebServiceInvocation(epInfo.getEndpoint().getEndpointName(), authenticated);
            }
        }
        return authenticated;
    }

    public Principal getUserPrincipal(boolean isWeb) {
        SecurityContext securityContext = SecurityContext.getCurrent();
        if (securityContext == null) {
            return null;
        }
        if (securityContext.didServerGenerateCredentials() && isWeb) {
            return null;
        }
        return securityContext.getCallerPrincipal();
    }

    public boolean isUserInRole(WebModule webModule, Principal principal, String servletName, String role) {
        if (webModule.getRealm() instanceof RealmAdapter) {
            RealmAdapter realmAdapter = (RealmAdapter)webModule.getRealm();
            return realmAdapter.hasRole(servletName, principal, role);
        }
        return false;
    }

    public void resetSecurityContext() {
        SecurityContext.setUnauthenticatedContext();
    }

    public void resetPolicyContext() {
        ((PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance()).reset();
        PolicyContext.setContextID(null);
    }

    public ClientPipelineHook getClientPipelineHook(ServiceReferenceDescriptor ref) {
        return new ClientPipeCreator(ref);
    }

    private List<Object> parseUsernameAndPassword(String rawAuthInfo) {
        String authString;
        String unencoded;
        int colon;
        ArrayList<Object> usernamePassword = null;
        if (rawAuthInfo != null && rawAuthInfo.startsWith("Basic ") && (colon = (unencoded = new String(Base64.decode((byte[])(authString = rawAuthInfo.substring(6).trim()).getBytes()))).indexOf(58)) > 0) {
            usernamePassword = new ArrayList<Object>();
            usernamePassword.add(unencoded.substring(0, colon).trim());
            usernamePassword.add(unencoded.substring(colon + 1).trim().toCharArray());
        }
        return usernamePassword;
    }

    private void sendAuthenticationEvents(boolean success, String url, Principal principal) {
        Endpoint endpoint = WebServiceEngineImpl.getInstance().getEndpoint(url);
        if (endpoint == null) {
            return;
        }
        for (AuthenticationListener listener : WebServiceEngineImpl.getInstance().getAuthListeners()) {
            if (success) {
                listener.authSucess(endpoint.getDescriptor().getBundleDescriptor(), endpoint, principal);
                continue;
            }
            listener.authFailure(endpoint.getDescriptor().getBundleDescriptor(), endpoint, principal);
        }
    }
}

