/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.adapter;

import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.MediaType;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.rest.adapter.LocatorBridge;
import org.glassfish.admin.rest.adapter.Reloader;
import org.glassfish.admin.rest.adapter.RestResourceProvider;
import org.glassfish.admin.rest.resources.ReloadResource;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.common.util.admin.RestSessionManager;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jersey.jsonp.JsonProcessingFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.CsrfProtectionFilter;

public abstract class AbstractRestResourceProvider
implements RestResourceProvider,
Serializable {
    protected Map<String, MediaType> mappings;

    protected AbstractRestResourceProvider() {
    }

    @Override
    public boolean enableModifAccessToInstances() {
        return false;
    }

    protected Map<String, MediaType> getMimeMappings() {
        if (this.mappings == null) {
            this.mappings = new HashMap<String, MediaType>();
            this.mappings.put("xml", MediaType.APPLICATION_XML_TYPE);
            this.mappings.put("json", MediaType.APPLICATION_JSON_TYPE);
            this.mappings.put("html", MediaType.TEXT_HTML_TYPE);
            this.mappings.put("js", new MediaType("text", "javascript"));
        }
        return this.mappings;
    }

    protected Feature getJsonFeature() {
        return new JsonProcessingFeature();
    }

    @Override
    public ResourceConfig getResourceConfig(Set<Class<?>> classes, final ServerContext sc, final ServiceLocator habitat, Set<? extends Binder> additionalBinders) throws EndpointRegistrationException {
        final Reloader r = new Reloader();
        ResourceConfig rc = new ResourceConfig(classes);
        rc.property("jersey.config.server.mediaTypeMappings", this.getMimeMappings());
        rc.register(CsrfProtectionFilter.class);
        rc.register((Object)r);
        rc.register(ReloadResource.class);
        rc.register((Object)new MultiPartFeature());
        rc.register((Object)new AbstractBinder(){

            protected void configure() {
                AbstractActiveDescriptor descriptor = BuilderHelper.createConstantDescriptor((Object)r);
                descriptor.addContractType(Reloader.class);
                this.bind((Descriptor)descriptor);
                AbstractActiveDescriptor scDescriptor = BuilderHelper.createConstantDescriptor((Object)sc);
                scDescriptor.addContractType(ServerContext.class);
                this.bind((Descriptor)scDescriptor);
                LocatorBridge locatorBridge = new LocatorBridge(habitat);
                AbstractActiveDescriptor hDescriptor = BuilderHelper.createConstantDescriptor((Object)locatorBridge);
                this.bind((Descriptor)hDescriptor);
                RestSessionManager rsm = (RestSessionManager)habitat.getService(RestSessionManager.class, new Annotation[0]);
                AbstractActiveDescriptor rmDescriptor = BuilderHelper.createConstantDescriptor((Object)rsm);
                this.bind((Descriptor)rmDescriptor);
            }
        });
        for (Binder binder : additionalBinders) {
            rc.register((Object)binder);
        }
        rc.property("jersey.config.workers.legacyOrdering", (Object)true);
        return rc;
    }
}

