/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.admin.rest.results.OptionsResult;

@Provider
@Produces(value={"application/json"})
public class OptionsResultJsonProvider
extends BaseProvider<OptionsResult> {
    private static final String NAME = "name";
    private static final String MESSAGE_PARAMETERS = "messageParameters";

    public OptionsResultJsonProvider() {
        super(OptionsResult.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public String getContent(OptionsResult proxy) {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        try {
            obj.add(proxy.getName(), (JsonValue)this.getRespresenationForMethodMetaData(proxy));
        }
        catch (JsonException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        return obj.toString();
    }

    public JsonArray getRespresenationForMethodMetaData(OptionsResult proxy) {
        JsonArrayBuilder arr = Json.createArrayBuilder();
        Set<String> methods = proxy.methods();
        for (String methodName : methods) {
            try {
                MethodMetaData methodMetaData = proxy.getMethodMetaData(methodName);
                JsonObjectBuilder method = Json.createObjectBuilder();
                method.add(NAME, methodName);
                method.add(MESSAGE_PARAMETERS, (JsonValue)this.getMessageParams(methodMetaData));
                arr.add((JsonValue)method.build());
            }
            catch (JsonException ex) {
                RestLogging.restLogger.log(Level.SEVERE, null, ex);
            }
        }
        return arr.build();
    }

    private JsonObject getParameter(ParameterMetaData parameterMetaData) throws JsonException {
        JsonObjectBuilder result = Json.createObjectBuilder();
        for (String attributeName : parameterMetaData.attributes()) {
            result.add(attributeName, parameterMetaData.getAttributeValue(attributeName));
        }
        return result.build();
    }

    private JsonObject getMessageParams(MethodMetaData methodMetaData) throws JsonException {
        JsonObjectBuilder result = Json.createObjectBuilder();
        if (methodMetaData.sizeParameterMetaData() > 0) {
            Set<String> parameters = methodMetaData.parameters();
            for (String parameter : parameters) {
                ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
                result.add(parameter, (JsonValue)this.getParameter(parameterMetaData));
            }
        }
        return result.build();
    }
}

