/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Consumes(value={"application/json"})
@Provider
public class JsonHashMapProvider
implements MessageBodyReader<HashMap<String, String>> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(HashMap.class);
    }

    @Override
    public HashMap<String, String> readFrom(Class<HashMap<String, String>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException {
        HashMap<String, String> hashMap;
        block12: {
            HashMap<String, String> map = new HashMap<String, String>();
            JsonParser parser = Json.createParser((InputStream)in);
            try {
                JsonObject obj;
                if (parser.hasNext()) {
                    parser.next();
                    obj = parser.getObject();
                } else {
                    obj = JsonValue.EMPTY_JSON_OBJECT;
                }
                for (Map.Entry entry : obj.entrySet()) {
                    JsonValue value = (JsonValue)entry.getValue();
                    if (value.getValueType() == JsonValue.ValueType.STRING) {
                        map.put((String)entry.getKey(), ((JsonString)value).getString());
                        continue;
                    }
                    map.put((String)entry.getKey(), value.toString());
                }
                hashMap = map;
                if (parser == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException ex) {
                    Logger.getLogger("org.glassfish.admin.rest.readers").log(Level.FINER, null, ex);
                    return map;
                }
            }
            parser.close();
        }
        return hashMap;
    }

    public static String inputStreamAsString(InputStream stream) throws IOException {
        StringBuilder sb;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString();
    }
}

