/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Set;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.RestModel;

@Provider
@Produces(value={"application/vnd.oracle.glassfish+json"})
@Consumes(value={"application/vnd.oracle.glassfish+json"})
public class RestModelReader<T extends RestModel>
implements MessageBodyReader<T> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String submittedType = mediaType.toString();
        int index = submittedType.indexOf(59);
        if (index > -1) {
            submittedType = submittedType.substring(0, index);
        }
        return submittedType.equals("application/vnd.oracle.glassfish+json") && RestModel.class.isAssignableFrom(type);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public T readFrom(Class<T> type, Type type1, Annotation[] antns, MediaType mt, MultivaluedMap<String, String> mm, InputStream entityStream) throws WebApplicationException, IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(entityStream));){
            RestModel restModel;
            block16: {
                JsonParser parser = Json.createParser((Reader)in);
                try {
                    JsonObject o;
                    Locale locale = CompositeUtil.instance().getLocale(mm);
                    if (parser.hasNext()) {
                        parser.next();
                        o = parser.getObject();
                    } else {
                        o = JsonValue.EMPTY_JSON_OBJECT;
                    }
                    RestModel model = (RestModel)CompositeUtil.instance().unmarshallClass(locale, type, o);
                    Set cv = CompositeUtil.instance().validateRestModel(locale, model);
                    if (!cv.isEmpty()) {
                        Response response = Response.status(Response.Status.BAD_REQUEST).entity(CompositeUtil.instance().getValidationFailureMessages(locale, cv, model)).build();
                        throw new WebApplicationException(response);
                    }
                    restModel = model;
                    if (parser == null) break block16;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return (T)restModel;
        }
        catch (JsonException ex) {
            throw new WebApplicationException(Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(ex.getLocalizedMessage()).build());
        }
    }
}

