/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import org.glassfish.admin.rest.resources.custom.LogNameList;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.LogManager;

public class LogNamesResource {
    protected ServiceLocator habitat = Globals.getDefaultBaseServiceLocator();

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getLogNames(@QueryParam(value="instanceName") String instanceName) throws IOException {
        if (instanceName == null || instanceName.equals("")) {
            return Response.serverError().entity("instanceName is a required attribute").build();
        }
        LogNameList returnedNames = this.getInstanceLogFileNames(instanceName);
        return Response.ok(returnedNames).build();
    }

    private LogNameList getInstanceLogFileNames(String instanceName) throws IOException {
        if (this.habitat.getService(LogManager.class, new Annotation[0]) == null) {
            throw new IOException("The GlassFish LogManager Service is not available. Not installed?");
        }
        LogFilter logFilter = (LogFilter)this.habitat.getService(LogFilter.class, new Annotation[0]);
        List logNameList = logFilter.getInstanceLogFileNames(instanceName);
        return new LogNameList(logNameList);
    }
}

