/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import com.sun.enterprise.admin.remote.AdminCommandStateImpl;
import com.sun.enterprise.admin.report.PropsFileActionReporter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.JobManagerService;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.resources.admin.CommandResource;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.internal.api.Globals;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;

public class SseCommandHelper
implements Runnable,
AdminCommandEventBroker.AdminCommandListener {
    private static final LocalStringManagerImpl STRINGS = new LocalStringManagerImpl(CommandResource.class);
    private final CommandRunner.CommandInvocation commandInvocation;
    private final ActionReportProcessor processor;
    private final EventOutput eventOuptut = new EventOutput();
    private AdminCommandEventBroker broker;

    private SseCommandHelper(CommandRunner.CommandInvocation commandInvocation, ActionReportProcessor processor) {
        this.commandInvocation = commandInvocation;
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.commandInvocation.execute();
        }
        catch (Throwable thr) {
            RestLogging.restLogger.log(Level.WARNING, "NCLS-REST-00008", thr);
            PropsFileActionReporter actionReport = new PropsFileActionReporter();
            actionReport.setFailureCause(thr);
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            AdminCommandStateImpl acs = new AdminCommandStateImpl(AdminCommandState.State.COMPLETED, (ActionReport)actionReport, true, "unknown");
            this.onAdminCommandEvent("AdminCommandInstance/stateChanged", acs);
        }
        finally {
            try {
                this.eventOuptut.close();
            }
            catch (IOException ex) {
                RestLogging.restLogger.log(Level.WARNING, "NCLS-REST-00016", ex.getMessage());
            }
        }
    }

    private void unregister() {
        if (this.broker != null) {
            this.broker.unregisterListener((AdminCommandEventBroker.AdminCommandListener)this);
        }
    }

    private Object process(String name, Object event) {
        if (this.processor != null && "AdminCommandInstance/stateChanged".equals(name)) {
            AdminCommandState acs = (AdminCommandState)event;
            ActionReport report = this.processor.process(acs.getActionReport(), this.eventOuptut);
            event = new AdminCommandStateImpl(acs.getState(), report, acs.isOutboundPayloadEmpty(), acs.getId());
        }
        return event;
    }

    public void onAdminCommandEvent(String name, Object event) {
        block8: {
            if (name == null || event == null) {
                return;
            }
            if ("local/listener/register".equals(name)) {
                AdminCommandEventBroker.BrokerListenerRegEvent blre = (AdminCommandEventBroker.BrokerListenerRegEvent)event;
                this.broker = blre.getBroker();
                return;
            }
            if (name.startsWith("local/")) {
                return;
            }
            if (this.eventOuptut.isClosed()) {
                this.unregister();
                return;
            }
            if (event instanceof Number || event instanceof CharSequence || event instanceof Boolean) {
                event = String.valueOf(event);
            }
            event = this.process(name, event);
            OutboundEvent outEvent = new OutboundEvent.Builder().name(name).mediaType(event instanceof String ? MediaType.TEXT_PLAIN_TYPE : MediaType.APPLICATION_JSON_TYPE).data(event.getClass(), event).build();
            try {
                this.eventOuptut.write((Object)outEvent);
            }
            catch (Exception ex) {
                if (RestLogging.restLogger.isLoggable(Level.FINE)) {
                    RestLogging.restLogger.log(Level.FINE, null, ex);
                }
                if (!this.eventOuptut.isClosed()) break block8;
                this.unregister();
            }
        }
    }

    public static EventOutput invokeAsync(CommandRunner.CommandInvocation commandInvocation, ActionReportProcessor processor) {
        if (commandInvocation == null) {
            throw new IllegalArgumentException("commandInvocation");
        }
        SseCommandHelper helper = new SseCommandHelper(commandInvocation, processor);
        commandInvocation.listener(".*", (AdminCommandEventBroker.AdminCommandListener)helper);
        JobManagerService jobManagerService = (JobManagerService)Globals.getDefaultHabitat().getService(JobManagerService.class, new Annotation[0]);
        jobManagerService.getThreadPool().execute(helper);
        return helper.eventOuptut;
    }

    public static interface ActionReportProcessor {
        public ActionReport process(ActionReport var1, EventOutput var2);
    }
}

