/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.TimeUtil;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.nucleus.requesttracing.configuration.RequestTracingServiceConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@Service(name="set-requesttracing-configuration")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="set-requesttracing-configuration")
@RestEndpoints(value={@RestEndpoint(configBean=RequestTracingServiceConfiguration.class, opType=RestEndpoint.OpType.POST, description="Configures the Request Tracing Service")})
public class SetRequestTracingConfiguration
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(SetRequestTracingConfiguration.class);
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(SetRequestTracingConfiguration.class);
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    ServerEnvironment server;
    @Inject
    RequestTracingService service;
    @Inject
    protected Logger logger;
    @Inject
    protected Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="dynamic", optional=true, defaultValue="false")
    private Boolean dynamic;
    @Param(name="sampleRate", optional=true)
    private String sampleRate;
    @Param(name="adaptiveSamplingEnabled", optional=true)
    private Boolean adaptiveSamplingEnabled;
    @Param(name="adaptiveSamplingTargetCount", optional=true)
    private String adaptiveSamplingTargetCount;
    @Param(name="adaptiveSamplingTimeValue", optional=true)
    private Integer adaptiveSamplingTimeValue;
    @Param(name="adaptiveSamplingTimeUnit", optional=true)
    private String adaptiveSamplingTimeUnit;
    @Param(name="applicationsOnlyEnabled", optional=true)
    private Boolean applicationsOnlyEnabled;
    @Param(name="thresholdValue", optional=true)
    private String thresholdValue;
    @Param(name="thresholdUnit", optional=true)
    private String thresholdUnit;
    @Param(name="sampleRateFirstEnabled", optional=true)
    private Boolean sampleRateFirstEnabled;
    @Param(name="traceStoreSize", optional=true)
    private Integer traceStoreSize;
    @Param(name="traceStoreTimeout", optional=true)
    private String traceStoreTimeout;
    @Param(name="reservoirSamplingEnabled", optional=true)
    private Boolean reservoirSamplingEnabled;
    @Param(name="historicTraceStoreEnabled", optional=true)
    private Boolean historicTraceStoreEnabled;
    @Param(name="historicTraceStoreSize", optional=true)
    private Integer historicTraceStoreSize;
    @Param(name="historicTraceStoreTimeout", optional=true)
    private String historicTraceStoreTimeout;
    @Param(name="enableNotifiers", alias="enable-notifiers", optional=true)
    private List<String> enableNotifiers;
    @Param(name="disableNotifiers", alias="disable-notifiers", optional=true)
    private List<String> disableNotifiers;
    @Param(name="setNotifiers", alias="set-notifiers", optional=true)
    private List<String> setNotifiers;

    public void execute(AdminCommandContext context) {
        Config config;
        RequestTracingServiceConfiguration requestTracingServiceConfiguration;
        final ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if ((requestTracingServiceConfiguration = (RequestTracingServiceConfiguration)(config = this.targetUtil.getConfig(this.target)).getExtensionByType(RequestTracingServiceConfiguration.class)) != null) {
            final Set notifierNames = NotifierUtils.getNotifierNames((ServiceLocator)this.serviceLocator);
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<RequestTracingServiceConfiguration>(){

                    public Object run(RequestTracingServiceConfiguration proxy) throws PropertyVetoException, TransactionFailure {
                        boolean warn = false;
                        if (SetRequestTracingConfiguration.this.enabled != null) {
                            proxy.enabled(SetRequestTracingConfiguration.this.enabled.toString());
                        }
                        if (SetRequestTracingConfiguration.this.sampleRate != null) {
                            proxy.setSampleRate(SetRequestTracingConfiguration.this.sampleRate);
                        }
                        if (SetRequestTracingConfiguration.this.adaptiveSamplingEnabled != null) {
                            proxy.setAdaptiveSamplingEnabled(SetRequestTracingConfiguration.this.adaptiveSamplingEnabled.toString());
                        }
                        if (SetRequestTracingConfiguration.this.adaptiveSamplingTargetCount != null) {
                            proxy.setAdaptiveSamplingTargetCount(SetRequestTracingConfiguration.this.adaptiveSamplingTargetCount);
                        }
                        if (SetRequestTracingConfiguration.this.adaptiveSamplingTimeValue != null) {
                            proxy.setAdaptiveSamplingTimeValue(SetRequestTracingConfiguration.this.adaptiveSamplingTimeValue.toString());
                        }
                        if (SetRequestTracingConfiguration.this.adaptiveSamplingTimeUnit != null) {
                            proxy.setAdaptiveSamplingTimeUnit(SetRequestTracingConfiguration.this.adaptiveSamplingTimeUnit);
                        }
                        if (SetRequestTracingConfiguration.this.applicationsOnlyEnabled != null) {
                            proxy.setApplicationsOnlyEnabled(SetRequestTracingConfiguration.this.applicationsOnlyEnabled.toString());
                        }
                        if (SetRequestTracingConfiguration.this.thresholdValue != null) {
                            proxy.setThresholdValue(SetRequestTracingConfiguration.this.thresholdValue);
                        }
                        if (SetRequestTracingConfiguration.this.thresholdUnit != null) {
                            proxy.setThresholdUnit(SetRequestTracingConfiguration.this.thresholdUnit);
                        }
                        if (SetRequestTracingConfiguration.this.sampleRateFirstEnabled != null) {
                            proxy.setSampleRateFirstEnabled(SetRequestTracingConfiguration.this.sampleRateFirstEnabled.toString());
                        }
                        if (SetRequestTracingConfiguration.this.traceStoreSize != null) {
                            warn = !SetRequestTracingConfiguration.this.traceStoreSize.toString().equals(proxy.getTraceStoreSize());
                            proxy.setTraceStoreSize(SetRequestTracingConfiguration.this.traceStoreSize.toString());
                        }
                        if (SetRequestTracingConfiguration.this.traceStoreTimeout != null) {
                            warn = !SetRequestTracingConfiguration.this.traceStoreTimeout.equals(proxy.getTraceStoreTimeout());
                            proxy.setTraceStoreTimeout(SetRequestTracingConfiguration.this.traceStoreTimeout);
                        }
                        if (SetRequestTracingConfiguration.this.reservoirSamplingEnabled != null) {
                            proxy.setReservoirSamplingEnabled(SetRequestTracingConfiguration.this.reservoirSamplingEnabled.toString());
                        }
                        if (SetRequestTracingConfiguration.this.historicTraceStoreEnabled != null) {
                            proxy.setHistoricTraceStoreEnabled(SetRequestTracingConfiguration.this.historicTraceStoreEnabled.toString());
                        }
                        if (SetRequestTracingConfiguration.this.historicTraceStoreSize != null) {
                            warn = !SetRequestTracingConfiguration.this.historicTraceStoreSize.toString().equals(proxy.getHistoricTraceStoreSize());
                            proxy.setHistoricTraceStoreSize(SetRequestTracingConfiguration.this.historicTraceStoreSize.toString());
                        }
                        if (SetRequestTracingConfiguration.this.historicTraceStoreTimeout != null) {
                            warn = !SetRequestTracingConfiguration.this.historicTraceStoreTimeout.equals(proxy.getHistoricTraceStoreTimeout());
                            proxy.setHistoricTraceStoreTimeout(SetRequestTracingConfiguration.this.historicTraceStoreTimeout);
                        }
                        List<String> notifiers = proxy.getNotifierList();
                        if (SetRequestTracingConfiguration.this.enableNotifiers != null) {
                            for (String notifier : SetRequestTracingConfiguration.this.enableNotifiers) {
                                if (notifierNames.contains(notifier)) {
                                    if (notifiers.contains(notifier)) continue;
                                    notifiers.add(notifier);
                                    continue;
                                }
                                throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(proxy, "notifiers", notifiers, notifiers));
                            }
                        }
                        if (SetRequestTracingConfiguration.this.disableNotifiers != null) {
                            for (String notifier : SetRequestTracingConfiguration.this.disableNotifiers) {
                                if (notifierNames.contains(notifier)) {
                                    notifiers.remove(notifier);
                                    continue;
                                }
                                throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(proxy, "notifiers", notifiers, notifiers));
                            }
                        }
                        if (SetRequestTracingConfiguration.this.setNotifiers != null) {
                            notifiers.clear();
                            for (String notifier : SetRequestTracingConfiguration.this.setNotifiers) {
                                if (notifierNames.contains(notifier)) {
                                    if (notifiers.contains(notifier)) continue;
                                    notifiers.add(notifier);
                                    continue;
                                }
                                throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(proxy, "notifiers", notifiers, notifiers));
                            }
                        }
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        if (warn) {
                            actionReport.setMessage(STRINGS.get("requesttracing.configure.store.size.warning"));
                        }
                        return proxy;
                    }
                }, (ConfigBeanProxy)requestTracingServiceConfiguration);
            }
            catch (TransactionFailure ex) {
                actionReport.failure(this.logger, ex.getCause().getMessage());
                return;
            }
        }
        if (this.dynamic.booleanValue()) {
            if (this.server.isDas()) {
                if (this.targetUtil.getConfig(this.target).isDas()) {
                    this.configureDynamically(actionReport);
                }
            } else {
                this.configureDynamically(actionReport);
            }
        }
    }

    private void configureDynamically(ActionReport actionReport) {
        this.service.getExecutionOptions().setEnabled(this.enabled);
        if (this.sampleRate != null) {
            this.service.getExecutionOptions().setSampleRate(Double.parseDouble(this.sampleRate));
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.samplerate.success", "Request Tracing Sample Rate Value is set to {0}.", new Object[]{this.sampleRate}) + "\n");
        }
        if (this.adaptiveSamplingEnabled != null) {
            this.service.getExecutionOptions().setAdaptiveSamplingEnabled(this.adaptiveSamplingEnabled);
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.adaptivesampling.enabled.success", "Request Tracing Adaptive Sampling Enabled Value is set to {0}.", new Object[]{this.adaptiveSamplingEnabled}) + "\n");
        }
        if (this.adaptiveSamplingTargetCount != null) {
            this.service.getExecutionOptions().setAdaptiveSamplingTargetCount(Integer.valueOf(this.adaptiveSamplingTargetCount));
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.adaptivesampling.targetcount.success", "Request Tracing Adaptive Sampling Target Count is set to {0}.", new Object[]{this.adaptiveSamplingTargetCount}) + "\n");
        }
        if (this.adaptiveSamplingTimeValue != null) {
            this.service.getExecutionOptions().setAdaptiveSamplingTimeValue(this.adaptiveSamplingTimeValue);
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.adaptivesampling.timevalue.success", "Request Tracing Adaptive Sampling Time Value is set to {0}.", new Object[]{this.adaptiveSamplingTimeValue}) + "\n");
        }
        if (this.adaptiveSamplingTimeUnit != null) {
            this.service.getExecutionOptions().setAdaptiveSamplingTimeUnit(TimeUnit.valueOf(this.adaptiveSamplingTimeUnit));
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.adaptivesampling.timeunit.success", "Request Tracing Adaptive Sampling Time Unit is set to {0}.", new Object[]{this.adaptiveSamplingTimeUnit}) + "\n");
        }
        if (this.applicationsOnlyEnabled != null) {
            this.service.getExecutionOptions().setApplicationsOnlyEnabled(this.applicationsOnlyEnabled);
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.applicationsonly.success", "Request Tracing Service Applications Only filter is set to {0}.", new Object[]{this.applicationsOnlyEnabled}) + "\n");
        }
        if (this.thresholdValue != null) {
            this.service.getExecutionOptions().setThresholdValue(Long.valueOf(this.thresholdValue));
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.thresholdvalue.success", "Request Tracing Service Threshold Value is set to {0}.", new Object[]{this.thresholdValue}) + "\n");
        }
        if (this.thresholdUnit != null) {
            this.service.getExecutionOptions().setThresholdUnit(TimeUnit.valueOf(this.thresholdUnit));
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.thresholdunit.success", "Request Tracing Service Threshold Unit is set to {0}.", new Object[]{this.thresholdUnit}) + "\n");
        }
        if (this.sampleRateFirstEnabled != null) {
            this.service.getExecutionOptions().setSampleRateFirstEnabled(this.sampleRateFirstEnabled);
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.sampleratefirst.success", "Request Tracing Service Sample Rate First Enabled Value is set to {0}.", new Object[]{this.sampleRateFirstEnabled}) + "\n");
        }
        if (this.traceStoreSize != null) {
            this.service.getExecutionOptions().setTraceStoreSize(this.traceStoreSize);
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.store.size.success", "Request Tracing Historic Trace Store Size is set to {0}.", new Object[]{this.traceStoreSize}) + "\n");
        }
        if (this.traceStoreTimeout != null) {
            this.service.getExecutionOptions().setTraceStoreTimeout(TimeUtil.setStoreTimeLimit((String)this.traceStoreTimeout));
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.store.timeout.success", "Request Tracing Store Timeout is set to {0}.", new Object[]{this.traceStoreTimeout}) + "\n");
        }
        if (this.reservoirSamplingEnabled != null) {
            this.service.getExecutionOptions().setReservoirSamplingEnabled(this.reservoirSamplingEnabled);
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.reservoirsampling.enabled.success", "Request Tracing Service Reservoir Sampling Enabled Value is set to {0}.", new Object[]{this.reservoirSamplingEnabled}) + "\n");
        }
        if (this.historicTraceStoreEnabled != null) {
            this.service.getExecutionOptions().setHistoricTraceStoreEnabled(this.historicTraceStoreEnabled);
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.historictrace.status.success", "Request Tracing Historic Trace status is set to {0}.", new Object[]{this.historicTraceStoreEnabled}) + "\n");
        }
        if (this.historicTraceStoreSize != null) {
            this.service.getExecutionOptions().setHistoricTraceStoreSize(this.historicTraceStoreSize);
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.historictrace.storesize.success", "Request Tracing Historic Trace Store Size is set to {0}.", new Object[]{this.historicTraceStoreSize}) + "\n");
        }
        if (this.historicTraceStoreTimeout != null) {
            this.service.getExecutionOptions().setHistoricTraceStoreTimeout(TimeUtil.setStoreTimeLimit((String)this.historicTraceStoreTimeout));
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.historictrace.timeout.success", "Request Tracing Historic Trace Store Timeout is set to {0}.", new Object[]{this.historicTraceStoreTimeout}) + "\n");
        }
        Set<String> notifiers = this.service.getExecutionOptions().getEnabledNotifiers();
        if (this.enableNotifiers != null) {
            this.enableNotifiers.forEach(notifiers::add);
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.notifier.enable.success", "Request Tracing Notifiers {0} have been enabled.", new Object[]{Arrays.toString(this.enableNotifiers.toArray())}) + "\n");
        }
        if (this.disableNotifiers != null) {
            this.disableNotifiers.forEach(notifiers::remove);
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.notifier.disable.success", "Request Tracing Notifiers {0} have been disabled.", new Object[]{Arrays.toString(this.disableNotifiers.toArray())}) + "\n");
        }
        if (this.setNotifiers != null) {
            notifiers.clear();
            this.setNotifiers.forEach(notifiers::add);
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.notifier.enable.success", "Request Tracing Notifiers {0} have been enabled.", new Object[]{Arrays.toString(this.setNotifiers.toArray())}) + "\n");
        }
        this.service.bootstrapRequestTracingService();
    }
}

