/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.AbstractMethodHelper;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.CMPROTemplateFormatter;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.CMPTemplateFormatter;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.LogHelperEJBCompiler;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.JDOQLElements;
import com.sun.jdo.spi.persistence.support.ejb.model.util.NameMapper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriter;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriterHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaFileWriter;
import com.sun.jdo.spi.persistence.utility.generator.io.IOJavaClassWriter;
import com.sun.jdo.spi.persistence.utility.generator.io.IOJavaFileWriter;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.glassfish.common.util.StringHelper;
import org.glassfish.persistence.common.I18NHelper;

abstract class JDOConcreteBeanGenerator {
    static final Logger logger = LogHelperEJBCompiler.getLogger();
    NameMapper nameMapper = null;
    Model model = null;
    String appName = null;
    String beanName = null;
    String helperName = null;
    String concreteImplName = null;
    String abstractBean = null;
    String pkClass = null;
    String pcname = null;
    boolean hasLocalInterface;
    boolean hasRemoteInterface;
    boolean isUpdateable;
    String setPKField = null;
    String[] pcnameParam = new String[1];
    String[] pkClassParam = new String[1];
    static String[] objectType = new String[]{"Object"};
    static String[] param0 = new String[]{"param0"};
    static String[] param0PM = new String[]{"param0", "_jdoPersistenceManager"};
    String[] oneParam = new String[1];
    String[] twoParams = new String[2];
    String[] threeParams = new String[3];
    String[] fourParams = new String[4];
    String[] fiveParams = new String[5];
    String[] sixParams = new String[6];
    String[] queryParams = new String[10];
    StringBuilder loadNonDFGBody = null;
    ClassLoader loader;
    JavaClassWriter concreteImplWriter;
    JavaClassWriter jdoHelperWriter;
    static final ResourceBundle messages = I18NHelper.loadBundle(JDOConcreteBeanGenerator.class);
    public static final String SUPPORT_TRAILING_SPACES_IN_STRING_PK_COLUMNS_PROPERTY = "com.sun.jdo.spi.persistence.support.ejb.ejbc.SUPPORT_TRAILING_SPACES_IN_STRING_PK_COLUMNS";
    private static final boolean SUPPORT_TRAILING_SPACES_IN_STRING_PK_COLUMNS = Boolean.valueOf(System.getProperty("com.sun.jdo.spi.persistence.support.ejb.ejbc.SUPPORT_TRAILING_SPACES_IN_STRING_PK_COLUMNS", "false"));
    String inputFilesSignature;
    String generatorClassesSignature;
    static final String SIGNATURE = "$RCSfile: JDOConcreteBeanGenerator.java,v $ $Revision: 1.3 $";

    JDOConcreteBeanGenerator(ClassLoader loader, Model model, NameMapper nameMapper) throws IOException {
        this.loader = loader;
        this.model = model;
        this.nameMapper = nameMapper;
        CMPTemplateFormatter.initHelpers();
        CMPROTemplateFormatter.initHelpers();
    }

    void setUpdateable(boolean updateable) {
        this.isUpdateable = updateable;
    }

    Collection validate(AbstractMethodHelper methodHelper, String beanName) {
        return new ArrayList();
    }

    Collection<File> generate(AbstractMethodHelper methodHelper, String beanName, String appName, File srcout, File classout) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.beanName = beanName;
        this.appName = appName;
        this.abstractBean = this.nameMapper.getAbstractBeanClassForEjbName(beanName);
        String pkgName = CMPTemplateFormatter.getPackageName((String)this.abstractBean);
        this.concreteImplName = this.nameMapper.getConcreteBeanClassForEjbName(beanName);
        String shortCmpName = CMPTemplateFormatter.getShortClassName((String)this.concreteImplName);
        this.pcnameParam[0] = this.pcname = this.nameMapper.getPersistenceClassForEjbName(beanName);
        PersistenceClassElement pcClassElement = this.model.getPersistenceClass(this.pcname);
        this.pkClassParam[0] = this.pkClass = this.nameMapper.getKeyClassForEjbName(beanName).replace('$', '.');
        PersistenceFieldElement[] allFields = pcClassElement.getFields();
        String prefix = srcout.getPath() + File.separator + this.concreteImplName.replace('.', File.separatorChar);
        String cmp_file_name = prefix + ".java";
        String hlp_file_name = prefix + "_JDOHelper.java";
        this.hasLocalInterface = this.nameMapper.getLocalInterfaceForEjbName(beanName) != null;
        boolean bl = this.hasRemoteInterface = this.nameMapper.getRemoteInterfaceForEjbName(beanName) != null;
        if (logger.isLoggable(500)) {
            logger.fine("allFields: " + (allFields != null ? allFields.length : 0));
            logger.fine("cmp_file_name: " + cmp_file_name);
            logger.fine("hlp_file_name: " + hlp_file_name);
            logger.fine("cmp_name: " + this.concreteImplName);
            logger.fine("pkClass: " + this.pkClass);
            logger.fine("PCname: " + this.pcname);
        }
        File cmp_file = new File(cmp_file_name);
        IOJavaFileWriter concreteImplFileWriter = new IOJavaFileWriter(cmp_file);
        this.concreteImplWriter = new IOJavaClassWriter();
        File hlp_file = new File(hlp_file_name);
        IOJavaFileWriter helperFileWriter = new IOJavaFileWriter(hlp_file);
        this.jdoHelperWriter = new IOJavaClassWriter();
        if (pkgName != null && pkgName.length() > 0) {
            concreteImplFileWriter.setPackage(pkgName, null);
            helperFileWriter.setPackage(pkgName, null);
        }
        this.addImportStatements((JavaFileWriter)concreteImplFileWriter, (JavaFileWriter)helperFileWriter);
        this.oneParam[0] = CMPTemplateFormatter.cmpImplCommentsTemplate;
        this.concreteImplWriter.setClassDeclaration(1, shortCmpName, this.oneParam);
        this.addInterfaces();
        this.concreteImplWriter.setSuperclass(this.abstractBean);
        this.concreteImplWriter.addConstructor(shortCmpName, 1, null, null, null, CMPTemplateFormatter.super_, null);
        this.helperName = shortCmpName + "_JDOHelper";
        this.oneParam[0] = shortCmpName;
        this.jdoHelperWriter.setClassDeclaration(1, this.helperName, CMPTemplateFormatter.getBodyAsStrings((String)CMPTemplateFormatter.hcomformatter.format(this.oneParam)));
        this.setHelperSuperclass();
        this.generateFields();
        this.generateTypeSpecificMethods(allFields, methodHelper);
        this.generateFinders(methodHelper);
        this.generateCreateMethods(methodHelper.getCreateMethods());
        this.generateKnownMethods(methodHelper);
        this.generateHelperClassMethods();
        this.generateConversions();
        this.generatePKObjectIdConversion(this.getKeyFields(allFields));
        concreteImplFileWriter.addClass(this.concreteImplWriter);
        concreteImplFileWriter.save();
        helperFileWriter.addClass(this.jdoHelperWriter);
        helperFileWriter.save();
        files.add(cmp_file);
        files.add(hlp_file);
        return files;
    }

    void addImportStatements(JavaFileWriter concreteImplFileWriter, JavaFileWriter helperFileWriter) throws IOException {
        int i;
        String[] st = CMPTemplateFormatter.importsArray;
        for (i = 0; i < st.length; ++i) {
            concreteImplFileWriter.addImport(st[i], null);
        }
        st = CMPTemplateFormatter.helperImportsArray;
        for (i = 0; i < st.length; ++i) {
            helperFileWriter.addImport(st[i], null);
        }
    }

    void addInterfaces() throws IOException {
        String[] st = CMPTemplateFormatter.interfacesArray;
        for (int i = 0; i < st.length; ++i) {
            this.concreteImplWriter.addInterface(st[i]);
        }
    }

    abstract void setHelperSuperclass() throws IOException;

    void generateTypeSpecificMethods(PersistenceFieldElement[] allFields, AbstractMethodHelper methodHelper) throws IOException {
        this.loadNonDFGBody = this.isUpdateable ? null : new StringBuilder();
    }

    void addCodeGenInputFilesSignature(String newSignature) {
        this.inputFilesSignature = this.inputFilesSignature == null || this.inputFilesSignature.length() == 0 ? newSignature : this.inputFilesSignature + " ## " + newSignature;
    }

    void addCodeGeneratorClassSignature(String newSignature) {
        this.generatorClassesSignature = this.generatorClassesSignature == null || this.generatorClassesSignature.length() == 0 ? newSignature : this.generatorClassesSignature + " ## " + newSignature;
    }

    void generateFields() throws IOException {
        CMPTemplateFormatter.addPrivateField((String)CMPTemplateFormatter.privatetransientvformatter.format(this.pcnameParam), (int)128, (JavaClassWriter)this.concreteImplWriter);
        CMPTemplateFormatter.addPrivateField((String)CMPTemplateFormatter.privateStaticVariablesTemplate, (int)8, (JavaClassWriter)this.concreteImplWriter);
        this.twoParams[0] = this.pcname;
        this.twoParams[1] = this.beanName;
        CMPTemplateFormatter.addPrivateField((String)CMPTemplateFormatter.privatestaticfinalvformatter.format(this.twoParams), (int)24, (JavaClassWriter)this.concreteImplWriter);
        this.twoParams[0] = this.generatorClassesSignature;
        this.twoParams[1] = this.inputFilesSignature;
        CMPTemplateFormatter.addFields((String)CMPTemplateFormatter.publicstaticfinalvformatter.format(this.twoParams), (int)25, (JavaClassWriter)this.concreteImplWriter);
        CMPTemplateFormatter.addPrivateField((String)CMPTemplateFormatter.otherVariablesTemplate, (int)0, (JavaClassWriter)this.concreteImplWriter);
        this.threeParams[0] = this.concreteImplName;
        this.threeParams[1] = this.beanName;
        this.threeParams[2] = this.appName;
        CMPTemplateFormatter.addPrivateField((String)CMPTemplateFormatter.hvformatter.format(this.threeParams), (int)136, (JavaClassWriter)this.jdoHelperWriter);
        if (!this.isUpdateable) {
            CMPTemplateFormatter.addPrivateField((String)CMPROTemplateFormatter.privatetransientvformatter.format(this.pcnameParam), (int)128, (JavaClassWriter)this.concreteImplWriter);
            CMPTemplateFormatter.addPrivateField((String)CMPROTemplateFormatter.privateStaticFinalVariablesTemplate, (int)24, (JavaClassWriter)this.concreteImplWriter);
        }
    }

    void generateFinders(AbstractMethodHelper methodHelper) throws IOException {
        boolean debug = logger.isLoggable(500);
        List finders = methodHelper.getFinders();
        for (int i = 0; i < finders.size(); ++i) {
            Method m = (Method)finders.get(i);
            String mname = "ejb" + StringHelper.getCapitalizedString((String)m.getName());
            if (debug) {
                logger.fine("Finder: " + mname);
            }
            if (mname.equals("ejbFindByPrimaryKey")) {
                String[] exceptionTypes = CMPTemplateFormatter.getExceptionNames((Method)m);
                this.oneParam[0] = "key";
                this.concreteImplWriter.addMethod("ejbFindByPrimaryKey", 1, this.pkClass, this.oneParam, this.pkClassParam, exceptionTypes, CMPTemplateFormatter.ejbFindByPrimaryKeyBody, null);
                continue;
            }
            JDOQLElements rs = this.getJDOQLElements(m, methodHelper);
            String returnType = this.isSingleObjectFinder(m) ? this.pkClass : m.getReturnType().getName();
            CMPTemplateFormatter.addGenericMethod((Method)m, (String)mname, (String)returnType, (String)this.generateFinderMethodBody(methodHelper, rs, mname, m, returnType, i), (JavaClassWriter)this.concreteImplWriter);
        }
    }

    abstract JDOQLElements getJDOQLElements(Method var1, AbstractMethodHelper var2) throws IOException;

    private void generateCreateMethods(List createMethods) throws IOException {
        Class<?> beanClass = null;
        try {
            beanClass = Class.forName(this.abstractBean, true, this.loader);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        HashSet<Method> generated = new HashSet<Method>();
        for (int i = 0; i < createMethods.size(); ++i) {
            boolean debug;
            Method m;
            Method m1 = m = (Method)createMethods.get(i);
            Object createName = "ejbCreate";
            Object postCreateName = "ejbPostCreate";
            if (m.getName().length() > 6) {
                String suffix = m.getName().substring(6);
                createName = (String)createName + suffix;
                postCreateName = (String)postCreateName + suffix;
            }
            if (debug = logger.isLoggable(500)) {
                logger.fine("CreateMethod: " + this.abstractBean + m.getName());
                logger.fine("ejbCreateMethod: " + (String)createName);
                logger.fine("ejbPostCreateMethod: " + (String)postCreateName);
            }
            try {
                Class<?>[] params = m.getParameterTypes();
                for (int j = 0; j < params.length; ++j) {
                    if (params[j].isPrimitive() || params[j].getClassLoader() == null || params[j].getClassLoader().equals(this.loader)) continue;
                    String pname = params[j].getName();
                    if (debug) {
                        logger.fine("Replacing parameter class for: " + pname);
                        logger.fine("Param ClassLoader: " + params[j].getClassLoader());
                        logger.fine("Need ClassLoader: " + this.loader);
                    }
                    params[j] = Class.forName(pname, true, this.loader);
                }
                m = beanClass.getMethod((String)createName, params);
                m1 = beanClass.getMethod((String)postCreateName, params);
                if (generated.contains(m)) {
                    if (!debug) continue;
                    logger.fine("...generated...");
                    continue;
                }
                generated.add(m);
            }
            catch (Exception e) {
                continue;
            }
            String[] exc = CMPTemplateFormatter.getExceptionNames((Method)m);
            String parametersList = CMPTemplateFormatter.getParametersList((Method)m);
            String parametersListWithSeparator = this.makeLiteral(CMPTemplateFormatter.getParametersListWithSeparator((Method)m, (String)" + \", \" + "));
            String body = this.getEJBCreateMethodBody((String)createName, exc, parametersList, parametersListWithSeparator);
            CMPTemplateFormatter.addGenericMethod((Method)m, (String)createName, (String)this.pkClass, (String)body, (JavaClassWriter)this.concreteImplWriter);
            body = this.getEJBPostCreateMethodBody((String)postCreateName, parametersList, parametersListWithSeparator);
            CMPTemplateFormatter.addGenericMethod((Method)m1, (String)postCreateName, (String)"void", (String)body, (JavaClassWriter)this.concreteImplWriter);
        }
    }

    abstract String getEJBCreateMethodBody(String var1, String[] var2, String var3, String var4);

    abstract String getEJBPostCreateMethodBody(String var1, String var2, String var3);

    abstract String getEJBRemoveMethodBody();

    void generateKnownMethods(AbstractMethodHelper methodHelper) throws IOException {
        String[] exc = null;
        String[] st = CMPTemplateFormatter.commonPublicMethodsArray;
        for (int i = 0; i < st.length; ++i) {
            String mname = st[i];
            exc = this.getExceptionList(methodHelper, mname);
            String body = null;
            if (mname.equals("ejbRemove")) {
                body = this.getEJBRemoveMethodBody();
            } else if (mname.equals("ejb__flush")) {
                this.oneParam[0] = "jakarta.ejb.DuplicateKeyException";
                exc = this.oneParam;
                body = CMPTemplateFormatter.helpers.getProperty(mname);
            } else {
                body = CMPTemplateFormatter.helpers.getProperty(mname);
            }
            this.concreteImplWriter.addMethod(mname, 1, "void", null, null, exc, CMPTemplateFormatter.getBodyAsStrings((String)body), null);
        }
        this.oneParam[0] = "int";
        this.concreteImplWriter.addMethod("afterCompletion", 1, "void", param0, this.oneParam, null, CMPTemplateFormatter.afterCompletionBody, null);
        this.concreteImplWriter.addMethod("ejb__remove", 1, "void", param0, objectType, null, null, null);
        st = CMPTemplateFormatter.commonPrivateMethodsArray;
        for (int i = 0; i < st.length; ++i) {
            String mname = st[i];
            String body = CMPTemplateFormatter.helpers.getProperty(mname);
            CMPTemplateFormatter.addGenericMethod((String)mname, (String[])CMPTemplateFormatter.getBodyAsStrings((String)body), (JavaClassWriter)this.concreteImplWriter);
        }
        this.oneParam[0] = "byte";
        String body = CMPTemplateFormatter.jdoarraycopyformatter.format(this.oneParam);
        this.oneParam[0] = "byte[]";
        this.concreteImplWriter.addMethod("jdoArrayCopy", 2, "byte[]", param0, this.oneParam, null, CMPTemplateFormatter.getBodyAsStrings((String)body), null);
        this.oneParam[0] = "jakarta.ejb.EntityContext";
        this.concreteImplWriter.addMethod("setEntityContext", 1, "void", param0, this.oneParam, this.getExceptionList(methodHelper, "setEntityContext", this.oneParam), CMPTemplateFormatter.setEntityContextBody, null);
        this.oneParam[0] = "key";
        String[] param = new String[]{this.concreteImplName};
        this.concreteImplWriter.addMethod("jdoGetObjectId", 2, "Object", this.oneParam, this.pkClassParam, null, CMPTemplateFormatter.getBodyAsStrings((String)CMPTemplateFormatter.goidformatter.format(param)), null);
        this.oneParam[0] = CMPTemplateFormatter.jdoGetJdoInstanceClassTemplate;
        CMPTemplateFormatter.addGenericMethod((String)"jdoGetJdoInstanceClass", (int)9, (String)"java.lang.Class", (String[])this.oneParam, (JavaClassWriter)this.concreteImplWriter);
        this.generateSpecialKnownMethods();
    }

    void generateSpecialKnownMethods() throws IOException {
        Object body = null;
        if (this.isUpdateable) {
            body = CMPTemplateFormatter.assertPersistenceManagerIsNullBody;
        }
        CMPTemplateFormatter.addGenericMethod((String)"assertPersistenceManagerIsNull", (String[])body, (JavaClassWriter)this.concreteImplWriter);
        if (this.isUpdateable) {
            this.oneParam[0] = I18NHelper.getMessage((ResourceBundle)messages, (String)"EXC_TransactionNotActive");
            body = CMPTemplateFormatter.getBodyAsStrings((String)CMPTemplateFormatter.intxformatter.format(this.oneParam));
        }
        CMPTemplateFormatter.addGenericMethod((String)"assertInTransaction", (String[])body, (JavaClassWriter)this.concreteImplWriter);
        body = this.isUpdateable ? CMPTemplateFormatter.jdoClosePersistenceManagerBody : CMPROTemplateFormatter.jdoClosePersistenceManagerBody;
        CMPTemplateFormatter.addGenericMethod((String)"jdoClosePersistenceManager", (String[])body, (JavaClassWriter)this.concreteImplWriter);
        body = this.isUpdateable ? CMPTemplateFormatter.jdoGetPersistenceManagerBody : CMPROTemplateFormatter.jdoGetPersistenceManagerBody;
        CMPTemplateFormatter.addGenericMethod((String)"jdoGetPersistenceManager", (String)"com.sun.jdo.api.persistence.support.PersistenceManager", (String[])body, (JavaClassWriter)this.concreteImplWriter);
        this.oneParam[0] = "key";
        if (this.isUpdateable) {
            body = CMPTemplateFormatter.jdoGetPersistenceManager0Body;
        } else {
            body = CMPROTemplateFormatter.jdoGetPersistenceManager0Body;
            this.concreteImplWriter.addMethod("jdoGetPersistenceManagerByPK", 1, "com.sun.jdo.api.persistence.support.PersistenceManager", this.oneParam, this.pkClassParam, null, CMPROTemplateFormatter.jdoGetPersistenceManagerByPKBody, null);
        }
        this.concreteImplWriter.addMethod("jdoGetPersistenceManager0", 1, "com.sun.jdo.api.persistence.support.PersistenceManager", this.oneParam, this.pkClassParam, null, body, null);
        this.oneParam[0] = this.concreteImplName;
        MessageFormat mformat = null;
        mformat = this.isUpdateable ? CMPTemplateFormatter.jdolookuppmfformatter : CMPROTemplateFormatter.jdolookuppmfformatter;
        this.concreteImplWriter.addMethod("jdoLookupPersistenceManagerFactory", 42, "void", param0, objectType, null, CMPTemplateFormatter.getBodyAsStrings((String)mformat.format(this.oneParam)), null);
        this.threeParams[0] = this.pkClass;
        this.threeParams[1] = this.pcname;
        this.threeParams[2] = "";
        if (this.isUpdateable) {
            mformat = CMPTemplateFormatter.giformatter;
        } else {
            if (this.loadNonDFGBody != null) {
                this.threeParams[2] = this.loadNonDFGBody.toString();
            }
            mformat = CMPROTemplateFormatter.giformatter;
        }
        CMPTemplateFormatter.addGenericMethod((String)"jdoGetInstance", (String[])CMPTemplateFormatter.getBodyAsStrings((String)mformat.format(this.threeParams)), (JavaClassWriter)this.concreteImplWriter);
        body = this.isUpdateable ? null : CMPTemplateFormatter.getBodyAsStrings((String)CMPROTemplateFormatter.ejb__refreshformatter.format(this.threeParams));
        this.concreteImplWriter.addMethod("ejb__refresh", 1, "void", param0, objectType, null, body, null);
        this.oneParam[0] = "com.sun.jdo.api.persistence.support.PersistenceManager";
        this.concreteImplWriter.addMethod("jdoReleasePersistenceManager", 2, "void", param0, this.oneParam, null, CMPTemplateFormatter.jdoReleasePersistenceManagerBody, null);
        body = this.isUpdateable ? CMPTemplateFormatter.jdoReleasePersistenceManagerBody : CMPROTemplateFormatter.jdoReleasePersistenceManager0Body;
        this.concreteImplWriter.addMethod("jdoReleasePersistenceManager0", 2, "void", param0, this.oneParam, null, body, null);
    }

    void generateHelperClassMethods() throws IOException {
        this.oneParam[0] = CMPTemplateFormatter.assertInstanceOfRemoteInterfaceImplTemplate;
        this.jdoHelperWriter.addMethod("assertInstanceOfRemoteInterfaceImpl", 1, "void", param0, objectType, null, this.oneParam, null);
        this.oneParam[0] = CMPTemplateFormatter.getHelperInstanceTemplate;
        CMPTemplateFormatter.addGenericMethod((String)"getHelperInstance", (int)9, (String)this.helperName, (String[])this.oneParam, (JavaClassWriter)this.jdoHelperWriter);
        CMPTemplateFormatter.addGenericMethod((String)"getContainer", (int)1, (String)"Object", (String[])CMPTemplateFormatter.getContainerBody, (JavaClassWriter)this.jdoHelperWriter);
        this.oneParam[0] = this.concreteImplName;
        CMPTemplateFormatter.addGenericMethod((String)"getPCClass", (int)1, (String)"java.lang.Class", (String[])CMPTemplateFormatter.getBodyAsStrings((String)CMPTemplateFormatter.pcclassgetterformatter.format(this.oneParam)), (JavaClassWriter)this.jdoHelperWriter);
    }

    private String[] getKeyFields(PersistenceFieldElement[] fields) {
        ArrayList<String> returnList = new ArrayList<String>();
        int count = fields != null ? fields.length : 0;
        for (int i = 0; i < count; ++i) {
            PersistenceFieldElement pfe = fields[i];
            if (!pfe.isKey()) continue;
            returnList.add(pfe.getName());
        }
        return returnList.toArray(new String[returnList.size()]);
    }

    private void generatePKObjectIdConversion(String[] keyFields) throws IOException {
        int length = keyFields.length;
        StringBuilder getOid = new StringBuilder();
        StringBuilder getPK = new StringBuilder();
        String[] pkfieldParam = new String[1];
        getOid.append(CMPTemplateFormatter.assertPKNotNullTemplate).append(CMPTemplateFormatter.noidformatter.format(this.pcnameParam));
        getPK.append(CMPTemplateFormatter.assertOidNotNullTemplate).append(CMPTemplateFormatter.oidcformatter.format(this.pcnameParam));
        boolean debug = logger.isLoggable(500);
        if (length == 1) {
            String pkfield = keyFields[0];
            String pkfieldType = this.model.getFieldType(this.pcname, pkfield);
            pkfieldParam[0] = pkfield;
            if (debug) {
                logger.fine("pkfield: " + pkfield);
            }
            if (this.model.isPrimitive(this.pcname, pkfield) || !this.pkClass.equals(pkfieldType) && !this.pkClass.equals(Object.class.getName())) {
                getPK.append(CMPTemplateFormatter.npkformatter.format(this.pkClassParam));
                getOid.append(CMPTemplateFormatter.pkcformatter.format(this.pkClassParam));
                pkfieldParam[0] = pkfield;
                getOid.append(CMPTemplateFormatter.oidformatter.format(pkfieldParam));
                getPK.append(CMPTemplateFormatter.pkformatter.format(pkfieldParam));
                getPK.append("return key;");
            } else {
                this.oneParam[0] = pkfieldType;
                getOid.append(CMPTemplateFormatter.pkcformatter.format(this.oneParam));
                this.twoParams[0] = pkfield;
                this.twoParams[1] = pkfieldType;
                getOid.append(this.requireCloneOnGetAndSet(pkfieldType) ? CMPTemplateFormatter.oid1cloneformatter.format(this.twoParams) : (this.requireTrimOnSet(pkfieldType) ? CMPTemplateFormatter.oid1stringformatter.format(pkfieldParam) : CMPTemplateFormatter.oid1formatter.format(pkfieldParam)));
                getPK.append(this.requireCloneOnGetAndSet(pkfieldType) ? CMPTemplateFormatter.pk1cloneformatter.format(pkfieldParam) : CMPTemplateFormatter.pk1formatter.format(pkfieldParam));
            }
        } else {
            getPK.append(CMPTemplateFormatter.npkformatter.format(this.pkClassParam));
            getOid.append(CMPTemplateFormatter.pkcformatter.format(this.pkClassParam));
            for (int i = 0; i < length; ++i) {
                String pkfield;
                pkfieldParam[0] = pkfield = keyFields[i];
                if (debug) {
                    logger.fine("pkfield: " + pkfield);
                }
                if (!this.model.isPrimitive(this.pcname, pkfield)) {
                    getOid.append(CMPTemplateFormatter.assertpkfieldformatter.format(pkfieldParam));
                }
                String pkfieldType = this.model.getFieldType(this.pcname, pkfield);
                this.twoParams[0] = pkfield;
                this.twoParams[1] = pkfieldType;
                getOid.append(this.requireCloneOnGetAndSet(pkfieldType) ? CMPTemplateFormatter.oidcloneformatter.format(this.twoParams) : (this.requireTrimOnSet(pkfieldType) ? CMPTemplateFormatter.oidstringformatter.format(pkfieldParam) : CMPTemplateFormatter.oidformatter.format(pkfieldParam)));
                getPK.append(this.requireCloneOnGetAndSet(pkfieldType) ? CMPTemplateFormatter.pkcloneformatter.format(this.twoParams) : CMPTemplateFormatter.pkformatter.format(pkfieldParam));
            }
            getPK.append("return key;");
        }
        getOid.append("return jdoObjectId;");
        this.jdoHelperWriter.addMethod("convertPrimaryKeyToObjectId", 1, "Object", param0, objectType, null, CMPTemplateFormatter.getBodyAsStrings((String)getOid.toString()), null);
        this.jdoHelperWriter.addMethod("convertObjectIdToPrimaryKey", 1, "Object", param0, objectType, null, CMPTemplateFormatter.getBodyAsStrings((String)getPK.toString()), null);
    }

    String getConcreteBeanForPCClass(String pcClass) {
        return this.nameMapper.getConcreteBeanClassForEjbName(this.nameMapper.getEjbNameForPersistenceClass(pcClass));
    }

    void generateConversions() throws IOException {
        String[] pcParams = new String[]{"pc", "_jdoPersistenceManager"};
        String[] pcParamTypes = new String[]{"Object", "com.sun.jdo.api.persistence.support.PersistenceManager"};
        String[] collParamTypes = new String[]{"java.util.Collection", "com.sun.jdo.api.persistence.support.PersistenceManager"};
        String[] body = null;
        if (!this.hasRemoteInterface) {
            body = CMPTemplateFormatter.getBodyAsStrings((String)"return null;");
            this.jdoHelperWriter.addMethod("convertPCToEJBObject", 1, "EJBObject", pcParams, pcParamTypes, null, body, null);
            this.twoParams[0] = "EJBObject";
            this.twoParams[1] = "com.sun.jdo.api.persistence.support.PersistenceManager";
            this.jdoHelperWriter.addMethod("convertEJBObjectToPC", 1, "Object", param0PM, this.twoParams, null, body, null);
        }
    }

    boolean containsException(String[] exc, String checkExc) {
        boolean rc = false;
        if (exc != null) {
            for (int i = 0; i < exc.length; ++i) {
                if (!exc[i].equals(checkExc)) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    String getException(String[] exc, String checkExc) {
        return this.containsException(exc, checkExc) ? checkExc : "EJBException";
    }

    String getException(String[] exc, String checkExc, String superExc) {
        String rc = "EJBException";
        if (exc != null) {
            for (int i = 0; i < exc.length; ++i) {
                if (!exc[i].equals(checkExc) && !exc[i].equals(superExc)) continue;
                rc = checkExc;
                break;
            }
        }
        return rc;
    }

    private boolean isSingleObjectFinder(Method finder) {
        return !finder.getReturnType().equals(Collection.class) && !finder.getReturnType().equals(Enumeration.class);
    }

    private String generateFinderMethodBody(AbstractMethodHelper methodHelper, JDOQLElements jdoqlElements, String mname, Method m, String returnType, int index) throws IOException {
        StringBuilder body = new StringBuilder();
        body.append(CMPTemplateFormatter.assertPersistenceManagerIsNullTemplate);
        body.append("\n");
        body.append(this.generateFinderSelectorCommonBody(methodHelper, jdoqlElements, mname, m, returnType, index));
        this.oneParam[0] = mname;
        if (this.isSingleObjectFinder(m)) {
            this.fourParams[0] = mname;
            this.fourParams[1] = this.pkClass;
            this.fourParams[2] = this.concreteImplName;
            this.fourParams[3] = CMPTemplateFormatter.catchClauseTemplate;
            body.append(CMPTemplateFormatter.singlefinderformatter.format(this.fourParams));
        } else {
            this.twoParams[0] = this.concreteImplName;
            this.twoParams[1] = CMPTemplateFormatter.catchClauseTemplate;
            if (this.isFinderReturningEnumeration(m)) {
                body.append(CMPTemplateFormatter.multifinderenumerationformatter.format(this.twoParams));
            } else {
                body.append(CMPTemplateFormatter.multifinderformatter.format(this.twoParams));
            }
        }
        return body.toString();
    }

    String generateFinderSelectorCommonBody(AbstractMethodHelper methodHelper, JDOQLElements jdoqlElements, String methodName, Method m, String returnType, int index) throws IOException {
        String queryVariableQualifier = m.getName() + "_" + index;
        this.oneParam[0] = queryVariableQualifier;
        CMPTemplateFormatter.addPrivateField((String)CMPTemplateFormatter.finderselectorstaticvformatter.format(this.oneParam), (int)8, (JavaClassWriter)this.concreteImplWriter);
        CMPTemplateFormatter.addPrivateField((String)CMPTemplateFormatter.finderselectorstaticfinalvformatter.format(this.oneParam), (int)24, (JavaClassWriter)this.concreteImplWriter);
        StringBuilder body = new StringBuilder();
        String[] parameterEjbNames = jdoqlElements.getParameterEjbNames();
        body.append(this.generateFinderSelectorParamCheck(m, parameterEjbNames));
        String pcClassName = jdoqlElements.getCandidateClassName();
        String concreteBeanClassName = this.getConcreteBeanForPCClass(pcClassName);
        this.queryParams[0] = returnType;
        this.queryParams[1] = queryVariableQualifier;
        this.queryParams[2] = concreteBeanClassName;
        this.queryParams[3] = StringHelper.escape((String)jdoqlElements.getFilter());
        this.queryParams[4] = StringHelper.escape((String)jdoqlElements.getParameters());
        this.queryParams[5] = StringHelper.escape((String)jdoqlElements.getVariables());
        this.queryParams[6] = StringHelper.escape((String)jdoqlElements.getResult());
        this.queryParams[7] = StringHelper.escape((String)jdoqlElements.getOrdering());
        this.queryParams[8] = Boolean.toString(methodHelper.isQueryPrefetchEnabled(m));
        this.queryParams[9] = StringHelper.escape((String)this.generateQueryIgnoreCache());
        body.append(CMPTemplateFormatter.finderselectorformatter.format(this.queryParams));
        String queryParam = this.generateParamConvBody(m, parameterEjbNames);
        if (jdoqlElements.isAggregate()) {
            if (queryParam == null) {
                this.oneParam[0] = "";
                body.append(CMPTemplateFormatter.aggqueryexecformatter.format(this.oneParam));
            } else {
                this.oneParam[0] = queryParam;
                body.append(CMPTemplateFormatter.aggqueryexecparamconvformatter.format(this.oneParam));
            }
        } else if (queryParam == null) {
            this.oneParam[0] = "";
            body.append(CMPTemplateFormatter.queryexecformatter.format(this.oneParam));
        } else {
            this.oneParam[0] = queryParam;
            body.append(CMPTemplateFormatter.queryexecparamconvformatter.format(this.oneParam));
        }
        return body.toString();
    }

    String generateFinderSelectorParamCheck(Method m, String[] parameterEjbNames) {
        StringBuilder checkBody = new StringBuilder();
        return checkBody.toString();
    }

    String generateQueryIgnoreCache() {
        return "";
    }

    abstract boolean isFinderReturningEnumeration(Method var1);

    private String generateParamConvBody(Method m, String[] parameterEjbNames) {
        StringBuilder paramString = new StringBuilder();
        Class<?>[] paramTypes = m.getParameterTypes();
        int paramLength = paramTypes.length;
        MessageFormat mformat = null;
        String paramClassName = null;
        if (paramLength > 0) {
            for (int i = 0; i < paramLength; ++i) {
                paramClassName = paramTypes[i].getName();
                if (this.nameMapper.isLocalInterface(paramClassName) || this.nameMapper.isRemoteInterface(paramClassName)) {
                    if (parameterEjbNames[i] != null) {
                        String concreteImplName;
                        mformat = CMPTemplateFormatter.queryexecparamconvargumentformatter;
                        this.threeParams[0] = concreteImplName = this.nameMapper.getConcreteBeanClassForEjbName(parameterEjbNames[i]);
                        this.threeParams[1] = String.valueOf(i);
                        this.threeParams[2] = this.nameMapper.isLocalInterface(paramClassName) ? "convertEJBLocalObjectToPC" : "convertEJBObjectToPC";
                        paramString.append(mformat.format(this.threeParams));
                    } else {
                        paramString.append("param" + i);
                    }
                } else if (paramTypes[i].isPrimitive()) {
                    paramString.append(JavaClassWriterHelper.getWrapperExpr(paramTypes[i], (String)("param" + i)));
                } else {
                    paramString.append("param" + i);
                }
                if (i >= paramLength - 1) continue;
                paramString.append(", ");
            }
        } else {
            return null;
        }
        return paramString.toString();
    }

    String[] getExceptionList(AbstractMethodHelper methodHelper, String mname, String[] paramTypeNames) {
        String[] rc = null;
        Class[] paramTypes = null;
        Map methodNames = methodHelper.getMethodNames();
        Method m = (Method)methodNames.get(mname);
        boolean debug = logger.isLoggable(500);
        if (debug) {
            logger.fine("Processing method: " + mname);
            logger.fine("Known method: " + m);
        }
        if (m == null) {
            if (paramTypeNames != null) {
                paramTypes = new Class[paramTypeNames.length];
                try {
                    for (int i = paramTypeNames.length - 1; i >= 0; --i) {
                        paramTypes[i] = Class.forName(paramTypeNames[i], true, this.loader);
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            try {
                Class<?> beanClass = Class.forName(this.abstractBean, true, this.loader);
                m = beanClass.getMethod(mname, paramTypes);
                if (debug) {
                    logger.fine("Found method: " + m);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (m != null) {
            rc = CMPTemplateFormatter.getExceptionNames((Method)m);
        }
        return rc;
    }

    String[] getExceptionList(AbstractMethodHelper methodHelper, String mname) {
        return this.getExceptionList(methodHelper, mname, null);
    }

    private String makeLiteral(String st) {
        return StringHelper.isEmpty((String)st) ? "\"\"" : "\"\" + " + st;
    }

    String getSignaturesOfGeneratorClasses() {
        StringBuilder signatures = new StringBuilder().append(SIGNATURE).append(" ## ").append(CMPTemplateFormatter.signatureTemplate).append(" ## ").append("$RCSfile: DeploymentDescriptorModel.java,v $ $Revision: 1.2 $");
        return signatures.toString();
    }

    boolean requireCloneOnGetAndSet(String fieldType) {
        return "java.util.Date".equals(fieldType) || "java.sql.Date".equals(fieldType) || "java.sql.Time".equals(fieldType) || "java.sql.Timestamp".equals(fieldType);
    }

    boolean requireTrimOnSet(String fieldType) {
        boolean requireTrimOnSet = "java.lang.String".equals(fieldType);
        return requireTrimOnSet && !SUPPORT_TRAILING_SPACES_IN_STRING_PK_COLUMNS;
    }

    void loadNonDFGField(FieldInfo fieldInfo) {
        if (!this.isUpdateable && !fieldInfo.isDFG) {
            this.oneParam[0] = fieldInfo.getter;
            this.loadNonDFGBody.append(CMPROTemplateFormatter.loadNonDFGformatter.format(this.oneParam));
        }
    }

    class FieldInfo {
        final PersistenceFieldElement pfe;
        final String name;
        final String type;
        final String getter;
        final String setter;
        final boolean isKey;
        final boolean isPrimitive;
        final boolean isByteArray;
        final boolean isSerializable;
        final boolean requireCloneOnGetAndSet;
        final boolean isGeneratedField;
        final boolean isDFG;

        FieldInfo(Model model, NameMapper nameMapper, PersistenceFieldElement pfe, String beanName, String pcname) {
            this.pfe = pfe;
            String pfn = pfe.getName();
            this.name = nameMapper.getEjbFieldForPersistenceField(pcname, pfn);
            String fname = StringHelper.getCapitalizedString((String)this.name);
            this.getter = "get" + fname;
            this.setter = "set" + fname;
            boolean debug = logger.isLoggable(500);
            if (debug) {
                logger.fine("-Methods: " + this.getter + " " + this.setter);
            }
            this.isKey = pfe.isKey();
            this.isPrimitive = model.isPrimitive(pcname, pfn);
            this.isByteArray = model.isByteArray(beanName, this.name);
            this.isSerializable = model.isByteArray(pcname, pfn);
            this.type = this.isSerializable ? model.getFieldType(beanName, this.name).replace('$', '.') : model.getFieldType(beanName, this.name);
            if (debug) {
                logger.fine("Field: " + this.name + " " + this.type);
            }
            this.requireCloneOnGetAndSet = JDOConcreteBeanGenerator.this.requireCloneOnGetAndSet(this.type);
            this.isGeneratedField = nameMapper.isGeneratedField(beanName, this.name);
            MappingClassElement mce = model.getMappingClass(pcname);
            MappingFieldElement mfe = mce.getField(this.name);
            this.isDFG = mfe.getFetchGroup() == 1;
        }
    }
}

