/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFile;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileSystem;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import com.trilead.ssh2.SFTPv3FileAttributes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.DcomInfo;
import org.glassfish.hk2.api.ServiceLocator;

public class LogFilterForInstance {
    public File downloadGivenInstanceLogFile(ServiceLocator habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String domainRoot, String logFileName, String instanceLogFileName) throws IOException {
        File instanceLogFile = null;
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNodeRef();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        if (node.getType().equals("SSH")) {
            Object loggingFile;
            sshL.init(node, logger);
            SFTPClient sftpClient = sshL.getSFTPClient();
            File logFileDirectoryOnServer = this.makingDirectory(domainRoot + File.separator + "logs" + File.separator + instanceName);
            boolean noFileFound = true;
            String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileName, node, sNode, instanceName);
            try {
                Vector instanceLogFileNames = sftpClient.ls(loggingDir);
                for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                    SFTPv3DirectoryEntry file = (SFTPv3DirectoryEntry)instanceLogFileNames.get(i);
                    String fileName = file.filename;
                    if (file.attributes.isDirectory() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                    noFileFound = false;
                    break;
                }
            }
            catch (Exception e) {
                noFileFound = true;
            }
            if (noFileFound) {
                loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileName, node, sNode, instanceName);
            }
            if (!sftpClient.exists((String)(loggingFile = loggingDir + File.separator + logFileName))) {
                loggingFile = loggingDir + File.separator + "server.log";
            } else if (!sftpClient.exists((String)loggingFile)) {
                loggingFile = instanceLogFileName;
            }
            long instanceLogFileSize = 0L;
            instanceLogFile = new File(logFileDirectoryOnServer.getAbsolutePath() + File.separator + ((String)loggingFile).substring(((String)loggingFile).lastIndexOf(File.separator), ((String)loggingFile).length()));
            if (instanceLogFile.exists()) {
                instanceLogFileSize = instanceLogFile.length();
            }
            SFTPv3FileAttributes sftPv3FileAttributes = sftpClient._stat((String)loggingFile);
            long fileSizeOnNode = sftPv3FileAttributes.size;
            if (instanceLogFileSize != fileSizeOnNode) {
                try (BufferedInputStream in = new BufferedInputStream(sftpClient.read((String)loggingFile));
                     BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(instanceLogFile));){
                    int i;
                    while ((i = in.read()) != -1) {
                        out.write(i);
                    }
                    out.flush();
                }
            }
            sftpClient.close();
        } else if (node.getType().equals("DCOM")) {
            File logFileDirectoryOnServer = this.makingDirectory(domainRoot + File.separator + "logs" + File.separator + instanceName);
            String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileName, node, sNode, instanceName);
            try {
                DcomInfo info = new DcomInfo(node);
                WindowsRemoteFileSystem wrfs = new WindowsRemoteFileSystem(info.getHost(), info.getUser(), info.getPassword());
                if (logFileName == null || logFileName.equals("")) {
                    logFileName = "server.log";
                }
                WindowsRemoteFile wrf = new WindowsRemoteFile(wrfs, loggingDir + File.separator + logFileName);
                instanceLogFile = new File(logFileDirectoryOnServer + File.separator + logFileName);
                wrf.copyTo(instanceLogFile);
            }
            catch (WindowsException ex) {
                throw new IOException("Unable to download instance log file from DCOM Instance Node");
            }
        }
        return instanceLogFile;
    }

    public void downloadAllInstanceLogFiles(ServiceLocator habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String tempDirectoryOnServer, String instanceLogFileDirectory) throws IOException {
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNodeRef();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        if (node.getType().equals("SSH")) {
            int i;
            sshL.init(node, logger);
            List<String> allInstanceLogFileName = this.getInstanceLogFileNames(habitat, targetServer, domain, logger, instanceName, instanceLogFileDirectory);
            boolean noFileFound = true;
            String sourceDir = this.getLoggingDirectoryForNode(instanceLogFileDirectory, node, sNode, instanceName);
            SFTPClient sftpClient = sshL.getSFTPClient();
            try {
                Vector instanceLogFileNames = sftpClient.ls(sourceDir);
                for (i = 0; i < instanceLogFileNames.size(); ++i) {
                    SFTPv3DirectoryEntry file = (SFTPv3DirectoryEntry)instanceLogFileNames.get(i);
                    String fileName = file.filename;
                    if (file.attributes.isDirectory() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                    noFileFound = false;
                    break;
                }
            }
            catch (Exception e) {
                noFileFound = true;
            }
            if (noFileFound) {
                sourceDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDirectory, node, sNode, instanceName);
            }
            String[] remoteFileNames = new String[allInstanceLogFileName.size()];
            for (i = 0; i < allInstanceLogFileName.size(); ++i) {
                remoteFileNames[i] = sourceDir + File.separator + allInstanceLogFileName.get(i);
            }
            sftpClient.close();
            SCPClient scpClient = sshL.getSCPClient();
            scpClient.get(remoteFileNames, tempDirectoryOnServer);
        } else if (node.getType().equals("DCOM")) {
            List<String> instanceLogFileNames = this.getInstanceLogFileNames(habitat, targetServer, domain, logger, instanceName, instanceLogFileDirectory);
            String sourceDir = this.getLoggingDirectoryForNode(instanceLogFileDirectory, node, sNode, instanceName);
            try {
                DcomInfo info = new DcomInfo(node);
                WindowsRemoteFileSystem wrfs = new WindowsRemoteFileSystem(info.getHost(), info.getUser(), info.getPassword());
                for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                    String logFileName = instanceLogFileNames.get(i);
                    WindowsRemoteFile wrf = new WindowsRemoteFile(wrfs, sourceDir + File.separator + logFileName);
                    File instanceLogFile = new File(tempDirectoryOnServer + File.separator + logFileName);
                    wrf.copyTo(instanceLogFile);
                }
            }
            catch (WindowsException ex) {
                throw new IOException("Unable to download instance log file from DCOM Instance Node");
            }
        }
    }

    public List<String> getInstanceLogFileNames(ServiceLocator habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String instanceLogFileDetails) throws IOException {
        ArrayList<String> instanceLogFileNamesAsString;
        block15: {
            Vector instanceLogFileNames;
            Node node;
            String sNode;
            block14: {
                String fileName;
                sNode = targetServer.getNodeRef();
                node = domain.getNodes().getNode(sNode);
                instanceLogFileNames = null;
                instanceLogFileNamesAsString = new ArrayList<String>();
                if (!node.isLocal()) break block14;
                String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileDetails, node, sNode, instanceName);
                File logsDir = new File(loggingDir);
                File[] allLogFileNames = logsDir.listFiles();
                boolean noFileFound = true;
                if (allLogFileNames != null) {
                    for (File file : allLogFileNames) {
                        fileName = file.getName();
                        if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                        instanceLogFileNamesAsString.add(fileName);
                        noFileFound = false;
                    }
                }
                if (!noFileFound || (allLogFileNames = (logsDir = new File(loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDetails, node, sNode, instanceName))).listFiles()) == null) break block15;
                for (File file : allLogFileNames) {
                    fileName = file.getName();
                    if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                    instanceLogFileNamesAsString.add(fileName);
                }
                break block15;
            }
            if (node.getType().equals("SSH")) {
                String fileName;
                SFTPv3DirectoryEntry file;
                SSHLauncher sshL = this.getSSHL(habitat);
                sshL.init(node, logger);
                SFTPClient sftpClient = sshL.getSFTPClient();
                boolean noFileFound = true;
                String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileDetails, node, sNode, instanceName);
                try {
                    instanceLogFileNames = sftpClient.ls(loggingDir);
                    for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                        file = (SFTPv3DirectoryEntry)instanceLogFileNames.get(i);
                        fileName = file.filename;
                        if (file.attributes.isDirectory() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                        instanceLogFileNamesAsString.add(fileName);
                        noFileFound = false;
                    }
                }
                catch (Exception ex) {
                    noFileFound = true;
                }
                if (noFileFound) {
                    loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDetails, node, sNode, instanceName);
                    instanceLogFileNames = sftpClient.ls(loggingDir);
                    for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                        file = (SFTPv3DirectoryEntry)instanceLogFileNames.get(i);
                        fileName = file.filename;
                        if (file.attributes.isDirectory() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                        instanceLogFileNamesAsString.add(fileName);
                    }
                }
                sftpClient.close();
            } else if (node.getType().equals("DCOM")) {
                String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileDetails, node, sNode, instanceName);
                try {
                    String[] allLogFileNames;
                    DcomInfo info = new DcomInfo(node);
                    WindowsRemoteFileSystem wrfs = new WindowsRemoteFileSystem(info.getHost(), info.getUser(), info.getPassword());
                    WindowsRemoteFile wrf = new WindowsRemoteFile(wrfs, loggingDir);
                    for (String allLogFileName : allLogFileNames = wrf.list()) {
                        File file = new File(allLogFileName);
                        String fileName = file.getName();
                        if (fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                        instanceLogFileNamesAsString.add(fileName);
                    }
                }
                catch (WindowsException ex) {
                    throw new IOException("Unable to get instance log file names from DCOM Instance Node");
                }
            }
        }
        return instanceLogFileNamesAsString;
    }

    private SSHLauncher getSSHL(ServiceLocator habitat) {
        return (SSHLauncher)habitat.getService(SSHLauncher.class, new Annotation[0]);
    }

    private File makingDirectory(String path) {
        File targetDir = new File(path);
        boolean created = false;
        boolean deleted = false;
        if (targetDir.exists() && !(deleted = targetDir.delete())) {
            return targetDir;
        }
        created = targetDir.mkdir();
        if (!created) {
            return null;
        }
        return targetDir;
    }

    public String getLoggingDirectoryForNode(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        Object loggingDir = "";
        loggingDir = instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getNodeDir() != null ? node.getNodeDir() + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : (instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getInstallDir() != null ? node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : instanceLogFileDirectory.substring(0, instanceLogFileDirectory.lastIndexOf(File.separator)));
        return loggingDir;
    }

    public String getLoggingDirectoryForNodeWhenNoFilesFound(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        Object loggingDir = "";
        loggingDir = node.getNodeDir() != null ? node.getNodeDir() + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : (node.getInstallDir() != null ? node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : instanceLogFileDirectory.substring(0, instanceLogFileDirectory.lastIndexOf(File.separator)));
        return loggingDir;
    }
}

