/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.parser;

import com.sun.enterprise.server.logging.LogEvent;
import com.sun.enterprise.server.logging.parser.LogParserFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class ParsedLogRecord
implements LogEvent {
    public static final String DATE_TIME = "timestamp";
    public static final String LOG_LEVEL_NAME = "level";
    public static final String PRODUCT_ID = "productId";
    public static final String LOGGER_NAME = "logger";
    public static final String THREAD_ID = "threadId";
    public static final String THREAD_NAME = "threadName";
    public static final String TIME_MILLIS = "timeMillis";
    public static final String LOG_LEVEL_VALUE = "levelValue";
    public static final String LOG_MESSAGE = "message";
    public static final String SUPP_ATTRS = "suppAttrs";
    public static final String MESSAGE_ID = "msgId";
    public static final Set<String> FIELD_NAMES = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(ParsedLogRecord.DATE_TIME);
            this.add(ParsedLogRecord.LOG_LEVEL_NAME);
            this.add(ParsedLogRecord.PRODUCT_ID);
            this.add(ParsedLogRecord.LOGGER_NAME);
            this.add(ParsedLogRecord.THREAD_ID);
            this.add(ParsedLogRecord.THREAD_NAME);
            this.add(ParsedLogRecord.TIME_MILLIS);
            this.add(ParsedLogRecord.LOG_LEVEL_VALUE);
            this.add(ParsedLogRecord.SUPP_ATTRS);
            this.add(ParsedLogRecord.LOG_MESSAGE);
            this.add(ParsedLogRecord.MESSAGE_ID);
        }
    };
    private String formattedLogRecord;
    private boolean matchedLogQuery;
    private Map<String, Object> fields = new HashMap<String, Object>();

    public ParsedLogRecord() {
        this.fields.put(SUPP_ATTRS, new Properties());
    }

    public ParsedLogRecord(String formattedContent) {
        this.formattedLogRecord = formattedContent;
        this.fields.put(SUPP_ATTRS, new Properties());
    }

    @Override
    public String getTimestamp() {
        return (String)this.fields.get(DATE_TIME);
    }

    @Override
    public String getMessage() {
        return (String)this.fields.get(LOG_MESSAGE);
    }

    @Override
    public String getLevel() {
        return (String)this.fields.get(LOG_LEVEL_NAME);
    }

    @Override
    public String getLogger() {
        return (String)this.fields.get(LOGGER_NAME);
    }

    @Override
    public int getLevelValue() {
        String val = (String)this.fields.get(LOG_LEVEL_VALUE);
        return Integer.parseInt(val);
    }

    @Override
    public String getComponentId() {
        return (String)this.fields.get(PRODUCT_ID);
    }

    @Override
    public long getTimeMillis() {
        String val = (String)this.fields.get(TIME_MILLIS);
        if (val == null || val.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(val);
    }

    @Override
    public String getMessageId() {
        return (String)this.fields.get(MESSAGE_ID);
    }

    @Override
    public long getThreadId() {
        String val = (String)this.fields.get(THREAD_ID);
        return Long.parseLong(val);
    }

    @Override
    public String getThreadName() {
        return (String)this.fields.get(THREAD_NAME);
    }

    @Override
    public Map<String, Object> getSupplementalAttributes() {
        return (Map)this.fields.get(SUPP_ATTRS);
    }

    public String getFormattedLogRecord() {
        return this.formattedLogRecord;
    }

    public boolean isMatchedLogQuery() {
        return this.matchedLogQuery;
    }

    public Object getFieldValue(String name) {
        return this.fields.get(name);
    }

    void setFormattedLogRecord(String formattedLogRecord) {
        this.formattedLogRecord = formattedLogRecord;
    }

    void setMatchedLogQuery(boolean matchedLogQuery) {
        this.matchedLogQuery = matchedLogQuery;
    }

    void setFieldValue(String name, Object value) {
        this.fields.put(name, value);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Log record: <" + this.fields + ">" + LogParserFactory.NEWLINE);
        return buffer.toString();
    }
}

