/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-threadpools")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.threadpools")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=ThreadPools.class, opType=RestEndpoint.OpType.GET, path="list-threadpools", description="list-threadpools")})
public class ListThreadpools
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    @Inject
    Domain domain;
    @Param(name="target", primary=true, optional=true)
    String target;
    @Inject
    ServiceLocator habitat;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListThreadpools.class);
    private ThreadPools threadPools;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        if (StringUtils.ok((String)this.target)) {
            Config config = (Config)this.habitat.getService(Config.class, this.target, new Annotation[0]);
            if (config == null) {
                config = (Config)this.habitat.getService(Config.class, this.target + "-config", new Annotation[0]);
            }
            if (config != null) {
                this.threadPools = config.getThreadPools();
            }
        }
        return true;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!StringUtils.ok((String)this.target)) {
            List pools = this.habitat.getAllServiceHandles(ThreadPool.class, new Annotation[0]);
            HashSet<String> poolNames = new HashSet<String>();
            for (ServiceHandle poolHandle : pools) {
                poolNames.add(((ThreadPool)poolHandle.getService()).getName());
            }
            for (String poolName : poolNames) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(poolName);
            }
            return;
        }
        if (this.threadPools == null) {
            report.setMessage(localStrings.getLocalString("list.thread.pools.failed", "List Thread Pools failed because of: target " + this.target + " not found"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        try {
            List poolList = this.threadPools.getThreadPool();
            for (ThreadPool pool : poolList) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(pool.getName());
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            String str = e.getMessage();
            report.setMessage(localStrings.getLocalString("list.thread.pools.failed", "List Thread Pools failed because of: " + str));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

