/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.enterprise.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CLIUtil;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Transaction;

@Service(name="create-system-property")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@I18n(value="create.system.property")
public class CreateSystemProperty
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateSystemProperty.class);
    @Param(optional=true, defaultValue="server")
    String target;
    @Param(name="name_value", primary=true)
    String propertyAssignment;
    @Inject
    Domain domain;
    private SystemPropertyBag spb;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String[] assignment = this.propertyAssignment.split("=");
        try {
            String propertyName = assignment[0];
            String propertyValue = assignment[1];
            ConfigSupport.apply(propertyBag -> {
                for (SystemProperty property : propertyBag.getSystemProperty()) {
                    if (!property.getName().equals(propertyName)) continue;
                    Transaction transaction = Transaction.getTransaction((ConfigBeanProxy)propertyBag);
                    property = (SystemProperty)transaction.enroll((ConfigBeanProxy)property);
                    property.setValue(propertyValue);
                    return property;
                }
                SystemProperty newSysProp = (SystemProperty)propertyBag.createChild(SystemProperty.class);
                newSysProp.setName(propertyName);
                newSysProp.setValue(propertyValue);
                propertyBag.getSystemProperty().add(newSysProp);
                return newSysProp;
            }, (ConfigBeanProxy)this.spb);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.system.property.failed", "System property {0} creation failed", new Object[]{this.propertyAssignment}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }

    public Collection<? extends AccessRequired.AccessCheck<?>> getAccessChecks() {
        ArrayList result = new ArrayList();
        result.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)this.spb), "update"));
        return result;
    }

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.spb = CLIUtil.chooseTarget(this.domain, this.target);
        if (this.spb == null) {
            ActionReport report = context.getActionReport();
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target:{0}. Valid targets types are domain, config, cluster, default server, clustered instance, stand alone instance", new Object[]{this.target});
            report.setMessage(msg);
            return false;
        }
        return true;
    }
}

