/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.enterprise.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JvmOptionBag;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.admin.commands.CLIUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.UnknownOptionsAreOperands;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;

@Service(name="create-jvm-option")
@PerLookup
@I18n(value="create.jvm.option")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@UnknownOptionsAreOperands
public final class CreateJvmOption
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="profiler", optional=true)
    Boolean addToProfiler = false;
    @Param(name="assignment", primary=true)
    String jvmAssignment;
    @Param(name="min-jvm", optional=true)
    String minJVM;
    @Param(name="max-jvm", optional=true)
    String maxJVM;
    @Inject
    Target targetService;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    private static final StringManager lsm = StringManager.getManager(CreateJvmOption.class);
    @AccessRequired.To(value={"update"})
    private JavaConfig javaConfig;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.updateConfigIfNeeded(this.config, this.targetService, this.target);
        this.javaConfig = this.config.getJavaConfig();
        return true;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            JavaConfig bag;
            if (this.addToProfiler.booleanValue()) {
                if (this.javaConfig.getProfiler() == null) {
                    report.setMessage(lsm.getString("create.profiler.first"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                bag = this.javaConfig.getProfiler();
            } else {
                bag = this.javaConfig;
            }
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            String validOption = new MiniXmlParser.JvmOption((String)this.jvmAssignment).option;
            this.validate((JvmOptionBag)bag, validOption, report);
            this.validateHeapSize((JvmOptionBag)bag, validOption, report);
            this.add((JvmOptionBag)bag, this.jvmAssignment, part);
        }
        catch (IllegalArgumentException iae) {
            report.setMessage(iae.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        catch (Exception e) {
            String msg = e.getMessage() != null ? e.getMessage() : lsm.getStringWithDefault("create.jvm.options.failed", "Command: create-jvm-options failed", (Object[])new String[]{e.getMessage()});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void validateHeapSize(JvmOptionBag bag, String option, ActionReport report) {
        this.validateMax(bag, option, report);
        this.validateMin(bag, option, report);
    }

    private void validateMax(JvmOptionBag bag, String option, ActionReport report) throws IllegalArgumentException {
        int xmxGiven;
        int xmsInConfig;
        String existingXms;
        if (!option.startsWith("-Xmx")) {
            return;
        }
        Pattern regex = Pattern.compile("-Xmx((\\d)+[m|g|k|M|G|K]?)+");
        boolean matches = regex.matcher(option).matches();
        if (!matches) {
            String msg = lsm.getString("soft.invalid.xmx", (Object)option);
            report.getTopMessagePart().addChild().setMessage(msg);
            throw new IllegalArgumentException();
        }
        String existingXmx = bag.getStartingWith("-Xmx");
        if (existingXmx != null) {
            String msg = lsm.getString("soft.xmx.exists.singular", (Object)existingXmx, (Object)option);
            report.getTopMessagePart().addChild().setMessage(msg);
        }
        if ((existingXms = bag.getStartingWith("-Xms")) != null && (xmsInConfig = JvmOptionBag.Duck.toMeg((String)existingXms, (String)"-Xms")) > (xmxGiven = JvmOptionBag.Duck.toMeg((String)option, (String)"-Xmx"))) {
            String msg = lsm.getString("soft.xmx.smaller.than.xms", (Object)(xmxGiven + " MB"), (Object)(xmsInConfig + " MB"));
            report.getTopMessagePart().addChild().setMessage(msg);
            throw new IllegalArgumentException();
        }
    }

    private void validateMin(JvmOptionBag bag, String option, ActionReport report) throws IllegalArgumentException {
        String existingXmx;
        if (!option.startsWith("-Xms")) {
            return;
        }
        Pattern regex = Pattern.compile("-Xms((\\d)+[m|g|k|M|G|K]?)+");
        boolean matches = regex.matcher(option).matches();
        if (!matches) {
            String msg = lsm.getString("soft.invalid.xms", (Object)option);
            report.getTopMessagePart().addChild().setMessage(msg);
            throw new IllegalArgumentException();
        }
        String existingXms = bag.getStartingWith("-Xms");
        if (existingXms != null) {
            String msg = lsm.getString("soft.xms.exists.singular", (Object)existingXms, (Object)option);
            report.getTopMessagePart().addChild().setMessage(msg);
        }
        if ((existingXmx = bag.getStartingWith("-Xmx")) != null) {
            int xmxInConfig = JvmOptionBag.Duck.toMeg((String)existingXmx, (String)"-Xmx");
            int xmsGiven = JvmOptionBag.Duck.toMeg((String)option, (String)"-Xms");
            if (xmsGiven > xmxInConfig) {
                String msg = lsm.getString("soft.xms.larger.than.xmx", (Object)(xmsGiven + " MB"), (Object)(xmxInConfig + " MB"));
                report.getTopMessagePart().addChild().setMessage(msg);
                throw new IllegalArgumentException();
            }
        }
    }

    private void validate(JvmOptionBag bag, String option, ActionReport report) throws IllegalArgumentException {
        if (!option.startsWith("-") && !option.startsWith("${ENV=")) {
            String msg = lsm.getString("joe.invalid.start", (Object)option);
            throw new IllegalArgumentException(msg);
        }
        if (bag.contains(option)) {
            String msg = lsm.getString("joe.exists", (Object)option);
            throw new IllegalArgumentException(msg);
        }
    }

    private void add(JvmOptionBag bag, String option, ActionReport.MessagePart part) throws Exception {
        SingleConfigCode scc = bag1 -> {
            List unversionedCurrentOptions = bag1.getJvmOptions();
            if (!unversionedCurrentOptions.contains(new MiniXmlParser.JvmOption((String)option).option)) {
                ArrayList<String> jvmopts = new ArrayList<String>(bag1.getJvmRawOptions());
                if (option.startsWith("-Xms") && bag1.getStartingWith("-Xms") != null) {
                    jvmopts.removeIf(entry -> entry.startsWith("-Xms"));
                } else if (option.startsWith("-Xmx") && bag1.getStartingWith("-Xmx") != null) {
                    jvmopts.removeIf(entry -> entry.startsWith("-Xmx"));
                }
                jvmopts.add(MiniXmlParser.JvmOption.hasVersionPattern((String)option) ? new MiniXmlParser.JvmOption(option).toString() : new MiniXmlParser.JvmOption(option, this.minJVM, this.maxJVM).toString());
                bag1.setJvmOptions(jvmopts);
                part.setMessage(lsm.getString("jvm.option.created", (Object)option));
            } else {
                part.setMessage(lsm.getString("no.option.created"));
            }
            return true;
        };
        ConfigSupport.apply((SingleConfigCode)scc, (ConfigBeanProxy)bag);
    }
}

