/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.monitoring.rest.service;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.appserver.monitoring.rest.service.RestMonitoringLoader;
import fish.payara.appserver.monitoring.rest.service.adapter.RestMonitoringAdapter;
import fish.payara.appserver.monitoring.rest.service.adapter.RestMonitoringEndpointDecider;
import fish.payara.appserver.monitoring.rest.service.configuration.RestMonitoringConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="rest-monitoring")
@RunLevel(value=20)
public class RestMonitoringService
implements ConfigListener {
    public static final String DEFAULT_REST_MONITORING_APP_NAME = "__restmonitoring";
    private boolean startAttempted = false;
    private String contextRoot;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    private RestMonitoringConfiguration restMonitoringConfiguration;
    @Inject
    private RestMonitoringAdapter restMonitoringAdapter;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironmentImpl serverEnv;
    @Inject
    ServiceLocator habitat;

    @PostConstruct
    private void postConstruct() {
        this.contextRoot = this.restMonitoringAdapter.getContextRoot();
        this.restMonitoringConfiguration = (RestMonitoringConfiguration)this.habitat.getService(RestMonitoringConfiguration.class, new Annotation[0]);
        if (this.restMonitoringConfiguration.getEnabled().equals("true")) {
            this.loadApplication();
        }
    }

    private void loadApplication() {
        this.startAttempted = true;
        try {
            new RestMonitoringLoader(this.restMonitoringAdapter, this.habitat, this.domain, this.serverEnv, this.contextRoot, this.restMonitoringConfiguration.getApplicationName(), this.restMonitoringAdapter.getVirtualServers()).start();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load rest monitoring!", ex);
        }
    }

    private void loadApplication(boolean dynamicStart) {
        this.startAttempted = true;
        try {
            new RestMonitoringLoader(this.restMonitoringAdapter, this.habitat, this.domain, this.serverEnv, this.contextRoot, this.restMonitoringConfiguration.getApplicationName(), this.restMonitoringAdapter.getVirtualServers(), dynamicStart).start();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load rest monitoring!", ex);
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        ArrayList<UnprocessedChangeEvent> unprocessedChanges = new ArrayList<UnprocessedChangeEvent>();
        boolean dynamicStart = false;
        for (PropertyChangeEvent propertyChangeEvent : propertyChangeEvents) {
            if (!propertyChangeEvent.getSource().toString().equals("GlassFishConfigBean." + RestMonitoringConfiguration.class.getName()) || !this.isCurrentInstanceMatchTarget(propertyChangeEvent) || propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue())) continue;
            if (!this.startAttempted) {
                if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                    dynamicStart = true;
                    continue;
                }
                if (!propertyChangeEvent.getPropertyName().equals("context-root")) continue;
                Config serverConfig = this.domain.getServerNamed(this.serverEnv.getInstanceName()).getConfig();
                RestMonitoringEndpointDecider endpointDecider = new RestMonitoringEndpointDecider(serverConfig, this.restMonitoringConfiguration);
                this.contextRoot = endpointDecider.getContextRoot();
                continue;
            }
            if (propertyChangeEvent.getPropertyName().equals("security-enabled")) continue;
            unprocessedChanges.add(new UnprocessedChangeEvent(propertyChangeEvent, "Rest monitoring redeployment required"));
        }
        if (dynamicStart) {
            this.loadApplication(true);
        }
        if (unprocessedChanges.isEmpty()) {
            return null;
        }
        return new UnprocessedChangeEvents(unprocessedChanges);
    }

    private boolean isCurrentInstanceMatchTarget(PropertyChangeEvent propertyChangeEvent) {
        ConfigBeanProxy proxy;
        if (this.serverEnv.isInstance()) {
            return true;
        }
        for (proxy = (ConfigBeanProxy)propertyChangeEvent.getSource(); proxy != null && !(proxy instanceof Config); proxy = proxy.getParent()) {
        }
        if (proxy != null) {
            return ((Config)proxy).isDas();
        }
        return false;
    }
}

