/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.monitoring.rest.service.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import fish.payara.appserver.monitoring.rest.service.configuration.RestMonitoringConfiguration;
import fish.payara.appserver.monitoring.rest.service.security.RestMonitoringAuthModule;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-rest-monitoring-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=RestMonitoringConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-rest-monitoring-configuration", description="Sets the Rest Monitoring Configuration")})
public class SetRestMonitoringConfigurationCommand
implements AdminCommand {
    private static final String AUTH_MODULE_NAME = "RestMonitoringAuthModule";
    private static final String DEFAULT_USER_NAME = "payara";
    private static final Logger LOGGER = Logger.getLogger(SetRestMonitoringConfigurationCommand.class.getName());
    @Param(optional=true, defaultValue="server-config")
    String target;
    @Param(optional=true)
    Boolean enabled;
    @Param(optional=true, alias="contextroot")
    String contextRoot;
    @Param(optional=true, alias="applicationname")
    String applicationName;
    @Param(optional=true, alias="securityenabled")
    Boolean securityEnabled;
    @Inject
    private Target targetUtil;
    @Inject
    ServiceLocator habitat;
    @Inject
    ServerEnvironment serverEnv;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Domain domain;

    @Override
    public void execute(AdminCommandContext context) {
        Config targetConfig = this.targetUtil.getConfig(this.target);
        RestMonitoringConfiguration restMonitoringConfiguration = (RestMonitoringConfiguration)targetConfig.getExtensionByType(RestMonitoringConfiguration.class);
        ActionReport actionReport = context.getActionReport();
        Subject subject = context.getSubject();
        if (!this.messageSecurityProviderExists(actionReport.addSubActionsReport(), context.getSubject())) {
            this.createRequiredMessageSecurityProvider(actionReport.addSubActionsReport(), subject);
        }
        if (!this.defaultRestMonitoringUserExists(actionReport.addSubActionsReport(), subject)) {
            this.createDefaultRestMonitoringUser(actionReport.addSubActionsReport(), subject);
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<RestMonitoringConfiguration>(){

                public Object run(RestMonitoringConfiguration configProxy) throws PropertyVetoException {
                    if (SetRestMonitoringConfigurationCommand.this.enabled != null) {
                        configProxy.setEnabled(SetRestMonitoringConfigurationCommand.this.enabled.toString());
                    }
                    if (SetRestMonitoringConfigurationCommand.this.contextRoot != null) {
                        configProxy.setContextRoot(SetRestMonitoringConfigurationCommand.this.contextRoot);
                    }
                    if (SetRestMonitoringConfigurationCommand.this.applicationName != null) {
                        configProxy.setApplicationName(SetRestMonitoringConfigurationCommand.this.applicationName);
                    }
                    if (SetRestMonitoringConfigurationCommand.this.securityEnabled != null) {
                        configProxy.setSecurityEnabled(SetRestMonitoringConfigurationCommand.this.securityEnabled.toString());
                    }
                    return null;
                }
            }, (ConfigBeanProxy)restMonitoringConfiguration);
        }
        catch (TransactionFailure ex) {
            context.getActionReport().failure(LOGGER, "Failed to update Rest Monitoring configuration", ex);
        }
        if (Boolean.parseBoolean(restMonitoringConfiguration.getSecurityEnabled()) && !SecureAdmin.Util.isEnabled((SecureAdmin)this.domain.getSecureAdmin())) {
            actionReport.appendMessage("\n---WARNING---\nSecure Admin is not enabled! - it is highly recommended that you do so to properly secure the Rest Monitoring service.\n");
        }
        if (!actionReport.hasFailures() || !actionReport.hasWarnings()) {
            actionReport.getSubActionsReport().clear();
        }
    }

    private boolean messageSecurityProviderExists(ActionReport subActionReport, Subject subject) {
        boolean exists = false;
        CommandRunner.CommandInvocation invocation = this.commandRunner.getCommandInvocation("list-message-security-providers", subActionReport, subject, false);
        ParameterMap parameters = new ParameterMap();
        parameters.add("layer", "HttpServlet");
        invocation.parameters(parameters).execute();
        for (ActionReport.MessagePart message : subActionReport.getTopMessagePart().getChildren()) {
            if (!message.getMessage().equals(AUTH_MODULE_NAME)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    private void createRequiredMessageSecurityProvider(ActionReport subActionReport, Subject subject) {
        CommandRunner.CommandInvocation invocation = this.commandRunner.getCommandInvocation("create-message-security-provider", subActionReport, subject, false);
        ParameterMap parameters = new ParameterMap();
        parameters.add("classname", RestMonitoringAuthModule.class.getName());
        parameters.add("isdefaultprovider", "false");
        parameters.add("layer", "HttpServlet");
        parameters.add("providertype", "server");
        parameters.add("target", this.target);
        parameters.add("requestauthsource", "sender");
        parameters.add("DEFAULT", AUTH_MODULE_NAME);
        invocation.parameters(parameters).execute();
    }

    private boolean defaultRestMonitoringUserExists(ActionReport subActionReport, Subject subject) {
        boolean exists = false;
        CommandRunner.CommandInvocation invocation = this.commandRunner.getCommandInvocation("list-file-users", subActionReport, subject, false);
        ParameterMap parameters = new ParameterMap();
        parameters.add("authrealmname", "file");
        invocation.parameters(parameters).execute();
        for (ActionReport.MessagePart message : subActionReport.getTopMessagePart().getChildren()) {
            if (!message.getMessage().equals(DEFAULT_USER_NAME)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    private void createDefaultRestMonitoringUser(ActionReport subActionReport, Subject subject) {
        CommandRunner.CommandInvocation invocation = this.commandRunner.getCommandInvocation("create-file-user", subActionReport, subject, false);
        ParameterMap parameters = new ParameterMap();
        parameters.add("groups", "rest-monitoring");
        parameters.add("userpassword", "rest");
        parameters.add("target", this.target);
        parameters.add("authrealmname", "file");
        parameters.add("DEFAULT", DEFAULT_USER_NAME);
        invocation.parameters(parameters).execute();
    }
}

