/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.cluster.SynchronizeInstanceCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.util.TimeoutParamDefaultCalculator;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.ObjectAnalyzer;
import jakarta.inject.Inject;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-local-instance")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
public class RestartLocalInstanceCommand
extends SynchronizeInstanceCommand {
    @Param(optional=true, shortName="d", defaultValue="false")
    private Boolean debug;
    @Param(optional=true, defaultCalculator=TimeoutParamDefaultCalculator.class)
    private int timeout;
    @Inject
    private ServiceLocator habitat;

    @Override
    protected int executeCommand() throws CommandException {
        File serverDir;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString());
        }
        if ((serverDir = this.getServerDirs().getServerDir()) == null || !serverDir.isDirectory()) {
            return this.noSuchInstance();
        }
        String serverName = this.getServerDirs().getServerName();
        HostAndPort addr = this.getAdminAddress(serverName);
        if (!this.isRunning() && !this.isRunning(addr.getHost(), addr.getPort())) {
            return this.instanceNotRunning();
        }
        if (this.sync.equals("none")) {
            logger.info(Strings.get("Instance.nosync"));
        } else if (!this.synchronizeInstance()) {
            File domainXml = new File(new File(this.instanceDir, "config"), "domain.xml");
            if (!domainXml.exists()) {
                logger.info(Strings.get("Instance.nodomainxml"));
                return 1;
            }
            logger.info(Strings.get("Instance.syncFailed"));
        }
        this.programOpts.setHostAndPort(addr);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Stopping server at {0}", addr);
        }
        logger.finer("It's the correct Instance");
        return this.doRemoteCommand();
    }

    protected final int doRemoteCommand() throws CommandException {
        this.setLocalPassword();
        this.programOpts.setInteractive(false);
        if (!this.isRestartable()) {
            throw new CommandException(Strings.get("restart.notRestartable"));
        }
        int oldServerPid = this.getServerPid();
        RemoteCLICommand cmd = new RemoteCLICommand("_restart-instance", this.programOpts, this.env);
        if (this.debug != null) {
            cmd.executeAndReturnOutput(new String[]{"_restart-instance", "--debug", this.debug.toString()});
        } else {
            cmd.executeAndReturnOutput(new String[]{"_restart-instance"});
        }
        this.waitForRestart(oldServerPid, this.timeout * 1000);
        return 0;
    }

    protected int instanceNotRunning() throws CommandException {
        logger.warning(Strings.get("restart.instanceNotRunning"));
        CLICommand cmd = (CLICommand)this.habitat.getService(CLICommand.class, "start-local-instance", new Annotation[0]);
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("start-local-instance");
        if (this.debug != null) {
            opts.add("--debug");
            opts.add(this.debug.toString());
        }
        if (this.nodeDir != null) {
            opts.add("--nodedir");
            opts.add(this.nodeDir);
        }
        if (this.node != null) {
            opts.add("--node");
            opts.add(this.node);
        }
        if (this.sync != null) {
            opts.add("--sync");
            opts.add(this.sync);
        }
        if (this.instanceName != null) {
            opts.add(this.instanceName);
        }
        return cmd.execute(opts.toArray(new String[opts.size()]));
    }

    @Override
    protected boolean mkdirs(File f) {
        return false;
    }

    @Override
    protected void validate() throws CommandException {
        super.validate();
        if (this.timeout <= 0) {
            throw new CommandException("Timeout must be at least 1 second long.");
        }
        File dir = this.getServerDirs().getServerDir();
        if (!dir.isDirectory()) {
            throw new CommandException(Strings.get("Instance.noSuchInstance"));
        }
    }

    private int noSuchInstance() {
        logger.warning(Strings.get("Instance.noSuchInstance"));
        return 0;
    }

    public String toString() {
        return ObjectAnalyzer.toStringWithSuper((Object)((Object)this));
    }
}

