/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha;

import com.sun.enterprise.security.auth.digest.impl.CNonceCacheImpl;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.NonceInfo;
import org.glassfish.web.ha.LogFacade;
import org.jvnet.hk2.annotations.Service;

@Service(name="HA-CNonceCache")
@PerLookup
public class HACNonceCacheImpl
implements CNonceCache {
    private static final Logger logger = LogFacade.getLogger();
    private static final String BS_TYPE_REPLICATED = "replicated";
    @Inject
    private ServiceLocator services;
    private CNonceCacheImpl localStore;
    private BackingStore<String, NonceInfo> backingStore;
    private String storeName;
    private Map<String, String> props;

    public void setCnonceCacheSize(long cnonceCacheSize) {
        this.localStore.setCnonceCacheSize(cnonceCacheSize);
    }

    public void setNonceValidity(long nonceValidity) {
        this.localStore.setNonceValidity(nonceValidity);
    }

    public long getCnonceCacheSize() {
        return this.localStore.getCnonceCacheSize();
    }

    public long getNonceValidity() {
        return this.localStore.getNonceValidity();
    }

    public int size() {
        return this.localStore.size();
    }

    public boolean isEmpty() {
        return this.localStore.isEmpty();
    }

    public boolean containsKey(Object o) {
        return this.localStore.containsKey((Object)((String)o));
    }

    public boolean containsValue(Object o) {
        return this.localStore.containsValue((Object)((NonceInfo)o));
    }

    public NonceInfo get(Object o) {
        NonceInfo ret = (NonceInfo)this.localStore.get((Object)((String)o));
        if (ret == null && this.backingStore != null) {
            try {
                return (NonceInfo)this.backingStore.load((Serializable)((Object)((String)o)), null);
            }
            catch (BackingStoreException ex) {
                logger.log(Level.WARNING, null, ex);
            }
        }
        return ret;
    }

    public NonceInfo put(String key, NonceInfo value) {
        NonceInfo ret = (NonceInfo)this.localStore.put((Object)key, (Object)value);
        if (this.backingStore == null) {
            return ret;
        }
        try {
            if (this.removeEldestEntry(null)) {
                this.backingStore.remove((Serializable)((Object)this.localStore.getEldestCNonce()));
            }
            this.backingStore.save((Serializable)((Object)key), (Serializable)value, true);
        }
        catch (BackingStoreException ex) {
            logger.log(Level.WARNING, null, ex);
        }
        return ret;
    }

    public NonceInfo remove(Object o) {
        NonceInfo ret = (NonceInfo)this.localStore.remove((Object)((String)o));
        if (this.backingStore == null) {
            return ret;
        }
        try {
            this.backingStore.remove((Serializable)((Object)((String)o)));
        }
        catch (BackingStoreException ex) {
            logger.log(Level.WARNING, null, ex);
        }
        return ret;
    }

    public void putAll(Map<? extends String, ? extends NonceInfo> map) {
        throw new UnsupportedOperationException("putAll : Not  Supported");
    }

    public void clear() {
        if (this.backingStore != null) {
            for (String key : this.keySet()) {
                try {
                    this.backingStore.remove((Serializable)((Object)key));
                }
                catch (BackingStoreException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
        }
        this.localStore.clear();
    }

    public Set<String> keySet() {
        return this.localStore.keySet();
    }

    public Collection<NonceInfo> values() {
        return this.localStore.values();
    }

    public Set<Map.Entry<String, NonceInfo>> entrySet() {
        return this.localStore.entrySet();
    }

    protected boolean removeEldestEntry(Map.Entry<String, NonceInfo> eldest) {
        return (long)this.size() > this.getCnonceCacheSize();
    }

    public void postConstruct() {
        this.localStore = new CNonceCacheImpl();
        try {
            BackingStoreConfiguration bsConfig = new BackingStoreConfiguration();
            bsConfig.setClusterName(this.props.get("cluster_name")).setInstanceName(this.props.get("instance_name")).setStoreName(this.storeName).setKeyClazz(String.class).setValueClazz(NonceInfo.class);
            this.backingStore = ((BackingStoreFactory)this.services.getService(BackingStoreFactory.class, BS_TYPE_REPLICATED, new Annotation[0])).createBackingStore(bsConfig);
        }
        catch (BackingStoreException ex) {
            logger.log(Level.WARNING, null, ex);
        }
    }

    public void init(long size, String name, long validity, Map<String, String> props) {
        this.storeName = name;
        this.props = props;
        this.postConstruct();
        this.localStore.setCnonceCacheSize(size);
        this.localStore.setNonceValidity(validity);
    }

    public void destroy() {
        this.clear();
        try {
            if (this.backingStore != null) {
                this.backingStore.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

