/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMain;
import com.sun.enterprise.glassfish.bootstrap.ClassPathBuilder;
import com.sun.enterprise.glassfish.bootstrap.Constants;
import com.sun.enterprise.glassfish.bootstrap.LogFacade;
import com.sun.enterprise.glassfish.bootstrap.StartupContextUtil;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import com.sun.enterprise.module.bootstrap.Which;
import com.sun.enterprise.util.JDK;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MainHelper {
    private static final Logger logger = LogFacade.BOOTSTRAP_LOGGER;

    static void checkJdkVersion() {
        if (!JDK.isRunningLTSJDK()) {
            logger.warning("You are running the product on an unsupported JDK version and might see unexpected results or exceptions.");
        }
    }

    static String whichPlatform() {
        String trimtemp;
        String platform = Constants.Platform.Felix.toString();
        String temp = System.getProperty("GlassFish_Platform");
        if (temp == null || temp.trim().length() <= 0) {
            temp = System.getenv("GlassFish_Platform");
        }
        if (temp != null && (trimtemp = temp.trim()).length() != 0) {
            platform = trimtemp;
        }
        return platform;
    }

    public static Properties parseAsEnv(File installRoot) {
        Properties asenvProps = new Properties();
        File configDir = new File(installRoot, "config");
        File asenv = MainHelper.getAsEnvConf(configDir);
        if (!asenv.exists()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(asenv.getAbsolutePath() + " not found, ignoring");
            }
            return asenvProps;
        }
        BufferedReader lnReader = null;
        try {
            lnReader = new LineNumberReader(new FileReader(asenv));
            String line = ((LineNumberReader)lnReader).readLine();
            Pattern p = Pattern.compile("(?i)(set +)?([^=]*)=\"?([^\"]*)\"?");
            while (line != null) {
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    File f = new File(m.group(3));
                    if (!f.isAbsolute()) {
                        f = new File(configDir, m.group(3));
                        if (f.exists()) {
                            asenvProps.put(m.group(2), f.getAbsolutePath());
                        } else {
                            asenvProps.put(m.group(2), m.group(3));
                        }
                    } else {
                        asenvProps.put(m.group(2), m.group(3));
                    }
                }
                line = ((LineNumberReader)lnReader).readLine();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error opening asenv.conf : ", ioe);
        }
        finally {
            try {
                if (lnReader != null) {
                    lnReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return asenvProps;
    }

    private static File getAsEnvConf(File configDir) {
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Windows") == -1) {
            return new File(configDir, "asenv.conf");
        }
        return new File(configDir, "asenv.bat");
    }

    static File getDomainRoot(Properties args, Properties asEnv) {
        String domainDir = MainHelper.getParam(args, "domaindir");
        if (MainHelper.ok(domainDir)) {
            return new File(domainDir);
        }
        File defDomainsRoot = MainHelper.getDefaultDomainsDir(asEnv);
        String domainName = MainHelper.getParam(args, "domain");
        if (MainHelper.ok(domainName)) {
            return new File(defDomainsRoot, domainName);
        }
        return MainHelper.getDefaultDomain(defDomainsRoot);
    }

    static void verifyDomainRoot(File domainRoot) {
        String msg = null;
        if (domainRoot == null) {
            msg = "Internal Error: The domain dir is null.";
        } else if (!domainRoot.exists()) {
            msg = "the domain directory does not exist";
        } else if (!domainRoot.isDirectory()) {
            msg = "the domain directory is not a directory.";
        } else if (!domainRoot.canWrite()) {
            msg = "the domain directory is not writable.";
        } else if (!new File(domainRoot, "config").isDirectory()) {
            msg = "the domain directory is corrupt - there is no config subdirectory.";
        }
        if (msg != null) {
            throw new RuntimeException(msg);
        }
    }

    private static File getDefaultDomainsDir(Properties asEnv) {
        String dirname = asEnv.getProperty("AS_DEF_DOMAINS_PATH");
        if (!MainHelper.ok(dirname)) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH is not set.");
        }
        File domainsDir = MainHelper.absolutize(new File(dirname));
        if (!domainsDir.isDirectory()) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH[" + dirname + "] is specifying a file that is NOT a directory.");
        }
        return domainsDir;
    }

    private static File getDefaultDomain(File domainsDir) {
        File[] domains = domainsDir.listFiles(f -> f.isDirectory());
        if (domains == null || domains.length == 0) {
            throw new RuntimeException("no domain directories found under " + domainsDir);
        }
        if (domains.length > 1) {
            throw new RuntimeException("Multiple domains[" + domains.length + "] found under " + domainsDir + " -- you must specify a domain name as -domain <name>");
        }
        return domains[0];
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static String getParam(Properties map, String name) {
        String val = map.getProperty("-" + name);
        if (val == null) {
            val = map.getProperty("--" + name);
        }
        return val;
    }

    private static File absolutize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return f.getAbsoluteFile();
        }
    }

    static File getInstanceRoot(Properties args, Properties asEnv) {
        String instanceDir = MainHelper.getParam(args, "instancedir");
        if (MainHelper.ok(instanceDir)) {
            return new File(instanceDir);
        }
        return null;
    }

    static File findInstallRoot() {
        File bootstrapFile = MainHelper.findBootstrapFile();
        return bootstrapFile.getParentFile().getParentFile();
    }

    static File findInstanceRoot(File installRoot, Properties args) {
        Properties asEnv = MainHelper.parseAsEnv(installRoot);
        File instanceDir = MainHelper.getInstanceRoot(args, asEnv);
        if (instanceDir == null) {
            instanceDir = MainHelper.getDomainRoot(args, asEnv);
        }
        MainHelper.verifyDomainRoot(instanceDir);
        return instanceDir;
    }

    static File findInstanceRoot(File installRoot, String[] args) {
        return MainHelper.findInstanceRoot(installRoot, ArgumentManager.argsToMap(args));
    }

    private static File findBootstrapFile() {
        try {
            return Which.jarFile(ASMain.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get bootstrap path from " + ASMain.class + " class location, aborting");
        }
    }

    static Properties buildStartupContext(String platform, File installRoot, File instanceRoot, String[] args) {
        Properties ctx = ArgumentManager.argsToMap(args);
        ctx.setProperty("__time_zero", Long.toString(System.currentTimeMillis()));
        ctx.setProperty("GlassFish_Platform", platform);
        ctx.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
        ctx.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        ctx.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
        ctx.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        if (ctx.getProperty("hk2.startup.context.mainModule") == null) {
            ctx.setProperty("hk2.startup.context.mainModule", "org.glassfish.core.kernel");
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-upgrade") || i + 1 >= args.length || args[i + 1].equals("false")) continue;
            ctx.setProperty("hk2.startup.context.moduleStartup", "upgrade");
        }
        MainHelper.addRawStartupInfo(args, ctx);
        MainHelper.mergePlatformConfiguration(ctx);
        return ctx;
    }

    public static Properties buildStaticStartupContext(long timeZero, String ... args) {
        MainHelper.checkJdkVersion();
        Properties ctx = ArgumentManager.argsToMap(args);
        ctx.setProperty("GlassFish_Platform", "Static");
        MainHelper.buildStartupContext(ctx);
        MainHelper.addRawStartupInfo(args, ctx);
        ctx.setProperty("__time_zero", Long.toString(timeZero));
        for (String key : new String[]{"com.sun.aas.installRoot", "com.sun.aas.instanceRootURI", "com.sun.aas.installRoot", "com.sun.aas.installRootURI"}) {
            System.setProperty(key, ctx.getProperty(key));
        }
        return ctx;
    }

    public static void buildStartupContext(Properties ctx) {
        File installRoot;
        if (ctx.getProperty("__time_zero") != null) {
            return;
        }
        ctx.setProperty("__time_zero", Long.toString(System.currentTimeMillis()));
        if (ctx.getProperty("GlassFish_Platform") == null) {
            ctx.setProperty("GlassFish_Platform", Constants.Platform.Felix.name());
        }
        if (ctx.getProperty("com.sun.aas.installRoot") == null) {
            installRoot = MainHelper.findInstallRoot();
            ctx.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
            ctx.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        }
        if (ctx.getProperty("com.sun.aas.instanceRoot") == null) {
            installRoot = new File(ctx.getProperty("com.sun.aas.installRoot"));
            File instanceRoot = MainHelper.findInstanceRoot(installRoot, ctx);
            ctx.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
            ctx.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        }
        if (ctx.getProperty("hk2.startup.context.mainModule") == null) {
            ctx.setProperty("hk2.startup.context.mainModule", "org.glassfish.core.kernel");
        }
        if (!ctx.contains("--noforcedshutdown")) {
            ctx.setProperty("--noforcedshutdown", Boolean.FALSE.toString());
        }
        MainHelper.mergePlatformConfiguration(ctx);
    }

    private static void addRawStartupInfo(String[] args, Properties p) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",,,");
            }
            sb.append(args[i]);
        }
        if (!MainHelper.wasStartedByCLI(p)) {
            p.put("-startup-classpath", System.getProperty("java.class.path"));
            p.put("-startup-classname", ASMain.class.getName());
            p.put("-startup-args", sb.toString());
        }
    }

    private static boolean wasStartedByCLI(Properties props) {
        return props.getProperty("-asadmin-classpath") != null && props.getProperty("-asadmin-classname") != null && props.getProperty("-asadmin-args") != null;
    }

    static ClassLoader createLauncherCL(Properties ctx, ClassLoader delegate) {
        try {
            ClassLoader osgiFWLauncherCL = MainHelper.createOSGiFrameworkLauncherCL(ctx, delegate);
            ClassLoaderBuilder clb = new ClassLoaderBuilder(ctx, osgiFWLauncherCL);
            clb.addLauncherJar();
            return clb.build();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static ClassLoader createOSGiFrameworkLauncherCL(Properties ctx, ClassLoader delegate) {
        try {
            ClassLoaderBuilder clb = new ClassLoaderBuilder(ctx, delegate);
            clb.addFrameworkJars();
            clb.addBootstrapApiJar();
            ClassLoader classLoader = clb.build();
            String bootstrapApiPackages = MainHelper.readExports(new File(ctx.getProperty("com.sun.aas.installRoot"), "modules" + File.separator + "simple-glassfish-api.jar").toURI().toURL());
            logger.log(Level.FINE, "Setting OSGi Framework System Packages Extra property to:\n" + bootstrapApiPackages);
            ctx.setProperty("org.osgi.framework.system.packages.extra", bootstrapApiPackages);
            return classLoader;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static String readExports(URL url) {
        String string;
        JarInputStream is = new JarInputStream(url.openStream());
        try {
            Manifest manifest = is.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            string = attributes.getValue("Export-Package");
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not parse manifest from " + url, e);
            }
        }
        is.close();
        return string;
    }

    static void setSystemProperties(Properties ctx) {
        System.setProperty("GlassFish_Platform", ctx.getProperty("GlassFish_Platform"));
    }

    static void mergePlatformConfiguration(Properties ctx) {
        Properties platformConf = null;
        try {
            platformConf = PlatformHelper.getPlatformHelper(ctx).readPlatformConfiguration();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        platformConf.putAll((Map<?, ?>)ctx);
        Util.substVars(platformConf);
        Util.overrideBySystemProps(platformConf, Arrays.asList("felix.fileinstall.dir", "felix.fileinstall.log.level"));
        ctx.clear();
        ctx.putAll((Map<?, ?>)platformConf);
    }

    static boolean isOSGiPlatform(String platform) {
        Constants.Platform p = Constants.Platform.valueOf(platform);
        switch (p) {
            case Felix: 
            case Knopflerfish: 
            case Equinox: {
                return true;
            }
        }
        return false;
    }

    void addPaths(File dir, String[] jarPrefixes, List<URL> urls) throws MalformedURLException {
        File[] jars = dir.listFiles();
        if (jars != null) {
            for (File f : jars) {
                for (String prefix : jarPrefixes) {
                    String name = f.getName();
                    if (!name.startsWith(prefix) || !name.endsWith(".jar")) continue;
                    urls.add(f.toURI().toURL());
                }
            }
        }
    }

    void verifyAndSetDomainRoot(File domainRoot) {
        MainHelper.verifyDomainRoot(domainRoot);
        domainRoot = MainHelper.absolutize(domainRoot);
        System.setProperty("com.sun.aas.instanceRoot", domainRoot.getPath());
    }

    public static class HotSwapHelper {
        private static final String HOTSWAP_TRANSFORMER = "org.hotswap.agent.util.HotswapTransformer";
        private static final String BUNDLE_CLASSLOADER = "org.apache.felix.framework.BundleWiringImpl$BundleClassLoader";
        private static final String PROVIDER_GENERATOR_CLASSLOADER = "org.glassfish.flashlight.impl.core.ProviderSubClassImplGenerator$SubClassLoader";
        private static final String JDK_PLATFORM_CLASSLOADER = "jdk.internal.loader.ClassLoaders$PlatformClassLoader";
        private static final String JDK_APP_CLASSLOADER = "jdk.internal.loader.ClassLoaders$AppClassLoader";
        private static final String BOOTSTRAP_CLASSLOADER = "null";
        private static final String METHODUTIL_CLASSLOADER = "sun.reflect.misc.MethodUtil";
        private static final String HK2_DELEGATING_CLASSLOADER = "org.jvnet.hk2.internal.DelegatingClassLoader";
        private static final String CURRENT_BEFORE_PARENT_CLASSLOADER = "com.sun.enterprise.loader.CurrentBeforeParentClassLoader";
        private static final String HOTSWAP_VM_KEY = "java.vm.name";
        private static final String HOTSWAP_VM_VALUE = "Dynamic Code Evolution";
        private static final String HOTSWAP_PLUGIN_MANAGER = "org.hotswap.agent.config.PluginManager";
        private static Object hotswapManager = null;

        public static void updateHotSwapClassLoaderConfig() {
            try {
                if (HotSwapHelper.isHotswapEnabled()) {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(HOTSWAP_TRANSFORMER);
                    if (clazz == null) {
                        logger.log(Level.INFO, "HotSwap Agent not enabled.");
                        return;
                    }
                    Field fld = clazz.getDeclaredField("skippedClassLoaders");
                    fld.setAccessible(true);
                    Set skippedClassLoaders = (Set)fld.get(null);
                    skippedClassLoaders.add(BUNDLE_CLASSLOADER);
                    skippedClassLoaders.add(PROVIDER_GENERATOR_CLASSLOADER);
                    skippedClassLoaders.add(JDK_PLATFORM_CLASSLOADER);
                    skippedClassLoaders.add(JDK_APP_CLASSLOADER);
                    skippedClassLoaders.add(BOOTSTRAP_CLASSLOADER);
                    skippedClassLoaders.add(METHODUTIL_CLASSLOADER);
                    skippedClassLoaders.add(HK2_DELEGATING_CLASSLOADER);
                    skippedClassLoaders.add(CURRENT_BEFORE_PARENT_CLASSLOADER);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }

        public static void hotswap(Map<Class<?>, byte[]> reloadMap) {
            try {
                HotSwapHelper.getPluginManager().getClass().getMethod("hotswap", Map.class).invoke(HotSwapHelper.getPluginManager(), reloadMap);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }

        public static void closeClassLoader(ClassLoader classLoader) {
            try {
                if (HotSwapHelper.isHotswapEnabled()) {
                    HotSwapHelper.getPluginManager().getClass().getMethod("closeClassLoader", ClassLoader.class).invoke(HotSwapHelper.getPluginManager(), classLoader);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }

        public static boolean isHotswapEnabled() {
            return System.getProperty(HOTSWAP_VM_KEY).contains(HOTSWAP_VM_VALUE);
        }

        private static Object getPluginManager() throws Exception {
            if (hotswapManager == null) {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                hotswapManager = classLoader.loadClass(HOTSWAP_PLUGIN_MANAGER).getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            return hotswapManager;
        }
    }

    static class StaticHelper
    extends PlatformHelper {
        StaticHelper() {
        }

        @Override
        protected void setFwDir() {
        }

        @Override
        protected void addFrameworkJars(ClassPathBuilder cpb) throws IOException {
        }

        @Override
        protected File getFrameworkConfigFile() {
            return null;
        }
    }

    static class KnopflerfishHelper
    extends PlatformHelper {
        public static final String GF_KF_HOME = "osgi/knopflerfish.org/osgi/";
        private static final String KF_HOME = "KNOPFLERFISH_HOME";

        KnopflerfishHelper() {
        }

        @Override
        protected void setFwDir() {
            String fwPath = System.getenv(KF_HOME);
            if (fwPath == null) {
                fwPath = new File(this.glassfishDir, GF_KF_HOME).getAbsolutePath();
            }
            this.fwDir = new File(fwPath);
            if (!this.fwDir.exists()) {
                throw new RuntimeException("Can't locate KnopflerFish at " + fwPath);
            }
        }

        @Override
        protected void addFrameworkJars(ClassPathBuilder cpb) throws IOException {
            cpb.addJar(new File(this.fwDir, "framework.jar"));
        }

        @Override
        protected Properties readPlatformConfiguration() throws IOException {
            Properties platformConfig = super.readPlatformConfiguration();
            platformConfig.setProperty("org.osgi.framework.storage", new File(this.domainDir, "osgi-cache/knopflerfish/").getAbsolutePath());
            return platformConfig;
        }
    }

    static class EquinoxHelper
    extends PlatformHelper {
        private static final File pluginsDir = null;

        EquinoxHelper() {
        }

        @Override
        protected void setFwDir() {
            String fwPath = System.getenv("EQUINOX_HOME");
            if (fwPath == null) {
                fwPath = new File(this.glassfishDir, "osgi/equinox").getAbsolutePath();
            }
            this.fwDir = new File(fwPath);
            if (!this.fwDir.exists()) {
                throw new RuntimeException("Can't locate Equinox at " + fwPath);
            }
        }

        @Override
        protected void addFrameworkJars(ClassPathBuilder cpb) throws IOException {
            if (pluginsDir != null) {
                cpb.addGlob(pluginsDir, "org.eclipse.osgi_*.jar");
            } else {
                cpb.addJarFolder(this.fwDir, new String[0]);
            }
        }

        @Override
        protected Properties readPlatformConfiguration() throws IOException {
            Properties platformConfig = super.readPlatformConfiguration();
            platformConfig.setProperty("org.osgi.framework.storage", new File(this.domainDir, "osgi-cache/equinox/").getAbsolutePath());
            return platformConfig;
        }
    }

    static class FelixHelper
    extends PlatformHelper {
        public static final String GF_FELIX_HOME = "osgi/felix";
        public static final String CONFIG_PROPERTIES = "config/osgi.properties";
        private static final String FELIX_HOME = "FELIX_HOME";

        FelixHelper() {
        }

        @Override
        protected void setFwDir() {
            String fwPath = System.getenv(FELIX_HOME);
            if (fwPath == null) {
                fwPath = System.getProperty(FELIX_HOME, new File(this.glassfishDir, GF_FELIX_HOME).getAbsolutePath());
            }
            this.fwDir = new File(fwPath);
            if (!this.fwDir.exists()) {
                throw new RuntimeException("Can't locate Felix at " + fwPath);
            }
        }

        @Override
        protected void addFrameworkJars(ClassPathBuilder cpb) throws IOException {
            cpb.addJar(new File(this.fwDir, "bin/felix.jar"));
        }

        @Override
        protected Properties readPlatformConfiguration() throws IOException {
            Properties platformConfig = super.readPlatformConfiguration();
            platformConfig.setProperty("org.osgi.framework.storage", new File(this.domainDir, "osgi-cache/felix/").getAbsolutePath());
            return platformConfig;
        }
    }

    static abstract class PlatformHelper {
        public static final String CONFIG_PROPERTIES = "config/osgi.properties";
        protected Properties properties;
        protected File glassfishDir;
        protected File domainDir;
        protected File fwDir;

        PlatformHelper() {
        }

        static synchronized PlatformHelper getPlatformHelper(Properties properties) {
            PlatformHelper platformHelper;
            Constants.Platform platform = Constants.Platform.valueOf(properties.getProperty("GlassFish_Platform"));
            switch (platform) {
                case Felix: {
                    platformHelper = new FelixHelper();
                    break;
                }
                case Knopflerfish: {
                    platformHelper = new KnopflerfishHelper();
                    break;
                }
                case Equinox: {
                    platformHelper = new EquinoxHelper();
                    break;
                }
                case Static: {
                    platformHelper = new StaticHelper();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported platform " + platform);
                }
            }
            platformHelper.init(properties);
            return platformHelper;
        }

        void init(Properties properties) {
            this.properties = properties;
            this.glassfishDir = StartupContextUtil.getInstallRoot(properties);
            this.domainDir = StartupContextUtil.getInstanceRoot(properties);
            this.setFwDir();
        }

        protected abstract void setFwDir();

        protected abstract void addFrameworkJars(ClassPathBuilder var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Properties readPlatformConfiguration() throws IOException {
            Properties platformConfig = new Properties();
            File configFile = this.getFrameworkConfigFile();
            if (configFile == null) {
                return platformConfig;
            }
            try (FileInputStream in = new FileInputStream(configFile);){
                platformConfig.load(in);
            }
            return platformConfig;
        }

        protected File getFrameworkConfigFile() {
            String fileName = CONFIG_PROPERTIES;
            File f = new File(this.domainDir, fileName);
            if (!f.exists()) {
                f = new File(this.glassfishDir, fileName);
            } else {
                logger.log(Level.INFO, "NCLS-BOOTSTRAP-00002", f.getAbsolutePath());
            }
            return f;
        }
    }

    static class ClassLoaderBuilder {
        protected ClassPathBuilder cpb;
        protected File glassfishDir;
        protected Properties ctx;

        ClassLoaderBuilder(Properties ctx, ClassLoader delegate) {
            this.ctx = ctx;
            this.cpb = new ClassPathBuilder(delegate);
            this.glassfishDir = new File(ctx.getProperty("com.sun.aas.installRoot"));
        }

        void addFrameworkJars() throws IOException {
            PlatformHelper.getPlatformHelper(this.ctx).addFrameworkJars(this.cpb);
        }

        public ClassLoader build() {
            return this.cpb.create();
        }

        public void addLauncherJar() throws IOException {
            this.cpb.addJar(new File(this.glassfishDir, "modules/glassfish.jar"));
        }

        public void addBootstrapApiJar() throws IOException {
            this.cpb.addJar(new File(this.glassfishDir, "modules/simple-glassfish-api.jar"));
        }
    }
}

