/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiFrameworkLauncher {
    private Properties properties;
    private Framework framework;

    public OSGiFrameworkLauncher(Properties properties) {
        this.properties = properties;
    }

    public Framework launchOSGiFrameWork() throws Exception {
        if (!this.isOSGiEnv()) {
            ServiceLoader<FrameworkFactory> frameworkFactories = ServiceLoader.load(FrameworkFactory.class, this.getClass().getClassLoader());
            HashMap<String, String> mm = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                mm.put((String)entry.getKey(), (String)entry.getValue());
            }
            Iterator<Map.Entry<Object, Object>> iterator = frameworkFactories.iterator();
            if (iterator.hasNext()) {
                FrameworkFactory frameworkFactory = (FrameworkFactory)iterator.next();
                this.framework = frameworkFactory.newFramework(mm);
            }
            if (this.framework == null) {
                throw new RuntimeException("No OSGi framework in classpath");
            }
        } else {
            throw new IllegalStateException("An OSGi framework is already running...");
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    OSGiFrameworkLauncher.this.framework.init();
                }
                catch (BundleException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        thread.setDaemon(true);
        thread.setName("OSGI Framework Init");
        thread.start();
        thread.join();
        return this.framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> type) throws Exception {
        if (this.framework == null) {
            throw new IllegalStateException("OSGi framework has not yet been launched.");
        }
        BundleContext context = this.framework.getBundleContext();
        try (ServiceTracker tracker = new ServiceTracker(context, type.getName(), null);){
            tracker.open(true);
            T t = type.cast(tracker.waitForService(0L));
            return t;
        }
    }

    private boolean isOSGiEnv() {
        return this.getClass().getClassLoader() instanceof BundleReference;
    }
}

