/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.spi.legacy.interceptor.IORInfoExt;
import com.sun.corba.ee.spi.legacy.interceptor.UnknownType;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.iiop.security.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.security.Lookups;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.security.ssl.J2EEKeyManager;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.IIOPSSLUtil;
import org.glassfish.security.common.SharedSecureRandomImpl;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;

@Service
@Singleton
public class IIOPSSLUtilImpl
implements IIOPSSLUtil {
    @Inject
    private SSLUtils sslUtils;
    private GlassFishORBHelper orbHelper;
    private static final Logger _logger = LogDomains.getLogger(IIOPSSLUtilImpl.class, (String)"javax.enterprise.system.core.security");
    private Object appClientSSL;

    public Object getAppClientSSL() {
        return this.appClientSSL;
    }

    public void setAppClientSSL(Object ssl) {
        this.appClientSSL = ssl;
    }

    public KeyManager[] getKeyManagers(String alias) {
        KeyManager[] mgrs = null;
        try {
            if (alias != null && !this.sslUtils.isTokenKeyAlias(alias)) {
                throw new IllegalStateException(this.getFormatMessage("iiop.cannot_find_keyalias", new Object[]{alias}));
            }
            mgrs = this.sslUtils.getKeyManagers();
            if (alias != null && mgrs != null && mgrs.length > 0) {
                KeyManager[] newMgrs = new KeyManager[mgrs.length];
                for (int i = 0; i < mgrs.length; ++i) {
                    if (_logger.isLoggable(Level.FINE)) {
                        StringBuilder msg = new StringBuilder("Setting J2EEKeyManager for ");
                        msg.append(" alias : " + alias);
                        _logger.log(Level.FINE, msg.toString());
                    }
                    newMgrs[i] = new J2EEKeyManager((X509KeyManager)mgrs[i], alias);
                }
                mgrs = newMgrs;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mgrs;
    }

    public TrustManager[] getTrustManagers() {
        try {
            return this.sslUtils.getTrustManagers();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getFormatMessage(String key, Object[] params) {
        return MessageFormat.format(_logger.getResourceBundle().getString(key), params);
    }

    public SecureRandom getInitializedSecureRandom() {
        return SharedSecureRandomImpl.get();
    }

    public Object getSSLPortsAsSocketInfo(Object ior) {
        SecurityMechanismSelector selector = Lookups.getSecurityMechanismSelector();
        return selector.getSSLSocketInfo(ior);
    }

    public TaggedComponent createSSLTaggedComponent(IORInfo iorInfo, Object sInfos) {
        CSIV2TaggedComponentInfo ctc;
        EjbDescriptor desc;
        List socketInfos = (List)sInfos;
        this.orbHelper = Lookups.getGlassFishORBHelper();
        TaggedComponent result = null;
        ORB orb = this.orbHelper.getORB();
        int sslMutualAuthPort = -1;
        try {
            if (iorInfo instanceof IORInfoExt) {
                sslMutualAuthPort = ((IORInfoExt)iorInfo).getServerPort("SSL_MUTUALAUTH");
            }
        }
        catch (UnknownType ute) {
            _logger.log(Level.FINE, ".isnert: UnknownType exception", ute);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, ".insert: sslMutualAuthPort: " + sslMutualAuthPort);
        }
        if ((desc = (ctc = new CSIV2TaggedComponentInfo(orb, sslMutualAuthPort)).getEjbDescriptor(iorInfo)) != null) {
            result = ctc.createSecurityTaggedComponent(socketInfos, desc);
        }
        return result;
    }
}

