/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCGetCPMembersCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.security.permission.ManagementPermission;
import java.security.Permission;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class GetCPMembersMessageTask
extends AbstractAsyncMessageTask<Void, List<AbstractMap.SimpleEntry<UUID, UUID>>> {
    private static final Permission REQUIRED_PERMISSION = new ManagementPermission("cp.getCPMembers");

    public GetCPMembersMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<List<AbstractMap.SimpleEntry<UUID, UUID>>> processInternal() {
        CPSubsystemManagementService cpService = this.nodeEngine.getHazelcastInstance().getCPSubsystem().getCPSubsystemManagementService();
        ClusterService clusterService = this.nodeEngine.getClusterService();
        return cpService.getCPMembers().toCompletableFuture().thenApplyAsync(cpMembers -> {
            ArrayList<AbstractMap.SimpleEntry<UUID, UUID>> result = new ArrayList<AbstractMap.SimpleEntry<UUID, UUID>>(cpMembers.size());
            for (CPMember cpMember : cpMembers) {
                MemberImpl member = clusterService.getMember(cpMember.getAddress());
                UUID apUuid = member != null ? member.getUuid() : null;
                result.add(new AbstractMap.SimpleEntry<UUID, UUID>(cpMember.getUuid(), apUuid));
            }
            return result;
        }, ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    protected Void decodeClientMessage(ClientMessage clientMessage) {
        return null;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MCGetCPMembersCodec.encodeResponse((List)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public Permission getRequiredPermission() {
        return REQUIRED_PERMISSION;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "getCPMembers";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

