/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy.txn;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.proxy.txn.ClientTxnListProxy;
import com.hazelcast.client.impl.proxy.txn.ClientTxnMapProxy;
import com.hazelcast.client.impl.proxy.txn.ClientTxnMultiMapProxy;
import com.hazelcast.client.impl.proxy.txn.ClientTxnProxy;
import com.hazelcast.client.impl.proxy.txn.ClientTxnQueueProxy;
import com.hazelcast.client.impl.proxy.txn.ClientTxnSetProxy;
import com.hazelcast.client.impl.proxy.txn.TransactionProxy;
import com.hazelcast.client.impl.spi.ClientTransactionContext;
import com.hazelcast.client.impl.spi.impl.ClientTransactionManagerServiceImpl;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalList;
import com.hazelcast.transaction.TransactionalMap;
import com.hazelcast.transaction.TransactionalMultiMap;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.TransactionalQueue;
import com.hazelcast.transaction.TransactionalSet;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionalObjectKey;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;

public class TransactionContextProxy
implements ClientTransactionContext {
    final ClientTransactionManagerServiceImpl transactionManager;
    final HazelcastClientInstanceImpl client;
    final TransactionProxy transaction;
    final ClientConnection connection;
    private final Map<TransactionalObjectKey, TransactionalObject> txnObjectMap = new HashMap<TransactionalObjectKey, TransactionalObject>(2);

    public TransactionContextProxy(@Nonnull ClientTransactionManagerServiceImpl transactionManager, @Nonnull TransactionOptions options) {
        this.transactionManager = transactionManager;
        this.client = transactionManager.getClient();
        try {
            this.connection = transactionManager.connect();
        }
        catch (Exception e) {
            throw new TransactionException("Could not obtain a connection!", e);
        }
        this.transaction = new TransactionProxy(this.client, options, this.connection);
    }

    @Override
    public UUID getTxnId() {
        return this.transaction.getTxnId();
    }

    @Override
    public void beginTransaction() {
        this.transaction.begin();
    }

    @Override
    public void commitTransaction() throws TransactionException {
        this.transaction.commit();
    }

    @Override
    public void rollbackTransaction() {
        this.transaction.rollback();
    }

    @Override
    public <K, V> TransactionalMap<K, V> getMap(String name) {
        return (TransactionalMap)this.getTransactionalObject("hz:impl:mapService", name);
    }

    @Override
    public <E> TransactionalQueue<E> getQueue(String name) {
        return (TransactionalQueue)this.getTransactionalObject("hz:impl:queueService", name);
    }

    @Override
    public <K, V> TransactionalMultiMap<K, V> getMultiMap(String name) {
        return (TransactionalMultiMap)this.getTransactionalObject("hz:impl:multiMapService", name);
    }

    @Override
    public <E> TransactionalList<E> getList(String name) {
        return (TransactionalList)this.getTransactionalObject("hz:impl:listService", name);
    }

    @Override
    public <E> TransactionalSet<E> getSet(String name) {
        return (TransactionalSet)this.getTransactionalObject("hz:impl:setService", name);
    }

    @Override
    public <T extends TransactionalObject> T getTransactionalObject(String serviceName, String name) {
        if (this.transaction.getState() != Transaction.State.ACTIVE) {
            throw new TransactionNotActiveException("No transaction is found while accessing transactional object -> " + serviceName + "[" + name + "]!");
        }
        TransactionalObjectKey key = new TransactionalObjectKey(serviceName, name);
        ClientTxnProxy obj = this.txnObjectMap.get(key);
        if (obj == null) {
            if (serviceName.equals("hz:impl:queueService")) {
                obj = new ClientTxnQueueProxy(name, this);
            } else if (serviceName.equals("hz:impl:mapService")) {
                obj = new ClientTxnMapProxy(name, this);
            } else if (serviceName.equals("hz:impl:multiMapService")) {
                obj = new ClientTxnMultiMapProxy(name, this);
            } else if (serviceName.equals("hz:impl:listService")) {
                obj = new ClientTxnListProxy(name, this);
            } else if (serviceName.equals("hz:impl:setService")) {
                obj = new ClientTxnSetProxy(name, this);
            }
            if (obj == null) {
                throw new IllegalArgumentException("Service[" + serviceName + "] is not transactional!");
            }
            this.txnObjectMap.put(key, obj);
        }
        return (T)obj;
    }

    @Override
    public ClientConnection getConnection() {
        return this.connection;
    }

    @Override
    public HazelcastClientInstanceImpl getClient() {
        return this.client;
    }
}

