/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.permission;

import com.hazelcast.security.permission.InstancePermission;

public class SqlPermission
extends InstancePermission {
    private static final int CREATE_MAPPING = 1;
    private static final int DROP_MAPPING = 2;
    private static final int CREATE_INDEX = 4;
    private static final int CREATE_VIEW = 8;
    private static final int DROP_VIEW = 16;
    private static final int CREATE_TYPE = 32;
    private static final int DROP_TYPE = 64;
    private static final int VIEW_DATACONNECTION = 128;
    private static final int CREATE_DATACONNECTION = 256;
    private static final int DROP_DATACONNECTION = 512;
    private static final int ALL = 1023;

    public SqlPermission(String name, String ... actions) {
        super(name, actions);
    }

    @Override
    protected int initMask(String[] actions) {
        int mask = 0;
        for (String action : actions) {
            if ("all".equals(action)) {
                return 1023;
            }
            if ("create".equals(action)) {
                mask |= 1;
                continue;
            }
            if ("destroy".equals(action)) {
                mask |= 2;
                continue;
            }
            if ("index".equals(action)) {
                mask |= 4;
                continue;
            }
            if ("create-view".equals(action)) {
                mask |= 8;
                continue;
            }
            if ("drop-view".equals(action)) {
                mask |= 0x10;
                continue;
            }
            if ("create-type".equals(action)) {
                mask |= 0x20;
                continue;
            }
            if ("drop-type".equals(action)) {
                mask |= 0x40;
                continue;
            }
            if ("view-dataconnection".equals(action)) {
                mask |= 0x80;
                continue;
            }
            if ("create-dataconnection".equals(action)) {
                mask |= 0x100;
                continue;
            }
            if (!"drop-dataconnection".equals(action)) continue;
            mask |= 0x200;
        }
        return mask;
    }
}

