/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.encoding.CachedCodeBase;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.ee.impl.protocol.MessageMediatorImpl;
import com.sun.corba.ee.impl.protocol.MessageParserImpl;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.CancelRequestMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.impl.transport.EventHandlerBase;
import com.sun.corba.ee.impl.transport.MessageTraceManagerImpl;
import com.sun.corba.ee.impl.transport.NioBufferWriter;
import com.sun.corba.ee.impl.transport.ResponseWaitingRoomImpl;
import com.sun.corba.ee.impl.transport.SocketChannelReader;
import com.sun.corba.ee.impl.transport.TemporarySelector;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.MessageMediator;
import com.sun.corba.ee.spi.protocol.MessageParser;
import com.sun.corba.ee.spi.protocol.RequestId;
import com.sun.corba.ee.spi.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.threadpool.Work;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Acceptor;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.ConnectionCache;
import com.sun.corba.ee.spi.transport.ContactInfo;
import com.sun.corba.ee.spi.transport.EventHandler;
import com.sun.corba.ee.spi.transport.InboundConnectionCache;
import com.sun.corba.ee.spi.transport.OutboundConnectionCache;
import com.sun.corba.ee.spi.transport.ResponseWaitingRoom;
import com.sun.corba.ee.spi.transport.Selector;
import com.sun.corba.ee.spi.transport.TcpTimeouts;
import com.sun.corba.ee.spi.transport.TransportManager;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.OutputStream;

@Transport
public class ConnectionImpl
extends EventHandlerBase
implements Connection,
Work {
    protected static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    protected SocketChannel socketChannel;
    private MessageParser messageParser;
    private SocketChannelReader socketChannelReader;
    private Throwable discardedThrowable;
    protected ByteBuffer byteBuffer = null;
    protected long enqueueTime;
    protected ContactInfo contactInfo;
    protected Acceptor acceptor;
    protected ConnectionCache connectionCache;
    protected Socket socket;
    protected long timeStamp = 0L;
    protected boolean isServer = false;
    protected AtomicInteger requestId = new AtomicInteger(5);
    protected ResponseWaitingRoom responseWaitingRoom;
    private int state;
    protected final Object stateEvent = new Object();
    protected final Object writeEvent = new Object();
    protected boolean writeLocked;
    protected int serverRequestCount = 0;
    Map<Integer, MessageMediator> serverRequestMap = null;
    protected boolean postInitialContexts = false;
    protected IOR codeBaseServerIOR;
    protected CachedCodeBase cachedCodeBase = new CachedCodeBase(this);
    protected TcpTimeouts tcpTimeouts;
    protected TemporarySelector tmpReadSelector;
    protected final Object tmpReadSelectorLock = new Object();
    private NioBufferWriter bufferWriter;
    protected Dispatcher dispatcher = DISPATCHER;
    static final Dispatcher DISPATCHER = new Dispatcher(){

        @Override
        public boolean dispatch(MessageMediator messageMediator) {
            return messageMediator.dispatch();
        }
    };
    protected ConcurrentHashMap<RequestId, Queue<MessageMediator>> fragmentMap;
    protected CodeSetComponentInfo.CodeSetContext codeSetContext = null;
    protected MessageMediator clientReply_1_1;
    protected MessageMediator serverRequest_1_1;

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    Throwable getDiscardedThrowable() {
        return this.discardedThrowable;
    }

    void clearDiscardedThrowable() {
        this.discardedThrowable = null;
    }

    public ConnectionImpl(ORB orb) {
        this.orb = orb;
        this.messageParser = new MessageParserImpl(orb, this);
        this.socketChannelReader = new SocketChannelReader(orb);
        this.setWork(this);
        this.responseWaitingRoom = new ResponseWaitingRoomImpl(orb, this);
        this.setTcpTimeouts(orb.getORBData().getTransportTcpTimeouts());
    }

    protected ConnectionImpl(ORB orb, boolean useSelectThreadToWait, boolean useWorkerThread) {
        this(orb);
        this.setUseSelectThreadToWait(useSelectThreadToWait);
        this.setUseWorkerThreadForEvent(useWorkerThread);
        if (useSelectThreadToWait) {
            this.fragmentMap = new ConcurrentHashMap();
        }
    }

    private ConnectionImpl(ORB orb, ContactInfo contactInfo, boolean useSelectThreadToWait, boolean useWorkerThread, String socketType, String hostname, int port) {
        this(orb, useSelectThreadToWait, useWorkerThread);
        this.contactInfo = contactInfo;
        try {
            this.defineSocket(useSelectThreadToWait, orb.getORBData().getSocketFactory().createSocket(socketType, new InetSocketAddress(hostname, port)));
        }
        catch (Throwable t) {
            throw wrapper.connectFailure(t, socketType, hostname, Integer.toString(port));
        }
        this.state = 1;
    }

    protected final void defineSocket(boolean useSelectThreadToWait, Socket socket) throws IOException {
        this.socket = socket;
        this.socketChannel = socket.getChannel();
        if (this.socketChannel == null) {
            this.setUseSelectThreadToWait(false);
        } else {
            this.socketChannel.configureBlocking(!useSelectThreadToWait);
        }
    }

    public ConnectionImpl(ORB orb, ContactInfo contactInfo, String socketType, String hostname, int port) {
        this(orb, contactInfo, orb.getORBData().connectionSocketUseSelectThreadToWait(), orb.getORBData().connectionSocketUseWorkerThreadForEvent(), socketType, hostname, port);
    }

    private ConnectionImpl(ORB orb, Acceptor acceptor, Socket socket, boolean useSelectThreadToWait, boolean useWorkerThread) {
        this(orb, useSelectThreadToWait, useWorkerThread);
        try {
            this.defineSocket(useSelectThreadToWait, socket);
        }
        catch (IOException e) {
            RuntimeException rte = new RuntimeException();
            rte.initCause(e);
            throw rte;
        }
        this.acceptor = acceptor;
        this.serverRequestMap = Collections.synchronizedMap(new HashMap());
        this.isServer = true;
        this.state = 2;
    }

    public ConnectionImpl(ORB orb, Acceptor acceptor, Socket socket) {
        this(orb, acceptor, socket, socket.getChannel() != null && orb.getORBData().connectionSocketUseSelectThreadToWait(), socket.getChannel() != null && orb.getORBData().connectionSocketUseWorkerThreadForEvent());
    }

    @Override
    public boolean shouldRegisterReadEvent() {
        return true;
    }

    @Override
    public boolean shouldRegisterServerReadEvent() {
        return true;
    }

    @Override
    public boolean read() {
        MessageMediator messageMediator = this.readBits();
        return messageMediator == null || this.dispatcher.dispatch(messageMediator);
    }

    private MessageMediator readBits() {
        try {
            return this.createMessageMediator();
        }
        catch (ThreadDeath td) {
            try {
                this.purgeCalls((SystemException)((Object)wrapper.connectionAbort(td)), false, false);
            }
            catch (Throwable t) {
                this.exceptionInfo("purgeCalls", t);
            }
            throw td;
        }
        catch (Throwable ex) {
            this.exceptionInfo("readBits", ex);
            if (ex instanceof SystemException) {
                SystemException se = (SystemException)ex;
                if (se.minor == ORBUtilSystemException.CONNECTION_REBIND) {
                    this.unregisterForEventAndPurgeCalls(se);
                    throw se;
                }
                try {
                    if (se instanceof INTERNAL) {
                        this.sendMessageError(GIOPVersion.DEFAULT_VERSION);
                    }
                }
                catch (IOException e) {
                    this.exceptionInfo("sendMessageError", e);
                }
            }
            this.unregisterForEventAndPurgeCalls((SystemException)((Object)wrapper.connectionAbort(ex)));
            throw wrapper.throwableInReadBits(ex);
        }
    }

    private void unregisterForEventAndPurgeCalls(SystemException ex) {
        this.orb.getTransportManager().getSelector(0).unregisterForEvent(this);
        this.purgeCalls(ex, true, false);
    }

    private MessageMediator createMessageMediator() {
        try {
            ByteBuffer headerBuffer = this.read(0, 12);
            MessageBase header = MessageBase.parseGiopHeader(this.orb, this, headerBuffer, 0);
            headerBuffer.position(12);
            int msgSizeMinusHeader = header.getSize() - 12;
            ByteBuffer buffer = this.read(12, msgSizeMinusHeader);
            this.traceMessageBodyReceived(this.orb, buffer);
            return new MessageMediatorImpl(this.orb, this, header, buffer);
        }
        catch (IOException e) {
            throw wrapper.ioexceptionWhenReadingConnection(e, this);
        }
    }

    private void traceMessageBodyReceived(ORB orb, ByteBuffer buf) {
        TransportManager ctm = orb.getTransportManager();
        MessageTraceManagerImpl mtm = (MessageTraceManagerImpl)ctm.getMessageTraceManager();
        if (mtm.isEnabled()) {
            mtm.recordBodyReceived(buf);
        }
    }

    @Override
    public boolean hasSocketChannel() {
        return this.getSocketChannel() != null;
    }

    private ByteBuffer read(int offset, int length) throws IOException {
        try {
            int size = offset + length;
            byte[] buf = new byte[size];
            this.readFully(this.getSocket().getInputStream(), buf, offset, length);
            return ByteBuffer.wrap(buf);
        }
        catch (IOException ioe) {
            if (this.getState() == 4) {
                throw wrapper.connectionRebind(ioe);
            }
            throw ioe;
        }
    }

    private void readFully(InputStream is, byte[] buf, int offset, int length) throws IOException {
        int bytecount;
        int n = 0;
        do {
            if ((bytecount = is.read(buf, offset + n, length - n)) >= 0) continue;
            throw new IOException("End-of-stream");
        } while ((n += bytecount) < length);
    }

    @Override
    @Transport
    public void write(ByteBuffer byteBuffer) throws IOException {
        try {
            if (this.hasSocketChannel()) {
                if (this.getSocketChannel().isBlocking()) {
                    throw wrapper.temporaryWriteSelectorWithBlockingConnection(this);
                }
                this.writeUsingNio(byteBuffer);
            } else {
                if (!byteBuffer.hasArray()) {
                    throw wrapper.unexpectedDirectByteBufferWithNonChannelSocket();
                }
                byte[] tmpBuf = new byte[byteBuffer.limit()];
                System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), tmpBuf, 0, tmpBuf.length);
                this.getSocket().getOutputStream().write(tmpBuf, 0, tmpBuf.length);
                this.getSocket().getOutputStream().flush();
            }
            this.getConnectionCache().stampTime(this);
        }
        catch (IOException ioe) {
            if (this.getState() == 4) {
                throw wrapper.connectionRebind(ioe);
            }
            throw ioe;
        }
    }

    private void writeUsingNio(ByteBuffer byteBuffer) throws IOException {
        if (this.bufferWriter == null) {
            this.bufferWriter = new NioBufferWriter(this.getSocketChannel(), this.tcpTimeouts);
        }
        this.bufferWriter.write(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public synchronized void close() {
        this.writeLock();
        if (this.isBusy()) {
            this.writeUnlock();
            this.doNotCloseBusyConnection();
            return;
        }
        try {
            try {
                this.sendCloseConnection(GIOPVersion.V1_0);
            }
            catch (Throwable t) {
                wrapper.exceptionWhenSendingCloseConnection(t);
            }
            Object t = this.stateEvent;
            synchronized (t) {
                this.state = 3;
                this.stateEvent.notifyAll();
            }
            this.purgeCalls((SystemException)((Object)wrapper.connectionRebind()), false, true);
        }
        catch (Exception ex) {
            wrapper.exceptionInPurgeCalls(ex);
        }
        this.closeConnectionResources();
    }

    @Override
    @Transport
    public void closeConnectionResources() {
        Selector selector = this.orb.getTransportManager().getSelector(0);
        selector.unregisterForEvent(this);
        this.closeSocketAndTemporarySelectors();
    }

    @InfoMethod
    private void closingSocketChannel() {
    }

    @InfoMethod
    private void IOExceptionOnClose(Exception e) {
    }

    @Transport
    protected void closeSocketAndTemporarySelectors() {
        try {
            if (this.socketChannel != null) {
                this.closeTemporarySelectors();
                this.closingSocketChannel();
                this.socketChannel.socket().close();
            }
        }
        catch (IOException e) {
            this.IOExceptionOnClose(e);
        }
        finally {
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (Exception e) {
                this.IOExceptionOnClose(e);
            }
        }
    }

    @Override
    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    @Override
    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    @Override
    public EventHandler getEventHandler() {
        return this;
    }

    @Override
    public boolean isServer() {
        return this.isServer;
    }

    @Override
    public boolean isClosed() {
        boolean result = true;
        if (this.socketChannel != null) {
            result = !this.socketChannel.isOpen();
        } else if (this.socket != null) {
            result = this.socket.isClosed();
        }
        return result;
    }

    @Override
    public boolean isBusy() {
        return this.serverRequestCount > 0 || this.getResponseWaitingRoom().numberRegistered() > 0;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void setTimeStamp(long time) {
        this.timeStamp = time;
    }

    protected int getState() {
        return this.state;
    }

    protected void setState(int state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(String stateString) {
        Object object = this.stateEvent;
        synchronized (object) {
            if (stateString.equals("ESTABLISHED")) {
                this.state = 2;
                this.stateEvent.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transport
    public void writeLock() {
        block20: while (true) {
            int localState;
            Object object = this.stateEvent;
            synchronized (object) {
                localState = this.getState();
            }
            this.localStateInfo(localState);
            switch (localState) {
                case 1: {
                    object = this.stateEvent;
                    synchronized (object) {
                        if (this.getState() != 1) {
                            continue block20;
                        }
                        try {
                            this.stateEvent.wait();
                        }
                        catch (InterruptedException ie) {
                            wrapper.openingWaitInterrupted(ie);
                        }
                        continue block20;
                    }
                }
                case 2: {
                    object = this.writeEvent;
                    synchronized (object) {
                        if (!this.writeLocked) {
                            this.writeLocked = true;
                            return;
                        }
                        try {
                            while (this.getState() == 2 && this.writeLocked) {
                                this.writeEvent.wait(100L);
                            }
                        }
                        catch (InterruptedException ie) {
                            wrapper.establishedWaitInterrupted(ie);
                        }
                        continue block20;
                    }
                }
                case 5: {
                    object = this.stateEvent;
                    synchronized (object) {
                        if (this.getState() == 5) {
                            throw wrapper.writeErrorSend();
                        }
                        continue block20;
                    }
                }
                case 4: {
                    object = this.stateEvent;
                    synchronized (object) {
                        if (this.getState() == 4) {
                            throw wrapper.connectionRebind();
                        }
                        continue block20;
                    }
                }
            }
            throw new RuntimeException(".writeLock: bad state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void writeUnlock() {
        Object object = this.writeEvent;
        synchronized (object) {
            this.writeLocked = false;
            this.writeEvent.notify();
        }
    }

    @Override
    public void sendWithoutLock(CDROutputObject outputObject) {
        try {
            CDROutputObject cdrOutputObject = outputObject;
            cdrOutputObject.writeTo(this);
        }
        catch (IOException exc) {
            COMM_FAILURE sysexc = this.getState() == 4 ? wrapper.connectionRebindMaybe(exc) : wrapper.writeErrorSend(exc);
            this.purgeCalls((SystemException)((Object)sysexc), false, true);
            throw sysexc;
        }
    }

    @Override
    public void registerWaiter(MessageMediator messageMediator) {
        this.responseWaitingRoom.registerWaiter(messageMediator);
    }

    @Override
    public void unregisterWaiter(MessageMediator messageMediator) {
        this.responseWaitingRoom.unregisterWaiter(messageMediator);
    }

    @Override
    public CDRInputObject waitForResponse(MessageMediator messageMediator) {
        return this.responseWaitingRoom.waitForResponse(messageMediator);
    }

    @Override
    public void setConnectionCache(ConnectionCache connectionCache) {
        this.connectionCache = connectionCache;
    }

    @Override
    public ConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    @Override
    public void setUseSelectThreadToWait(boolean x) {
        this.useSelectThreadToWait = x;
    }

    @Override
    public SelectableChannel getChannel() {
        return this.socketChannel;
    }

    @Override
    public int getInterestOps() {
        return 1;
    }

    @Override
    public Connection getConnection() {
        return this;
    }

    public String getName() {
        return this.toString();
    }

    @Transport
    public void doWork() {
        this.discardedThrowable = null;
        try {
            if (this.hasSocketChannel()) {
                this.doOptimizedReadStrategy();
            } else {
                this.read();
            }
        }
        catch (Throwable t) {
            this.discardedThrowable = t;
            this.exceptionInfo(t);
        }
    }

    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    @Override
    public ResponseWaitingRoom getResponseWaitingRoom() {
        return this.responseWaitingRoom;
    }

    @Override
    public void serverRequestMapPut(int reqId, MessageMediator messageMediator) {
        this.serverRequestMap.put(reqId, messageMediator);
    }

    @Override
    public MessageMediator serverRequestMapGet(int reqId) {
        return this.serverRequestMap.get(reqId);
    }

    @Override
    public void serverRequestMapRemove(int reqId) {
        this.serverRequestMap.remove(reqId);
    }

    @Override
    public Queue<MessageMediator> getFragmentList(RequestId corbaRequestId) {
        return this.fragmentMap.get(corbaRequestId);
    }

    @Override
    public void removeFragmentList(RequestId corbaRequestId) {
        this.fragmentMap.remove(corbaRequestId);
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public synchronized void serverRequestProcessingBegins() {
        ++this.serverRequestCount;
    }

    @Override
    public synchronized void serverRequestProcessingEnds() {
        --this.serverRequestCount;
    }

    @Override
    public int getNextRequestId() {
        return this.requestId.getAndIncrement();
    }

    @Override
    public ORB getBroker() {
        return this.orb;
    }

    @Override
    public synchronized CodeSetComponentInfo.CodeSetContext getCodeSetContext() {
        return this.codeSetContext;
    }

    @Override
    public synchronized void setCodeSetContext(CodeSetComponentInfo.CodeSetContext csc) {
        if (this.codeSetContext == null) {
            if (OSFCodeSetRegistry.lookupEntry(csc.getCharCodeSet()) == null || OSFCodeSetRegistry.lookupEntry(csc.getWCharCodeSet()) == null) {
                throw wrapper.badCodesetsFromClient();
            }
            this.codeSetContext = csc;
        }
    }

    @Override
    public MessageMediator clientRequestMapGet(int requestId) {
        return this.responseWaitingRoom.getMessageMediator(requestId);
    }

    @Override
    public void clientReply_1_1_Put(MessageMediator x) {
        this.clientReply_1_1 = x;
    }

    @Override
    public MessageMediator clientReply_1_1_Get() {
        return this.clientReply_1_1;
    }

    @Override
    public void clientReply_1_1_Remove() {
        this.clientReply_1_1 = null;
    }

    @Override
    public void serverRequest_1_1_Put(MessageMediator x) {
        this.serverRequest_1_1 = x;
    }

    @Override
    public MessageMediator serverRequest_1_1_Get() {
        return this.serverRequest_1_1;
    }

    @Override
    public void serverRequest_1_1_Remove() {
        this.serverRequest_1_1 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStateString(int state) {
        Object object = this.stateEvent;
        synchronized (object) {
            switch (state) {
                case 1: {
                    return "OPENING";
                }
                case 2: {
                    return "ESTABLISHED";
                }
                case 3: {
                    return "CLOSE_SENT";
                }
                case 4: {
                    return "CLOSE_RECVD";
                }
                case 5: {
                    return "ABORT";
                }
            }
            return "???";
        }
    }

    @Override
    public synchronized boolean isPostInitialContexts() {
        return this.postInitialContexts;
    }

    @Override
    public synchronized void setPostInitialContexts() {
        this.postInitialContexts = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void purgeCalls(SystemException systemException, boolean die, boolean lockHeld) {
        int minor_code = systemException.minor;
        Iterator<MessageMediator> iterator = this.stateEvent;
        synchronized (iterator) {
            this.localStateInfo(this.getState());
            if (this.getState() == 5 || this.getState() == 4) {
                return;
            }
        }
        try {
            if (!lockHeld) {
                this.writeLock();
            }
        }
        catch (SystemException ex) {
            this.exceptionInfo(ex);
        }
        iterator = this.stateEvent;
        synchronized (iterator) {
            if (minor_code == ORBUtilSystemException.CONNECTION_REBIND) {
                this.state = 4;
                systemException.completed = CompletionStatus.COMPLETED_NO;
            } else {
                this.state = 5;
                systemException.completed = CompletionStatus.COMPLETED_MAYBE;
            }
            this.stateEvent.notifyAll();
        }
        this.closeSocketAndTemporarySelectors();
        if (this.serverRequest_1_1 != null) {
            this.serverRequest_1_1.cancelRequest();
        }
        if (this.serverRequestMap != null) {
            for (MessageMediator mm : this.serverRequestMap.values()) {
                mm.cancelRequest();
            }
        }
        this.responseWaitingRoom.signalExceptionToAllWaiters(systemException);
        if (this.contactInfo != null) {
            ((OutboundConnectionCache)this.connectionCache).remove(this.contactInfo);
        } else if (this.acceptor != null) {
            ((InboundConnectionCache)this.connectionCache).remove(this);
        }
        this.writeUnlock();
    }

    @Override
    public void sendCloseConnection(GIOPVersion giopVersion) throws IOException {
        Message msg = MessageBase.createCloseConnection(giopVersion);
        this.sendHelper(giopVersion, msg);
    }

    @Override
    public void sendMessageError(GIOPVersion giopVersion) throws IOException {
        Message msg = MessageBase.createMessageError(giopVersion);
        this.sendHelper(giopVersion, msg);
    }

    @Override
    public void sendCancelRequest(GIOPVersion giopVersion, int requestId) throws IOException {
        CancelRequestMessage msg = MessageBase.createCancelRequest(giopVersion, requestId);
        this.sendHelper(giopVersion, msg);
    }

    protected void sendHelper(GIOPVersion giopVersion, Message msg) throws IOException {
        CDROutputObject outputObject = new CDROutputObject(this.orb, null, giopVersion, this, msg, 1);
        msg.write((OutputStream)outputObject);
        outputObject.writeTo(this);
    }

    @Override
    public void sendCancelRequestWithLock(GIOPVersion giopVersion, int requestId) throws IOException {
        this.writeLock();
        try {
            this.sendCancelRequest(giopVersion, requestId);
        }
        catch (IOException ioe) {
            if (this.getState() == 4) {
                throw wrapper.connectionRebind(ioe);
            }
            throw ioe;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public final void setCodeBaseIOR(IOR ior) {
        this.codeBaseServerIOR = ior;
    }

    @Override
    public final IOR getCodeBaseIOR() {
        return this.codeBaseServerIOR;
    }

    @Override
    public final CodeBase getCodeBase() {
        return this.cachedCodeBase;
    }

    protected void setTcpTimeouts(TcpTimeouts tcpTimeouts) {
        this.tcpTimeouts = tcpTimeouts;
    }

    @Transport
    protected void doOptimizedReadStrategy() {
        try {
            if (this.byteBuffer == null || !this.byteBuffer.hasRemaining()) {
                this.byteBuffer = this.orb.getByteBufferPool().getByteBuffer(this.orb.getORBData().getReadByteBufferSize());
            }
            this.messageParser.setNextMessageStartPosition(this.byteBuffer.position());
            int bytesRead = 0;
            do {
                if ((bytesRead = this.nonBlockingRead()) <= 0) continue;
                this.parseBytesAndDispatchMessages();
            } while (bytesRead > 0 && this.messageParser.isExpectingMoreData());
            if (this.orb.getORBData().alwaysEnterBlockingRead() || this.messageParser.isExpectingMoreData()) {
                this.blockingRead();
            }
            this.byteBuffer.position(this.messageParser.getNextMessageStartPosition());
            this.resumeSelectOnMainSelector();
        }
        catch (ThreadDeath td) {
            try {
                this.purgeCalls((SystemException)((Object)wrapper.connectionAbort(td)), false, false);
            }
            catch (Throwable t) {
                this.exceptionInfo(t);
            }
            throw td;
        }
        catch (Throwable ex) {
            if (ex instanceof SystemException) {
                SystemException se = (SystemException)ex;
                if (se.minor == ORBUtilSystemException.CONNECTION_REBIND) {
                    this.unregisterForEventAndPurgeCalls(se);
                    throw se;
                }
                try {
                    if (se instanceof INTERNAL) {
                        this.sendMessageError(GIOPVersion.DEFAULT_VERSION);
                    }
                }
                catch (IOException e) {
                    this.exceptionInfo(e);
                }
            }
            this.unregisterForEventAndPurgeCalls((SystemException)((Object)wrapper.connectionAbort(ex)));
            throw wrapper.throwableInDoOptimizedReadStrategy(ex);
        }
    }

    public ByteBuffer extractAndProcessMessages(ByteBuffer byteBuffer) {
        this.messageParser.offerBuffer(byteBuffer);
        MessageMediator messageMediator = this.messageParser.getMessageMediator();
        while (messageMediator != null) {
            this.queueUpWork(messageMediator);
            byteBuffer = this.messageParser.getRemainderBuffer();
            this.messageParser.offerBuffer(byteBuffer);
            messageMediator = this.messageParser.getMessageMediator();
        }
        return byteBuffer;
    }

    private void parseBytesAndDispatchMessages() {
        this.byteBuffer.limit(this.byteBuffer.position()).position(this.messageParser.getNextMessageStartPosition());
        do {
            MessageMediatorImpl messageMediator = null;
            Message message = this.messageParser.parseBytes(this.byteBuffer, this);
            this.byteBuffer = this.messageParser.getRemainderBuffer();
            if (message != null) {
                messageMediator = new MessageMediatorImpl(this.orb, this, message, this.messageParser.getMsgByteBuffer());
            }
            if (messageMediator == null) continue;
            this.queueUpWork(messageMediator);
        } while (this.messageParser.hasMoreBytesToParse());
        if (this.messageParser.isExpectingMoreData() && this.byteBuffer.position() == this.byteBuffer.capacity()) {
            this.byteBuffer = this.messageParser.getNewBufferAndCopyOld(this.byteBuffer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transport
    protected void blockingRead() {
        TcpTimeouts.Waiter waiter = this.tcpTimeouts.waiter();
        TemporarySelector tmpSelector = null;
        SelectionKey sk = null;
        try {
            this.getConnectionCache().stampTime(this);
            tmpSelector = this.getTemporaryReadSelector();
            sk = tmpSelector.registerChannel(this.getSocketChannel(), 1);
            do {
                int nsel;
                if ((nsel = tmpSelector.select(waiter.getTimeForSleep())) > 0) {
                    tmpSelector.removeSelectedKey(sk);
                    int bytesRead = this.getSocketChannel().read(this.byteBuffer);
                    if (bytesRead > 0) {
                        this.parseBytesAndDispatchMessages();
                        waiter = this.tcpTimeouts.waiter();
                        continue;
                    }
                    if (bytesRead < 0) {
                        IOException exc = new IOException("End-of-stream");
                        throw wrapper.blockingReadEndOfStream(exc, exc.toString(), this.toString());
                    }
                    waiter.advance();
                    continue;
                }
                waiter.advance();
            } while (!waiter.isExpired() && this.messageParser.isExpectingMoreData());
            if (this.messageParser.isExpectingMoreData()) {
                throw wrapper.blockingReadTimeout(this.tcpTimeouts.get_max_time_to_wait(), waiter.timeWaiting());
            }
            if (tmpSelector == null) return;
        }
        catch (IOException ioe) {
            try {
                throw wrapper.exceptionBlockingReadWithTemporarySelector(ioe, this);
            }
            catch (Throwable throwable) {
                if (tmpSelector == null) throw throwable;
                try {
                    tmpSelector.cancelAndFlushSelector(sk);
                    throw throwable;
                }
                catch (IOException ex) {
                    wrapper.unexpectedExceptionCancelAndFlushTempSelector(ex);
                }
                throw throwable;
            }
        }
        try {
            tmpSelector.cancelAndFlushSelector(sk);
            return;
        }
        catch (IOException ex) {
            wrapper.unexpectedExceptionCancelAndFlushTempSelector(ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueUpWork(MessageMediator messageMediator) {
        boolean addToWorkerThreadQueue = true;
        Message message = messageMediator.getDispatchHeader();
        if (message.supportsFragments()) {
            if (message.getType() != 7) {
                if (message.moreFragmentsToFollow()) {
                    RequestId corbaRequestId = messageMediator.getRequestIdFromRawBytes();
                    this.fragmentMap.put(corbaRequestId, new LinkedList());
                    this.addedEntryToFragmentMap(corbaRequestId);
                }
            } else {
                RequestId corbaRequestId = messageMediator.getRequestIdFromRawBytes();
                Queue<MessageMediator> queue = this.fragmentMap.get(corbaRequestId);
                if (queue != null) {
                    Queue<MessageMediator> queue2 = queue;
                    synchronized (queue2) {
                        queue.add(messageMediator);
                        this.queuedMessageFragment(corbaRequestId);
                        queue.notifyAll();
                    }
                    addToWorkerThreadQueue = false;
                } else {
                    wrapper.noFragmentQueueForRequestId(corbaRequestId.toString());
                }
            }
        }
        if (addToWorkerThreadQueue) {
            this.addMessageMediatorToWorkQueue(messageMediator);
        }
    }

    @Transport
    protected int nonBlockingRead() {
        int bytesRead = 0;
        SocketChannel sc = this.getSocketChannel();
        try {
            if (sc == null || sc.isBlocking()) {
                throw wrapper.nonBlockingReadOnBlockingSocketChannel(this);
            }
            bytesRead = sc.read(this.byteBuffer);
            if (bytesRead < 0) {
                throw new IOException("End-of-stream");
            }
            this.getConnectionCache().stampTime(this);
        }
        catch (IOException ioe) {
            if (this.getState() == 4) {
                throw wrapper.connectionRebind(ioe);
            }
            throw wrapper.ioexceptionWhenReadingConnection(ioe, this);
        }
        return bytesRead;
    }

    @Transport
    private void addMessageMediatorToWorkQueue(MessageMediator messageMediator) {
        Throwable throwable = null;
        int poolToUse = -1;
        try {
            poolToUse = messageMediator.getThreadPoolToUse();
            this.orb.getThreadPoolManager().getThreadPool(poolToUse).getWorkQueue(0).addWork((Work)messageMediator);
        }
        catch (NoSuchThreadPoolException e) {
            throwable = e;
        }
        catch (NoSuchWorkQueueException e) {
            throwable = e;
        }
        if (throwable != null) {
            throw wrapper.noSuchThreadpoolOrQueue(throwable, poolToUse);
        }
    }

    @Transport
    private void resumeSelectOnMainSelector() {
        this.orb.getTransportManager().getSelector(0).registerInterestOps(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    protected TemporarySelector getTemporaryReadSelector() throws IOException {
        if (this.getSocketChannel() == null || this.getSocketChannel().isBlocking()) {
            throw wrapper.temporaryReadSelectorWithBlockingConnection(this);
        }
        Object object = this.tmpReadSelectorLock;
        synchronized (object) {
            if (this.tmpReadSelector == null) {
                this.tmpReadSelector = new TemporarySelector(this.getSocketChannel());
            }
        }
        return this.tmpReadSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    protected void closeTemporarySelectors() throws IOException {
        Object object = this.tmpReadSelectorLock;
        synchronized (object) {
            if (this.tmpReadSelector != null) {
                this.closingReadSelector(this.tmpReadSelector);
                this.tmpReadSelector.close();
            }
        }
        if (this.bufferWriter != null) {
            this.bufferWriter.closeTemporaryWriteSelector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.stateEvent;
        synchronized (object) {
            String str = this.socketChannel != null ? this.socketChannel.toString() : (this.socket != null ? this.socket.toString() : "<no connection!>");
            return "SocketOrChannelConnectionImpl[ " + str + " " + this.getStateString(this.getState()) + " " + this.shouldUseSelectThreadToWait() + " " + this.shouldUseWorkerThreadForEvent() + "]";
        }
    }

    @InfoMethod
    private void exceptionInfo(Throwable t) {
    }

    @InfoMethod
    private void exceptionInfo(String string, Throwable t) {
    }

    @InfoMethod
    private void readFullySleeping(int time) {
    }

    @InfoMethod
    private void doNotCloseBusyConnection() {
    }

    @InfoMethod
    private void localStateInfo(int localState) {
    }

    @InfoMethod
    private void addedEntryToFragmentMap(RequestId corbaRequestId) {
    }

    @InfoMethod
    private void queuedMessageFragment(RequestId corbaRequestId) {
    }

    @InfoMethod
    private void closingReadSelector(TemporarySelector tmpReadSelector) {
    }

    static interface Dispatcher {
        public boolean dispatch(MessageMediator var1);
    }
}

