/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.mdb;

import com.sun.appserv.connectors.internal.api.ResourceHandle;
import fish.payara.notification.requesttracing.EventType;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.nucleus.healthcheck.stuck.StuckThreadsStore;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.UUID;
import org.glassfish.ejb.api.MessageBeanListener;
import org.glassfish.ejb.mdb.MessageBeanContainer;
import org.glassfish.internal.api.Globals;

public class MessageBeanListenerImpl
implements MessageBeanListener {
    private final MessageBeanContainer container_;
    private ResourceHandle resourceHandle_;
    private final RequestTracingService requestTracing;
    private final StuckThreadsStore stuckThreadsStore;

    MessageBeanListenerImpl(MessageBeanContainer container, ResourceHandle handle) {
        this.container_ = container;
        this.resourceHandle_ = handle;
        this.requestTracing = (RequestTracingService)Globals.getDefaultHabitat().getService(RequestTracingService.class, new Annotation[0]);
        this.stuckThreadsStore = (StuckThreadsStore)Globals.getDefaultHabitat().getService(StuckThreadsStore.class, new Annotation[0]);
    }

    public void setResourceHandle(ResourceHandle handle) {
        this.resourceHandle_ = handle;
    }

    public ResourceHandle getResourceHandle() {
        return this.resourceHandle_;
    }

    public void beforeMessageDelivery(Method method, boolean txImported) {
        this.container_.onEnteringContainer();
        this.container_.beforeMessageDelivery(method, MessageBeanContainer.MessageDeliveryType.Message, txImported, this.resourceHandle_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deliverMessage(Object[] params) throws Throwable {
        if (this.stuckThreadsStore != null) {
            this.stuckThreadsStore.registerThread(Long.valueOf(Thread.currentThread().getId()));
        }
        RequestTraceSpan span = null;
        if (this.requestTracing != null && this.requestTracing.isRequestTracingEnabled()) {
            span = new RequestTraceSpan(EventType.TRACE_START, "deliverMdb");
            span.addSpanTag("MDB Class", this.container_.getEjbDescriptor().getEjbClassName());
            span.addSpanTag("Message Count", Long.toString(this.container_.getMessageCount()));
            span.addSpanTag("JNDI", this.container_.getEjbDescriptor().getJndiName());
            try {
                Message msg = (Message)params[0];
                span.addSpanTag("JMS Type", msg.getJMSType());
                span.addSpanTag("JMS CorrelationID", msg.getJMSCorrelationID());
                span.addSpanTag("JMS MessageID", msg.getJMSMessageID());
                span.addSpanTag("JMS Destination", this.getDestinationName(msg.getJMSDestination()));
                span.addSpanTag("JMS ReplyTo", this.getDestinationName(msg.getJMSReplyTo()));
                UUID conversationID = (UUID)msg.getObjectProperty("#BAF-CID");
                if (conversationID != null) {
                    this.requestTracing.setTraceId(conversationID);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            this.requestTracing.startTrace(span);
        }
        try {
            Object object = this.container_.deliverMessage(params);
            return object;
        }
        finally {
            if (this.requestTracing != null && this.requestTracing.isRequestTracingEnabled()) {
                this.requestTracing.endTrace();
            }
            if (this.stuckThreadsStore != null) {
                this.stuckThreadsStore.deregisterThread(Thread.currentThread().getId());
            }
        }
    }

    public void afterMessageDelivery() {
        try {
            this.container_.afterMessageDelivery(this.resourceHandle_);
        }
        finally {
            this.container_.onLeavingContainer();
        }
    }

    private String getDestinationName(Destination jmsDestination) {
        String result = null;
        try {
            if (jmsDestination instanceof Queue) {
                result = ((Queue)jmsDestination).getQueueName();
            } else if (jmsDestination instanceof Topic) {
                result = ((Topic)jmsDestination).getTopicName();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return result;
    }
}

