/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.jaspic;

import fish.payara.security.jaspic.SimpleSAMAuthConfigProvider;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import java.util.Enumeration;
import java.util.HashMap;

public class JASPICWebListenerHelper {
    public static final String SAM_PER_REQUEST_PROPERTY = "fish.payara.security.jaspic.SAMPerRequest";
    private String registrationID;

    public void registerSAM(Class samClass, ServletContextEvent sce, String samDescription) {
        ServletContext sc = sce.getServletContext();
        Enumeration<String> names = sce.getServletContext().getInitParameterNames();
        HashMap<String, Object> samProperties = new HashMap<String, Object>();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            samProperties.put(name, sc.getInitParameter(name));
        }
        this.registrationID = AuthConfigFactory.getFactory().registerConfigProvider(new SimpleSAMAuthConfigProvider(samProperties, null, samClass), "HttpServlet", sce.getServletContext().getVirtualServerName() + " " + sce.getServletContext().getContextPath(), samDescription);
    }

    public void deregisterSAM() {
        AuthConfigFactory.getFactory().removeRegistration(this.registrationID);
    }
}

