/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.jaspic;

import fish.payara.security.jaspic.SimpleSAMConfig;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ServerAuthConfig;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

class SimpleSAMAuthConfigProvider
implements AuthConfigProvider {
    private final Map<String, Object> properties;
    private Class samClass;

    SimpleSAMAuthConfigProvider(Map<String, Object> properties, AuthConfigFactory factory, Class samClass) {
        this.properties = properties;
        this.samClass = samClass;
        if (factory != null) {
            factory.registerConfigProvider(this, "HttpServlet", null, "");
        }
    }

    @Override
    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        throw new AuthException("Unsupported");
    }

    @Override
    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        return new SimpleSAMConfig(layer, appContext, handler, this.properties, this.samClass);
    }

    @Override
    public void refresh() {
    }
}

