/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.dsig;

import com.sun.xml.wss.WSITXMLFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.Parameter;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.logging.impl.dsig.LogStringsMessages;
import com.sun.xml.wss.util.NodeListImpl;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.Text;
import java.io.ByteArrayOutputStream;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSPolicyConsumerImpl {
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig.LogStrings", "com.sun.xml.wss.logging.impl.dsig.LogStrings");
    public static final String defaultJSR105Provider = "org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private String providerName = System.getProperty("jsr105Provider", "org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI");
    private String pMT = System.getProperty("jsr105MechanismType", "DOM");
    private static volatile WSSPolicyConsumerImpl wpcInstance = null;
    private URIDereferencer externalURIResolver = null;
    private Provider provider = null;

    private WSSPolicyConsumerImpl() {
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> providerClass = Class.forName(this.providerName, true, loader);
            this.provider = (Provider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex1) {
            try {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                Class<?> providerClass = Class.forName(this.providerName, true, tccl);
                this.provider = (Provider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, LogStringsMessages.WSS_1324_DSIG_FACTORY(), ex);
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "JSR 105 provider is : " + this.providerName);
            logger.log(Level.FINEST, "JSR 105 provider mechanism is : " + this.pMT);
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Security.insertProviderAt(WSSPolicyConsumerImpl.this.provider, 5);
                    Security.insertProviderAt(new WSSProvider(), 6);
                }
                catch (SecurityException ex) {
                    Security.addProvider(WSSPolicyConsumerImpl.this.provider);
                    Security.addProvider(new WSSProvider());
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WSSPolicyConsumerImpl getInstance() {
        if (wpcInstance != null) return wpcInstance;
        Class<WSSPolicyConsumerImpl> clazz = WSSPolicyConsumerImpl.class;
        synchronized (WSSPolicyConsumerImpl.class) {
            if (wpcInstance != null) return wpcInstance;
            wpcInstance = new WSSPolicyConsumerImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return wpcInstance;
        }
    }

    public SignedInfo constructSignedInfo(FilterProcessingContext fpContext) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, XWSSecurityException {
        if (PolicyTypeUtil.signaturePolicy(fpContext.getSecurityPolicy())) {
            return this.generateSignedInfo(fpContext);
        }
        return null;
    }

    public XMLSignature constructSignature(SignedInfo signInfo, KeyInfo keyInfo) {
        return this.getSignatureFactory().newXMLSignature(signInfo, keyInfo);
    }

    public XMLSignature constructSignature(SignedInfo signInfo, KeyInfo keyInfo, String id) {
        return this.getSignatureFactory().newXMLSignature(signInfo, keyInfo, null, id, null);
    }

    public KeyInfo constructKeyInfo(MLSPolicy signaturePolicy, SecurityTokenReference reference) throws SOAPException, XWSSecurityException {
        if (PolicyTypeUtil.signaturePolicy(signaturePolicy)) {
            KeyInfoFactory keyFactory = this.getKeyInfoFactory();
            DOMStructure domKeyInfo = new DOMStructure((Node)reference.getAsSoapElement());
            return keyFactory.newKeyInfo(Collections.singletonList(domKeyInfo));
        }
        return null;
    }

    public KeyInfo constructKeyInfo(MLSPolicy signaturePolicy, String KeyName2) throws SOAPException {
        if (PolicyTypeUtil.signaturePolicy(signaturePolicy)) {
            KeyInfoFactory keyFactory = this.getKeyInfoFactory();
            KeyName keyName = keyFactory.newKeyName(KeyName2);
            ArrayList<KeyName> list = new ArrayList<KeyName>();
            list.add(keyName);
            return keyFactory.newKeyInfo(list);
        }
        return null;
    }

    public XMLSignatureFactory getSignatureFactory() {
        try {
            return XMLSignatureFactory.getInstance("DOM", this.provider);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1324_DSIG_FACTORY(), ex);
            throw new RuntimeException(ex);
        }
    }

    public KeyInfoFactory getKeyInfoFactory() {
        try {
            return this.getSignatureFactory().getKeyInfoFactory();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1323_DSIG_KEYINFO_FACTORY(), ex);
            throw new RuntimeException(ex);
        }
    }

    public SignaturePolicy constructSignaturePolicy(SignedInfo signedInfo, boolean isBSP) {
        SignaturePolicy policy = new SignaturePolicy();
        this.constructSignaturePolicy(signedInfo, isBSP, policy);
        return policy;
    }

    public void constructSignaturePolicy(SignedInfo signedInfo, boolean isBSP, SignaturePolicy policy) {
        List<Reference> referencesList = signedInfo.getReferences();
        CanonicalizationMethod cm = signedInfo.getCanonicalizationMethod();
        policy.isBSP(isBSP);
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)policy.getFeatureBinding();
        featureBinding.setCanonicalizationAlgorithm(cm.getAlgorithm());
        for (Reference ref : referencesList) {
            SignatureTarget.Transform transform = this.getSignatureTransform(ref);
            SignatureTarget target = new SignatureTarget();
            target.isBSP(isBSP);
            if (transform != null) {
                target.addTransform(transform);
            }
            target.setDigestAlgorithm(ref.getDigestMethod().getAlgorithm());
            if (ref.getURI().length() > 0) {
                target.setValue(SecurableSoapMessage.getIdFromFragmentRef(ref.getURI()));
            } else {
                target.setValue(ref.getURI());
            }
            target.setType("uri");
            featureBinding.addTargetBinding(target);
        }
    }

    public void constructSignaturePolicy(SignedInfo signedInfo, SignaturePolicy policy, SecurableSoapMessage secMsg) throws XWSSecurityException {
        List<Reference> referencesList = signedInfo.getReferences();
        CanonicalizationMethod cm = signedInfo.getCanonicalizationMethod();
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)policy.getFeatureBinding();
        featureBinding.setCanonicalizationAlgorithm(cm.getAlgorithm());
        for (Reference ref : referencesList) {
            SignatureTarget.Transform transform = this.getSignatureTransform(ref);
            SignatureTarget target = new SignatureTarget();
            if (transform != null) {
                target.addTransform(transform);
            }
            target.setDigestAlgorithm(ref.getDigestMethod().getAlgorithm());
            if (ref.getURI().length() > 0) {
                String Id = SecurableSoapMessage.getIdFromFragmentRef(ref.getURI());
                SOAPElement se = (SOAPElement)secMsg.getElementById(Id);
                if (se != null) {
                    if (se.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") || se.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd") || se.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2005/02/sc") || se.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd")) {
                        target.setValue("#" + Id);
                        target.setType("uri");
                    } else {
                        QName qname = new QName(se.getNamespaceURI(), se.getLocalName());
                        target.setQName(qname);
                        target.setType("qname");
                    }
                } else {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1376_FAILED_VERIFY_POLICY_NO_ELEMENTBY_ID());
                    throw new XWSSecurityException("Policy verification for Signature failed: Element with Id: " + Id + "not found in message");
                }
            }
            featureBinding.addTargetBinding(target);
        }
    }

    public SignatureTarget.Transform getSignatureTransform(Reference reference) {
        List<Transform> transformList = reference.getTransforms();
        Iterator<Transform> transformItr = transformList.iterator();
        SignatureTarget.Transform transform = null;
        while (transformItr.hasNext()) {
            Transform trObj = transformItr.next();
            String algorithm = trObj.getAlgorithm();
            transform = new SignatureTarget.Transform();
            transform.setTransform(algorithm);
            AlgorithmParameterSpec paramSpec = trObj.getParameterSpec();
            transform.setAlgorithmParameters(paramSpec);
        }
        return transform;
    }

    public void addCanonicalizationParams(AlgorithmParameterSpec algoSpec, HashMap paramList) {
        if (algoSpec instanceof XPathFilterParameterSpec) {
            XPathFilterParameterSpec spec = (XPathFilterParameterSpec)algoSpec;
            paramList.put("XPATH", spec.getXPath());
        } else if (algoSpec instanceof XPathFilter2ParameterSpec) {
            XPathFilter2ParameterSpec spec = (XPathFilter2ParameterSpec)algoSpec;
            paramList.put("XPATH2", spec.getXPathList());
        }
    }

    private SignedInfo generateSignedInfo(FilterProcessingContext fpContext) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, XWSSecurityException {
        SignaturePolicy signaturePolicy = (SignaturePolicy)fpContext.getSecurityPolicy();
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)signaturePolicy.getFeatureBinding();
        MLSPolicy keyBinding = signaturePolicy.getKeyBinding();
        XMLSignatureFactory signatureFactory = this.getSignatureFactory();
        SecurableSoapMessage secureMessage = fpContext.getSecurableSoapMessage();
        String canonicalAlgo = featureBinding.getCanonicalizationAlgorithm();
        boolean disableInclusivePrefix = featureBinding.getDisableInclusivePrefix();
        ArrayList targetList = featureBinding.getTargetBindings();
        String keyAlgo = null;
        String algo = "SHA1withRSA";
        if (fpContext.getAlgorithmSuite() != null) {
            algo = fpContext.getAlgorithmSuite().getSignatureAlgorithm();
        }
        keyAlgo = SecurityUtil.getKeyAlgo(algo);
        if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
            AuthenticationTokenPolicy.X509CertificateBinding certificateBinding = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding;
            if (!"".equals(certificateBinding.getKeyAlgorithm())) {
                keyAlgo = certificateBinding.getKeyAlgorithm();
            }
        } else if (PolicyTypeUtil.samlTokenPolicy(keyBinding)) {
            AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
            if (!"".equals(samlBinding.getKeyAlgorithm())) {
                keyAlgo = samlBinding.getKeyAlgorithm();
            }
        } else if (PolicyTypeUtil.symmetricKeyBinding(keyBinding)) {
            SymmetricKeyBinding symmetricKeybinding = (SymmetricKeyBinding)keyBinding;
            keyAlgo = !"".equals(symmetricKeybinding.getKeyAlgorithm()) ? symmetricKeybinding.getKeyAlgorithm() : "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        } else if (PolicyTypeUtil.secureConversationTokenKeyBinding(keyBinding)) {
            keyAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        } else if (PolicyTypeUtil.derivedTokenKeyBinding(keyBinding)) {
            keyAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
            if (PolicyTypeUtil.issuedTokenKeyBinding(((DerivedTokenKeyBinding)keyBinding).getOriginalKeyBinding()) && fpContext.getTrustContext().getProofKey() == null) {
                keyAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            }
        } else if (PolicyTypeUtil.issuedTokenKeyBinding(keyBinding)) {
            keyAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
            if (fpContext.getTrustContext().getProofKey() == null) {
                keyAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            }
        } else {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1335_UNSUPPORTED_KEYBINDING_SIGNATUREPOLICY());
            throw new XWSSecurityException("Unsupported KeyBinding for SignaturePolicy");
        }
        ExcC14NParameterSpec spec = null;
        if ("http://www.w3.org/2001/10/xml-exc-c14n#".equalsIgnoreCase(canonicalAlgo)) {
            if (featureBinding.isBSP() || !disableInclusivePrefix) {
                List inc = WSSPolicyConsumerImpl.getInclusiveNamespacePrefixes((Element)((Object)secureMessage.findSecurityHeader()), false);
                spec = new ExcC14NParameterSpec(inc);
            } else {
                spec = null;
            }
        }
        CanonicalizationMethod canonicalMethod = signatureFactory.newCanonicalizationMethod(canonicalAlgo, spec);
        SignatureMethod signatureMethod = signatureFactory.newSignatureMethod(keyAlgo, null);
        return signatureFactory.newSignedInfo(canonicalMethod, signatureMethod, this.generateReferenceList(targetList, signatureFactory, secureMessage, fpContext, false, featureBinding.isEndorsingSignature()), null);
    }

    public static List getInclusiveNamespacePrefixes(Element target, boolean excludeVisiblePrefixes) {
        ArrayList<String> result = new ArrayList<String>();
        Node parent = target;
        while (!(parent instanceof Document)) {
            NamedNodeMap attributes = parent.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (attribute.getNamespaceURI() == null || !attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                result.add(attribute.getLocalName());
            }
            parent = parent.getParentNode();
        }
        return result;
    }

    public static List getReferenceNamespacePrefixes(Node target) {
        ArrayList result = new ArrayList();
        WSSPolicyConsumerImpl.traverseSubtree(target, result);
        return result;
    }

    private static void traverseSubtree(Node node, List result) {
        SOAPElement element = (SOAPElement)node;
        Iterator visible = element.getVisibleNamespacePrefixes();
        while (visible.hasNext()) {
            String prefix = (String)visible.next();
            if (result.contains(prefix)) continue;
            result.add(prefix);
        }
        Iterator children = element.getChildElements();
        while (children.hasNext()) {
            Node child = (Node)children.next();
            if (child instanceof Text) continue;
            WSSPolicyConsumerImpl.traverseSubtree(child, result);
        }
    }

    public List generateReferenceList(List targetList, SecurableSoapMessage secureMessage, FilterProcessingContext fpContext, boolean verify, boolean isEndorsing) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, XWSSecurityException {
        XMLSignatureFactory factory = this.getSignatureFactory();
        return this.generateReferenceList(targetList, factory, secureMessage, fpContext, verify, isEndorsing);
    }

    private List generateReferenceList(List targetList, XMLSignatureFactory signatureFactory, SecurableSoapMessage secureMessage, FilterProcessingContext fpContext, boolean verify, boolean isEndorsing) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, XWSSecurityException {
        SignaturePolicy signaturePolicy = (SignaturePolicy)fpContext.getSecurityPolicy();
        SignaturePolicy.FeatureBinding featureBinding = (SignaturePolicy.FeatureBinding)signaturePolicy.getFeatureBinding();
        ListIterator iterator = targetList.listIterator();
        ArrayList<Reference> references = new ArrayList<Reference>();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Number of Targets is" + targetList.size());
        }
        while (iterator.hasNext()) {
            SignatureTarget signatureTarget = (SignatureTarget)iterator.next();
            String digestAlgo = signatureTarget.getDigestAlgorithm();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Digest Algorithm is " + digestAlgo);
                logger.log(Level.FINEST, "Targets is" + signatureTarget.getValue());
            }
            DigestMethod digestMethod = null;
            try {
                digestMethod = signatureFactory.newDigestMethod(digestAlgo, null);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1301_INVALID_DIGEST_ALGO(digestAlgo), ex);
                throw new XWSSecurityException(ex.getMessage());
            }
            boolean exclTransformToBeAdded = false;
            ArrayList transforms = signatureTarget.getTransforms();
            ListIterator transformIterator = transforms.listIterator();
            ArrayList<Transform> transformList = new ArrayList<Transform>(2);
            boolean disableInclusivePrefix = false;
            while (transformIterator.hasNext()) {
                TransformParameterSpec transformParams;
                SignatureTarget.Transform transformInfo = (SignatureTarget.Transform)transformIterator.next();
                String transformAlgo = transformInfo.getTransform();
                Transform transform = null;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Transform Algorithm is " + transformAlgo);
                }
                if (transformAlgo == "http://www.w3.org/TR/1999/REC-xpath-19991116" || transformAlgo.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
                    TransformParameterSpec spec = (TransformParameterSpec)transformInfo.getAlgorithmParameters();
                    if (spec == null) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1367_ILLEGAL_XPATH());
                        throw new XWSSecurityException("XPATH parameters cannot be null");
                    }
                    transform = signatureFactory.newTransform(transformAlgo, spec);
                } else if (transformAlgo == "http://www.w3.org/2002/06/xmldsig-filter2" || transformAlgo.equals("http://www.w3.org/2002/06/xmldsig-filter2")) {
                    transformParams = (TransformParameterSpec)transformInfo.getAlgorithmParameters();
                    transform = signatureFactory.newTransform(transformAlgo, transformParams);
                } else if (transformAlgo == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform" || transformAlgo.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform")) {
                    transformParams = (Parameter)transformInfo.getAlgorithmParameters();
                    String algo = null;
                    if (((Parameter)transformParams).getParamName().equals("CanonicalizationMethod")) {
                        algo = ((Parameter)transformParams).getParamValue();
                    }
                    if (algo == null) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1368_ILLEGAL_STR_CANONCALIZATION());
                        throw new XWSSecurityException("STR Transform must have acanonicalization method specified");
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "CanonicalizationMethod is " + algo);
                    }
                    Object cm = null;
                    Object spec = null;
                    try {
                        Document doc = WSITXMLFactory.createDocumentBuilderFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING).newDocumentBuilder().newDocument();
                        Element tp = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:TransformationParameters");
                        Element cem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
                        tp.appendChild(cem);
                        cem.setAttribute("Algorithm", algo);
                        doc.appendChild(tp);
                        DOMStructure transformSpec = new DOMStructure(tp);
                        transform = signatureFactory.newTransform(transformAlgo, transformSpec);
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1300_DSIG_TRANSFORM_PARAM_ERROR(), ex);
                        throw new XWSSecurityException(ex.getMessage());
                    }
                } else if ("http://www.w3.org/2001/10/xml-exc-c14n#".equalsIgnoreCase(transformAlgo)) {
                    exclTransformToBeAdded = true;
                    disableInclusivePrefix = transformInfo.getDisableInclusivePrefix();
                } else {
                    transform = signatureFactory.newTransform(transformAlgo, (TransformParameterSpec)null);
                }
                if ("http://www.w3.org/2001/10/xml-exc-c14n#".equalsIgnoreCase(transformAlgo)) continue;
                transformList.add(transform);
            }
            Object targetURI = "";
            String signatureType = signatureTarget.getType();
            SOAPMessage msg = secureMessage.getSOAPMessage();
            boolean headersOnly = signatureTarget.isSOAPHeadersOnly();
            if (signatureType.equals("qname") || signatureType.equals("xpath")) {
                String expr = null;
                NodeList nodes = null;
                if (signatureType == "qname") {
                    boolean optimized;
                    String targetValue = signatureTarget.getValue();
                    boolean bl = optimized = fpContext.getConfigType() == 1 || fpContext.getConfigType() == 2;
                    if (targetValue.equals("{http://schemas.xmlsoap.org/soap/envelope/}Body")) {
                        try {
                            SOAPBody se = msg.getSOAPBody();
                            nodes = new NodeList((SOAPElement)se){
                                Node node;
                                final /* synthetic */ SOAPElement val$se;
                                {
                                    this.val$se = sOAPElement;
                                    this.node = this.val$se;
                                }

                                @Override
                                public int getLength() {
                                    if (this.node == null) {
                                        return 0;
                                    }
                                    return 1;
                                }

                                @Override
                                public Node item(int num) {
                                    if (num == 0) {
                                        return this.node;
                                    }
                                    return null;
                                }
                            };
                        }
                        catch (SOAPException se) {
                            logger.log(Level.SEVERE, LogStringsMessages.WSS_1369_UNABLE_GET_SIGNATURE_TARGET_BY_URI());
                            throw new XWSSecurityException("SignatureTarget with URI " + targetValue + " is not in the message");
                        }
                    } else {
                        QName name = QName.valueOf(targetValue);
                        if (!headersOnly) {
                            nodes = "".equals(name.getNamespaceURI()) ? msg.getSOAPPart().getElementsByTagName(name.getLocalPart()) : (!"".equals(name.getLocalPart()) ? msg.getSOAPPart().getElementsByTagNameNS(name.getNamespaceURI(), name.getLocalPart()) : msg.getSOAPPart().getElementsByTagNameNS(name.getNamespaceURI(), "*"));
                        } else {
                            try {
                                nodes = new NodeListImpl();
                                NodeList hdrChilds = msg.getSOAPHeader().getChildNodes();
                                for (int i = 0; i < hdrChilds.getLength(); ++i) {
                                    Node child = hdrChilds.item(i);
                                    if (child.getNodeType() != 1) continue;
                                    if ("".equals(name.getNamespaceURI())) {
                                        if (!name.getLocalPart().equals(child.getLocalName())) continue;
                                        ((NodeListImpl)nodes).add(child);
                                        continue;
                                    }
                                    if (name.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") || name.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) {
                                        if (!child.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") && !child.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) continue;
                                        if (!"".equals(name.getLocalPart())) {
                                            if (!name.getLocalPart().equals(child.getLocalName())) continue;
                                            ((NodeListImpl)nodes).add(child);
                                            continue;
                                        }
                                        ((NodeListImpl)nodes).add(child);
                                        continue;
                                    }
                                    if (!"".equals(name.getLocalPart())) {
                                        if (!name.getNamespaceURI().equals(child.getNamespaceURI()) || !name.getLocalPart().equals(child.getLocalName())) continue;
                                        ((NodeListImpl)nodes).add(child);
                                        continue;
                                    }
                                    if (!name.getNamespaceURI().equals(child.getNamespaceURI())) continue;
                                    ((NodeListImpl)nodes).add(child);
                                }
                            }
                            catch (SOAPException se) {
                                logger.log(Level.SEVERE, LogStringsMessages.WSS_1370_FAILED_PROCESS_HEADER());
                                throw new XWSSecurityException(se);
                            }
                        }
                    }
                } else {
                    expr = signatureTarget.getValue();
                    try {
                        XPathFactory xpathFactory = WSITXMLFactory.createXPathFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
                        XPath xpath = xpathFactory.newXPath();
                        xpath.setNamespaceContext(secureMessage.getNamespaceContext());
                        XPathExpression xpathExpr = xpath.compile(expr);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "++++++++++++++++++++++++++++++");
                            logger.log(Level.FINEST, "Expr is " + expr);
                            WSSPolicyConsumerImpl.printDocument((Node)secureMessage.getSOAPPart());
                        }
                        nodes = (NodeList)xpathExpr.evaluate(secureMessage.getSOAPPart(), XPathConstants.NODESET);
                    }
                    catch (XPathExpressionException xpe) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1371_FAILED_RESOLVE_X_PATH() + expr, xpe);
                        throw new XWSSecurityException(xpe);
                    }
                }
                int i = 0;
                if (nodes == null || nodes.getLength() <= 0) {
                    if (!signatureTarget.getEnforce()) continue;
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1369_UNABLE_GET_SIGNATURE_TARGET_BY_URI());
                    throw new XWSSecurityException("SignatureTarget with URI " + signatureTarget.getValue() + " is not in the message");
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Number of nodes " + nodes.getLength());
                    logger.log(Level.FINEST, "+++++++++++++++END+++++++++++++++");
                }
                HashMap elementCache = null;
                if (fpContext != null) {
                    elementCache = fpContext.getElementCache();
                }
                while (i < nodes.getLength()) {
                    Node nodeRef;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Nodes is " + nodes.item(i));
                    }
                    if ((nodeRef = nodes.item(i++)).getNodeType() != 1) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1371_FAILED_RESOLVE_X_PATH());
                        throw new XWSSecurityException("XPath does not correspond to a DOM Element");
                    }
                    ArrayList clonedTransformList = (ArrayList)transformList.clone();
                    if (exclTransformToBeAdded) {
                        String transformAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
                        ExcC14NParameterSpec spec = null;
                        if (featureBinding != null && featureBinding.isBSP() || !disableInclusivePrefix) {
                            spec = new ExcC14NParameterSpec(WSSPolicyConsumerImpl.getReferenceNamespacePrefixes(nodeRef));
                        }
                        Transform transform = signatureFactory.newTransform(transformAlgo, spec);
                        clonedTransformList.add(transform);
                    }
                    boolean w3cElem = false;
                    String id = ((Element)nodeRef).getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    if (!(id != null && !id.equals("") || nodeRef.getNamespaceURI() != "http://www.w3.org/2000/09/xmldsig#" && nodeRef.getNamespaceURI() != "http://www.w3.org/2001/04/xmlenc#")) {
                        w3cElem = true;
                        id = ((Element)nodeRef).getAttribute("Id");
                    }
                    if (id == null || id.equals("")) {
                        id = secureMessage.generateId();
                        if (!verify) {
                            if (w3cElem) {
                                XMLUtil.setIdAttr((Element)nodeRef, id);
                            } else {
                                XMLUtil.setWsuIdAttr((Element)nodeRef, id);
                            }
                        } else {
                            elementCache.put(id, nodeRef);
                        }
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "SignedInfo val id " + id);
                    }
                    targetURI = "#" + id;
                    byte[] digestValue = fpContext.getDigestValue();
                    Reference reference = null;
                    reference = !verify && digestValue != null ? signatureFactory.newReference((String)targetURI, digestMethod, clonedTransformList, null, null, digestValue) : signatureFactory.newReference((String)targetURI, digestMethod, clonedTransformList, null, null);
                    references.add(reference);
                }
                continue;
            }
            if (signatureType == "uri") {
                targetURI = signatureTarget.getValue();
                if (targetURI == null) {
                    targetURI = "";
                }
                if (targetURI == "cid:*") {
                    Iterator<AttachmentPart> itr = secureMessage.getAttachments();
                    if (!itr.hasNext()) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1372_NO_ATTACHMENT_FOUND());
                        throw new XWSSecurityException("No attachment present in the message");
                    }
                    while (itr.hasNext()) {
                        String cid = null;
                        AttachmentPart ap = itr.next();
                        String _cid = ap.getContentId();
                        if (_cid.charAt(0) == '<' && _cid.charAt(_cid.length() - 1) == '>') {
                            int sindex;
                            int lindex = _cid.lastIndexOf(62);
                            if (lindex < (sindex = _cid.indexOf(60)) || lindex == sindex) {
                                logger.log(Level.SEVERE, LogStringsMessages.WSS_1303_CID_ERROR());
                            }
                            cid = "cid:" + _cid.substring(sindex + 1, lindex);
                        } else {
                            cid = "cid:" + _cid;
                        }
                        Reference reference = signatureFactory.newReference(cid, digestMethod, transformList, null, null);
                        references.add(reference);
                    }
                    continue;
                }
                if (exclTransformToBeAdded) {
                    SOAPElement dataElement = null;
                    if (featureBinding != null && featureBinding.isBSP()) {
                        String _uri = targetURI;
                        if (((String)targetURI).length() > 0 && ((String)targetURI).charAt(0) == '#') {
                            _uri = ((String)targetURI).substring(1);
                        }
                        dataElement = (SOAPElement)secureMessage.getElementById(_uri);
                    }
                    String transformAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
                    ExcC14NParameterSpec spec = null;
                    if (dataElement != null && !disableInclusivePrefix) {
                        spec = new ExcC14NParameterSpec(WSSPolicyConsumerImpl.getReferenceNamespacePrefixes(dataElement));
                    }
                    Transform transform = signatureFactory.newTransform(transformAlgo, spec);
                    transformList.add(transform);
                }
                if (((String)targetURI).equals("ALL_MESSAGE_HEADERS")) {
                    SOAPHeader soapHeader = null;
                    try {
                        soapHeader = secureMessage.getSOAPHeader();
                    }
                    catch (SOAPException se) {
                        se.printStackTrace();
                    }
                    NodeList headers = soapHeader.getChildNodes();
                    Reference reference = null;
                    for (int i = 0; i < headers.getLength(); ++i) {
                        Element element;
                        if (headers.item(i).getNodeType() != 1 || "Security".equals((element = (Element)headers.item(i)).getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(element.getNamespaceURI())) continue;
                        reference = signatureFactory.newReference("#" + this.generateReferenceID(element, secureMessage), digestMethod, transformList, null, null);
                        references.add(reference);
                    }
                    continue;
                }
            }
            byte[] digestValue = fpContext.getDigestValue();
            Reference reference = null;
            reference = !verify && digestValue != null ? signatureFactory.newReference((String)targetURI, digestMethod, transformList, null, null, digestValue) : signatureFactory.newReference((String)targetURI, digestMethod, transformList, null, null);
            references.add(reference);
        }
        if (references.isEmpty() && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, LogStringsMessages.WSS_1375_NO_SIGNEDPARTS());
        }
        return references;
    }

    private String generateReferenceID(Element secElement, SecurableSoapMessage securableSoapMessage) {
        String id = secElement.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id == null || id.equals("")) {
            id = securableSoapMessage.generateId();
            XMLUtil.setWsuIdAttr(secElement, id);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Element wsu:id attribute is: " + id);
        }
        return id;
    }

    public URIDereferencer getDefaultResolver() {
        if (this.externalURIResolver == null) {
            this.externalURIResolver = this.getSignatureFactory().getURIDereferencer();
        }
        return this.externalURIResolver;
    }

    public static void printDocument(Node node) {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "\n");
            }
            Transformer transformer = WSITXMLFactory.createTransformerFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING).newTransformer();
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(node), new StreamResult(baos));
            byte[] bytes = baos.toByteArray();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, baos.toString());
                logger.log(Level.FINEST, "\n");
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1374_FAILEDTO_PRINT_DOCUMENT(), ex);
            throw new RuntimeException(ex);
        }
    }

    public static final class WSSProvider
    extends Provider {
        private static final String INFO = "WSS_TRANSFORM (DOM WSS_TRANSFORM_PROVIDER)";
        private static final long serialVersionUID = -6086707055770878680L;

        public WSSProvider() {
            super("WSS_TRANSFORM", "1.0", INFO);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Complete-Transform", "com.sun.xml.wss.impl.transform.ACTransform");
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Complete-Transform MechanismType", "DOM");
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "com.sun.xml.wss.impl.transform.DOMSTRTransform");
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform MechanismType", "DOM");
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform", "com.sun.xml.wss.impl.transform.ACOTransform");
            map.put("TransformService.http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform MechanismType", "DOM");
            this.putAll((Map<?, ?>)map);
        }
    }
}

