/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ManagedScheduledExecutorDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorDefinition;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ManagedScheduledExecutorDefinition.class)
public class ManagedScheduledExecutorDefinitionHandler
extends AbstractResourceHandler {
    private static final Logger logger = Logger.getLogger(ManagedScheduledExecutorDefinitionHandler.class.getName());

    protected HandlerProcessingResult processAnnotation(AnnotationInfo annotationInfo, ResourceContainerContext[] resourceContainerContexts) throws AnnotationProcessorException {
        logger.log(Level.INFO, "Entering ManagedScheduledExecutorDefinitionHandler.processAnnotation");
        ManagedScheduledExecutorDefinition managedScheduledExecutorDefinition = (ManagedScheduledExecutorDefinition)annotationInfo.getAnnotation();
        return this.processAnnotation(managedScheduledExecutorDefinition, resourceContainerContexts);
    }

    protected HandlerProcessingResult processAnnotation(ManagedScheduledExecutorDefinition managedScheduledExecutorDefinition, ResourceContainerContext[] contexts) {
        logger.log(Level.INFO, "Registering ManagedScheduledExecutorDefinitionHandler from annotation config");
        for (ResourceContainerContext context : contexts) {
            ManagedScheduledExecutorDefinitionDescriptor msedd;
            Set resourceDescriptors = context.getResourceDescriptors(JavaEEResourceType.MSEDD);
            if (this.descriptorAlreadyPresent(resourceDescriptors, msedd = this.createDescriptor(managedScheduledExecutorDefinition))) {
                this.merge(resourceDescriptors, managedScheduledExecutorDefinition);
                continue;
            }
            resourceDescriptors.add(msedd);
        }
        return this.getDefaultProcessedResult();
    }

    public ManagedScheduledExecutorDefinitionDescriptor createDescriptor(ManagedScheduledExecutorDefinition managedScheduledExecutorDefinition) {
        ManagedScheduledExecutorDefinitionDescriptor msedd = new ManagedScheduledExecutorDefinitionDescriptor();
        msedd.setName(TranslatedConfigView.expandValue(managedScheduledExecutorDefinition.name()));
        msedd.setContext(TranslatedConfigView.expandValue(managedScheduledExecutorDefinition.context()));
        if (managedScheduledExecutorDefinition.hungTaskThreshold() < 0L) {
            msedd.setHungTaskThreshold(0L);
        } else {
            msedd.setHungTaskThreshold(managedScheduledExecutorDefinition.hungTaskThreshold());
        }
        if (managedScheduledExecutorDefinition.maxAsync() < 0) {
            msedd.setMaxAsync(Integer.MAX_VALUE);
        } else {
            msedd.setMaxAsync(managedScheduledExecutorDefinition.maxAsync());
        }
        msedd.setMetadataSource(MetadataSource.ANNOTATION);
        return msedd;
    }

    private boolean descriptorAlreadyPresent(Set<ResourceDescriptor> resourceDescriptors, ManagedScheduledExecutorDefinitionDescriptor msedd) {
        Optional<ResourceDescriptor> optResourceDescriptor = resourceDescriptors.stream().filter(d -> d.equals(msedd)).findAny();
        return optResourceDescriptor.isPresent();
    }

    private void merge(Set<ResourceDescriptor> resourceDescriptors, ManagedScheduledExecutorDefinition msed) {
        for (ResourceDescriptor resource : resourceDescriptors) {
            ManagedScheduledExecutorDefinitionDescriptor descriptor = (ManagedScheduledExecutorDefinitionDescriptor)resource;
            if (!descriptor.getName().equals(msed.name())) continue;
            if (descriptor.getHungTaskThreshold() == -1L && msed.hungTaskThreshold() != -1L) {
                descriptor.setHungTaskThreshold(msed.hungTaskThreshold());
            }
            if (descriptor.getMaxAsync() == -1) {
                descriptor.setMaxAsync(msed.maxAsync());
            }
            if (descriptor.getContext() != null || msed.context() == null || msed.context().isBlank()) continue;
            descriptor.setContext(TranslatedConfigView.expandValue(msed.context()));
        }
    }
}

