/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.jakartaee;

import com.sun.enterprise.config.serverbeans.Server;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.kernel.jakartaee.MEJBService;

public class MEJBNamingObjectProxy
implements NamingObjectProxy {
    private static final String NON_PORTABLE_MEJB_JNDI_NAME = "ejb/mgmt/MEJB";
    private static final String PORTABLE_MEJB_JNDI_NAME_SHORT = "java:global/mejb/MEJBBean";
    private static final String PORTABLE_MEJB_JNDI_NAME_LONG = "java:global/mejb/MEJBBean!org.glassfish.admin.mejb.MEJBHome";
    private static String[] jndiNames = new String[]{"ejb/mgmt/MEJB", "java:global/mejb/MEJBBean", "java:global/mejb/MEJBBean!org.glassfish.admin.mejb.MEJBHome"};
    private ServiceLocator habitat;
    private static final Logger _logger = Logger.getLogger(MEJBService.class.getName());

    public MEJBNamingObjectProxy(ServiceLocator habitat) {
        this.habitat = habitat;
    }

    static String[] getJndiNames() {
        return jndiNames;
    }

    @Override
    public Object create(Context ic) throws NamingException {
        Object mEJBHome = null;
        try {
            this.unpublishJndiNames();
            this.deployMEJB();
            mEJBHome = ic.lookup(NON_PORTABLE_MEJB_JNDI_NAME);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Exception e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.initCause(e);
            throw namingException;
        }
        return mEJBHome;
    }

    private void unpublishJndiNames() throws NamingException {
        GlassfishNamingManager gfNamingManager = (GlassfishNamingManager)this.habitat.getService(GlassfishNamingManager.class, new Annotation[0]);
        for (String next : MEJBNamingObjectProxy.getJndiNames()) {
            gfNamingManager.unpublishObject(next);
        }
    }

    private void deployMEJB() throws IOException {
        String targetName;
        _logger.info("Loading MEJB app on JNDI look up");
        ServerContext serverContext = (ServerContext)this.habitat.getService(ServerContext.class, new Annotation[0]);
        File mejbArchive = new File(serverContext.getInstallRoot(), "lib/install/applications/mejb.jar");
        DeployCommandParameters deployParams = new DeployCommandParameters(mejbArchive);
        deployParams.target = targetName = ((Server)this.habitat.getService(Server.class, "default-instance-name", new Annotation[0])).getName();
        deployParams.name = "mejb";
        ActionReport report = (ActionReport)this.habitat.getService(ActionReport.class, "plain", new Annotation[0]);
        Deployment deployment = (Deployment)this.habitat.getService(Deployment.class, new Annotation[0]);
        ExtendedDeploymentContext dc = deployment.getBuilder(_logger, (OpsParams)deployParams, report).source(mejbArchive).build();
        deployment.deploy(dc);
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            throw new RuntimeException("Failed to deploy MEJB app: " + report.getFailureCause());
        }
    }
}

