/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.web;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.security.permissionsxml.CommponentType;
import com.sun.enterprise.security.permissionsxml.SetPermissionsAction;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.DirContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.naming.resources.WebDirContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.web.loader.LogFacade;
import org.glassfish.web.loader.WebappClassLoader;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service(name="war")
public class WarHandler
extends AbstractArchiveHandler {
    private static final String GLASSFISH_WEB_XML = "WEB-INF/glassfish-web.xml";
    private static final String PAYARA_WEB_XML = "WEB-INF/payara-web.xml";
    private static final String SUN_WEB_XML = "WEB-INF/sun-web.xml";
    private static final String WEBLOGIC_XML = "WEB-INF/weblogic.xml";
    private static final String WAR_CONTEXT_XML = "META-INF/context.xml";
    private static final String DEFAULT_CONTEXT_XML = "config/context.xml";
    private static final Logger logger = LogFacade.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WarHandler.class);
    private static final boolean gfDDOverWLSDD = Boolean.valueOf(System.getProperty("gfdd.over.wlsdd"));
    private static final boolean ignoreWLSDD = Boolean.valueOf(System.getProperty("ignore.wlsdd"));
    @Inject
    @Named(value="war")
    private ArchiveDetector detector;
    @Inject
    @Named(value="default-instance-name")
    private Config serverConfig;
    @Inject
    private ServerEnvironment serverEnvironment;

    public String getArchiveType() {
        return "war";
    }

    public String getVersionIdentifier(ReadableArchive archive) {
        String versionIdentifierValue = null;
        try {
            WebXmlParser webXmlParser = this.getWebXmlParser(archive, Application.createApplication());
            versionIdentifierValue = webXmlParser.getVersionIdentifier();
        }
        catch (XMLStreamException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        return versionIdentifierValue;
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return this.detector.handles(archive);
    }

    public ClassLoader getClassLoader(final ClassLoader parent, DeploymentContext context) {
        Application applicationTemp = (Application)context.getModuleMetaData(Application.class);
        final boolean hotDeploy = ((DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class)).hotDeploy;
        final Application application = applicationTemp == null ? Application.createApplication() : applicationTemp;
        WebappClassLoader cloader = AccessController.doPrivileged(new PrivilegedAction<WebappClassLoader>(){

            @Override
            public WebappClassLoader run() {
                return new WebappClassLoader(parent, application, hotDeploy);
            }
        });
        try {
            WebDirContext r = new WebDirContext();
            File base = new File(context.getSource().getURI());
            r.setDocBase(base.getAbsolutePath());
            cloader.setResources((DirContext)r);
            File classesPath = new File(base, "WEB-INF/classes/");
            if (!classesPath.exists()) {
                classesPath.mkdirs();
            }
            cloader.addRepository("WEB-INF/classes/", classesPath);
            if (context.getScratchDir("ejb") != null) {
                cloader.addRepository(context.getScratchDir("ejb").toURI().toURL().toString().concat("/"));
            }
            if (context.getScratchDir("jsp") != null) {
                cloader.setWorkDir(context.getScratchDir("jsp"));
            }
            for (URL url : this.getManifestLibraries(context)) {
                cloader.addRepository(url.toString());
            }
            WebXmlParser webXmlParser = this.getWebXmlParser(context.getSource(), application);
            this.configureLoaderAttributes(cloader, webXmlParser, base);
            this.configureLoaderProperties(cloader, webXmlParser, base);
            this.configureContextXmlAttribute(cloader, base, context);
            try {
                AccessController.doPrivileged(new SetPermissionsAction(CommponentType.war, context, (ClassLoader)cloader));
            }
            catch (PrivilegedActionException e) {
                throw new SecurityException(e.getException());
            }
        }
        catch (XMLStreamException xse) {
            logger.log(Level.SEVERE, xse.getMessage());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, xse.getMessage(), xse);
            }
            xse.printStackTrace();
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, ioe.getMessage());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, ioe.getMessage(), ioe);
            }
            ioe.printStackTrace();
        }
        cloader.start();
        return cloader;
    }

    protected WebXmlParser getWebXmlParser(ReadableArchive archive, Application application) throws XMLStreamException, IOException {
        WebXmlParser webXmlParser = null;
        boolean hasWSLDD = archive.exists(WEBLOGIC_XML);
        File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
        webXmlParser = runtimeAltDDFile != null && "glassfish-web.xml".equals(runtimeAltDDFile.getPath()) && runtimeAltDDFile.isFile() ? new GlassFishWebXmlParser(archive, application) : (!gfDDOverWLSDD && !ignoreWLSDD && hasWSLDD ? new WeblogicXmlParser(archive) : (archive.exists(PAYARA_WEB_XML) ? new PayaraWebXmlParser(archive, application) : (archive.exists(GLASSFISH_WEB_XML) ? new GlassFishWebXmlParser(archive, application) : (archive.exists(SUN_WEB_XML) ? new SunWebXmlParser(archive, application) : (gfDDOverWLSDD && !ignoreWLSDD && hasWSLDD ? new WeblogicXmlParser(archive) : (gfDDOverWLSDD || ignoreWLSDD ? new GlassFishWebXmlParser(archive, application) : new WeblogicXmlParser(archive)))))));
        return webXmlParser;
    }

    protected void configureLoaderAttributes(WebappClassLoader cloader, WebXmlParser webXmlParser, File base) {
        String extraClassPath;
        boolean delegate = webXmlParser.isDelegate();
        cloader.setDelegate(delegate);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WebModule[" + base + "]: Setting delegate to " + delegate);
        }
        if ((extraClassPath = webXmlParser.getExtraClassPath()) != null) {
            String[] pathElements;
            for (String path : pathElements = extraClassPath.split(";|((?<!\\\\):)")) {
                path = path.replace("\\:", ":");
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("WarHandler[" + base + "]: Adding " + path + " to the classpath");
                }
                try {
                    URL url = new URL(path);
                    cloader.addRepository(path);
                }
                catch (MalformedURLException mue1) {
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(base.getPath(), path);
                    }
                    try {
                        URL url = file.toURI().toURL();
                        cloader.addRepository(url.toString());
                    }
                    catch (MalformedURLException mue2) {
                        String msg = rb.getString("AS-WEB-UTIL-00027");
                        Object[] params = new Object[]{path};
                        msg = MessageFormat.format(msg, params);
                        logger.log(Level.SEVERE, msg, mue2);
                    }
                }
            }
        }
    }

    protected void configureLoaderProperties(WebappClassLoader cloader, WebXmlParser webXmlParser, File base) {
        cloader.setCookieSameSiteValue(webXmlParser.getCookieSameSiteValue());
        cloader.setUseMyFaces(webXmlParser.isUseBundledJSF());
        File libDir = new File(base, "WEB-INF/lib");
        if (libDir.exists()) {
            int baseFileLen = base.getPath().length();
            final boolean ignoreHiddenJarFiles = webXmlParser.isIgnoreHiddenJarFiles();
            for (File file : libDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String fileName = pathname.getName();
                    return !(!fileName.endsWith(".jar") && !fileName.endsWith(".zip") || ignoreHiddenJarFiles && fileName.startsWith("."));
                }
            })) {
                try {
                    if (file.isDirectory()) {
                        cloader.addRepository("WEB-INF/lib/" + file.getName() + "/", file);
                        continue;
                    }
                    cloader.addJar(file.getPath().substring(baseFileLen), new JarFile(file), file);
                    cloader.closeJARs(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void configureContextXmlAttribute(WebappClassLoader cloader, File base, DeploymentContext dc) throws XMLStreamException, IOException {
        File warContextXml;
        boolean consistent = true;
        Boolean value = null;
        String app = dc.getAppProps().getProperty("context-root");
        if (cloader.getCookieSameSiteValue() != null && app != null && !"".equals(cloader.getCookieSameSiteValue())) {
            app = app.substring(1).toLowerCase();
            System.setProperty(app + ".sameSite", cloader.getCookieSameSiteValue());
        }
        if ((warContextXml = new File(base.getAbsolutePath(), WAR_CONTEXT_XML)).exists()) {
            ContextXmlParser parser = new ContextXmlParser(warContextXml);
            value = parser.getClearReferencesStatic();
        }
        if (value == null) {
            Boolean domainCRS = null;
            File defaultContextXml = new File(this.serverEnvironment.getInstanceRoot(), DEFAULT_CONTEXT_XML);
            if (defaultContextXml.exists()) {
                ContextXmlParser parser = new ContextXmlParser(defaultContextXml);
                domainCRS = parser.getClearReferencesStatic();
            }
            ArrayList<Boolean> csrs = new ArrayList<Boolean>();
            HttpService httpService = this.serverConfig.getHttpService();
            DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            String vsIDs = params.virtualservers;
            List<String> vsList = StringUtils.parseStringList(vsIDs, " ,");
            if (httpService != null && vsList != null && !vsList.isEmpty()) {
                for (VirtualServer vsBean : httpService.getVirtualServer()) {
                    File contextXml;
                    if (!vsList.contains(vsBean.getId())) continue;
                    Boolean csr = null;
                    Property prop = vsBean.getProperty("contextXmlDefault");
                    if (prop != null && (contextXml = new File(this.serverEnvironment.getInstanceRoot(), prop.getValue())).exists()) {
                        ContextXmlParser parser = new ContextXmlParser(contextXml);
                        csr = parser.getClearReferencesStatic();
                    }
                    if (csr == null) {
                        csr = domainCRS;
                    }
                    csrs.add(csr);
                }
                for (Boolean b : csrs) {
                    if (b == null) continue;
                    if (value != null && !b.equals(value)) {
                        consistent = false;
                        break;
                    }
                    value = b;
                }
            }
        }
        if (consistent) {
            if (value != null) {
                cloader.setClearReferencesStatic(value);
            }
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "AS-WEB-UTIL-00028");
        }
    }

    public List<URI> getClassPathURIs(ReadableArchive archive) {
        List uris = super.getClassPathURIs(archive);
        try {
            File archiveFile = new File(archive.getURI());
            if (archiveFile.exists() && archiveFile.isDirectory()) {
                uris.add(new URI(archive.getURI().toString() + "WEB-INF/classes/"));
                File webInf = new File(archiveFile, "WEB-INF");
                File webInfLib = new File(webInf, "lib");
                if (webInfLib.exists()) {
                    uris.addAll(ASClassLoaderUtil.getLibDirectoryJarURIs((File)webInfLib));
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return uris;
    }

    protected class ContextXmlParser
    extends BaseXmlParser {
        protected Boolean clearReferencesStatic;

        ContextXmlParser(File contextXmlFile) throws XMLStreamException, IOException {
            this.clearReferencesStatic = null;
            if (contextXmlFile.exists()) {
                try (FileInputStream is = new FileInputStream(contextXmlFile);){
                    this.init(is);
                }
            }
        }

        @Override
        protected void read(InputStream input) throws XMLStreamException {
            this.parser = WarHandler.getXMLInputFactory().createXMLStreamReader(input);
            int event = 0;
            while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("Context".equals(name)) {
                    String path = null;
                    Boolean crs = null;
                    int count = this.parser.getAttributeCount();
                    for (int i = 0; i < count; ++i) {
                        String attrName = this.parser.getAttributeName(i).getLocalPart();
                        if ("clearReferencesStatic".equals(attrName)) {
                            crs = Boolean.valueOf(this.parser.getAttributeValue(i));
                            continue;
                        }
                        if (!"path".equals(attrName)) continue;
                        path = this.parser.getAttributeValue(i);
                    }
                    if (path != null) continue;
                    this.clearReferencesStatic = crs;
                    break;
                }
                this.skipSubTree(name);
            }
        }

        Boolean getClearReferencesStatic() {
            return this.clearReferencesStatic;
        }
    }

    protected class WeblogicXmlParser
    extends WebXmlParser {
        WeblogicXmlParser(ReadableArchive archive) throws XMLStreamException, IOException {
            super(archive, Application.createApplication());
        }

        @Override
        protected String getXmlFileName() {
            return WarHandler.WEBLOGIC_XML;
        }

        @Override
        protected void read(InputStream input) throws XMLStreamException {
            this.parser = WarHandler.getXMLInputFactory().createXMLStreamReader(input);
            this.skipRoot("weblogic-web-app");
            int event = 0;
            while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("prefer-web-inf-classes".equals(name)) {
                    this.delegate = !Boolean.parseBoolean(this.parser.getElementText());
                    break;
                }
                if ("container-descriptor".equals(name)) continue;
                this.skipSubTree(name);
            }
        }

        @Override
        public String getCookieSameSiteValue() {
            return "";
        }
    }

    protected class PayaraWebXmlParser
    extends GlassFishWebXmlParser {
        private String cookieSameSiteValue;

        PayaraWebXmlParser(ReadableArchive archive, Application application) throws XMLStreamException, IOException {
            super(archive, application);
        }

        @Override
        protected String getXmlFileName() {
            return WarHandler.PAYARA_WEB_XML;
        }

        @Override
        protected String getRootElementName() {
            return "payara-web-app";
        }

        @Override
        protected void readCookieConfig() throws XMLStreamException {
            int eventType;
            while (this.parser.hasNext() && ((eventType = this.parser.next()) != 2 || !this.parser.getLocalName().equals("cookie-properties"))) {
                if (eventType != 1 || !this.parser.getLocalName().equals("property")) continue;
                String name = this.parser.getAttributeValue(null, "name");
                String value = this.parser.getAttributeValue(null, "value");
                if (name == null || !name.equals("cookieSameSite")) continue;
                this.cookieSameSiteValue = value;
            }
        }

        @Override
        public String getCookieSameSiteValue() {
            return this.cookieSameSiteValue;
        }
    }

    protected class GlassFishWebXmlParser
    extends SunWebXmlParser {
        GlassFishWebXmlParser(ReadableArchive archive, Application application) throws XMLStreamException, IOException {
            super(archive, application);
        }

        @Override
        protected String getXmlFileName() {
            return WarHandler.GLASSFISH_WEB_XML;
        }

        @Override
        protected String getRootElementName() {
            return "glassfish-web-app";
        }
    }

    protected class SunWebXmlParser
    extends WebXmlParser {
        SunWebXmlParser(ReadableArchive archive, Application application) throws XMLStreamException, IOException {
            super(archive, application);
        }

        @Override
        protected String getXmlFileName() {
            return WarHandler.SUN_WEB_XML;
        }

        @Override
        public String getCookieSameSiteValue() {
            return "";
        }

        protected String getRootElementName() {
            return "sun-web-app";
        }

        @Override
        protected void read(InputStream input) throws XMLStreamException {
            this.parser = WarHandler.getXMLInputFactory().createXMLStreamReader(input);
            int event = 0;
            boolean inClassLoader = false;
            this.skipRoot(this.getRootElementName());
            while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                if (event == 1) {
                    String attrName;
                    int i;
                    String value;
                    int count;
                    String name = this.parser.getLocalName();
                    if ("class-loader".equals(name)) {
                        count = this.parser.getAttributeCount();
                        for (int i2 = 0; i2 < count; ++i2) {
                            String attrName2 = this.parser.getAttributeName(i2).getLocalPart();
                            if ("delegate".equals(attrName2)) {
                                this.delegate = Boolean.valueOf(this.parser.getAttributeValue(i2));
                                continue;
                            }
                            if ("extra-class-path".equals(attrName2)) {
                                this.extraClassPath = this.parser.getAttributeValue(i2);
                                continue;
                            }
                            if (!"dynamic-reload-interval".equals(attrName2) || this.parser.getAttributeValue(i2) == null || !logger.isLoggable(Level.WARNING)) continue;
                            logger.log(Level.WARNING, "AS-WEB-UTIL-00029");
                        }
                        inClassLoader = true;
                        continue;
                    }
                    if (inClassLoader && "property".equals(name)) {
                        count = this.parser.getAttributeCount();
                        String propName = null;
                        value = null;
                        for (i = 0; i < count; ++i) {
                            attrName = this.parser.getAttributeName(i).getLocalPart();
                            if ("name".equals(attrName)) {
                                propName = this.parser.getAttributeValue(i);
                                continue;
                            }
                            if (!"value".equals(attrName)) continue;
                            value = this.parser.getAttributeValue(i);
                        }
                        if (propName == null || value == null) {
                            throw new IllegalArgumentException(rb.getString("AS-WEB-UTIL-00030"));
                        }
                        if ("ignoreHiddenJarFiles".equals(propName)) {
                            this.ignoreHiddenJarFiles = Boolean.parseBoolean(value);
                            continue;
                        }
                        Object[] params = new Object[]{propName, value};
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.log(Level.WARNING, "AS-WEB-UTIL-00031", params);
                        continue;
                    }
                    if ("property".equals(name)) {
                        count = this.parser.getAttributeCount();
                        String propName = null;
                        value = null;
                        for (i = 0; i < count; ++i) {
                            attrName = this.parser.getAttributeName(i).getLocalPart();
                            if ("name".equals(attrName)) {
                                propName = this.parser.getAttributeValue(i);
                                continue;
                            }
                            if (!"value".equals(attrName)) continue;
                            value = this.parser.getAttributeValue(i);
                        }
                        if (propName == null || value == null) {
                            throw new IllegalArgumentException(rb.getString("AS-WEB-UTIL-00030"));
                        }
                        if ("useMyFaces".equalsIgnoreCase(propName)) {
                            this.useBundledJSF = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (!"useBundledJsf".equalsIgnoreCase(propName)) continue;
                        this.useBundledJSF = Boolean.parseBoolean(value);
                        continue;
                    }
                    if ("version-identifier".equals(name)) {
                        this.versionIdentifier = this.parser.getElementText();
                        continue;
                    }
                    if ("whitelist-package".equals(name)) {
                        this.application.addWhitelistPackage(this.parser.getElementText());
                        continue;
                    }
                    if ("session-config".equals(name)) {
                        this.readCookieConfig();
                        continue;
                    }
                    this.skipSubTree(name);
                    continue;
                }
                if (!inClassLoader || event != 2 || !"class-loader".equals(this.parser.getLocalName())) continue;
                inClassLoader = false;
            }
        }

        protected void readCookieConfig() throws XMLStreamException {
        }
    }

    protected abstract class WebXmlParser
    extends BaseXmlParser {
        protected boolean delegate;
        protected boolean ignoreHiddenJarFiles;
        protected boolean useBundledJSF;
        protected String extraClassPath;
        protected String versionIdentifier;
        protected final Application application;

        WebXmlParser(ReadableArchive archive, Application application) throws XMLStreamException, IOException {
            this.delegate = true;
            this.ignoreHiddenJarFiles = false;
            this.useBundledJSF = false;
            this.extraClassPath = null;
            this.versionIdentifier = null;
            this.application = application;
            if (archive.exists(this.getXmlFileName())) {
                try (InputStream is = archive.getEntry(this.getXmlFileName());){
                    this.init(is);
                }
                catch (Throwable t) {
                    String msg = localStrings.getLocalString("web.deployment.exception_parsing_webxml", "Error in parsing {0} for archive [{1}]: {2}", this.getXmlFileName(), archive.getURI(), t.getMessage());
                    throw new RuntimeException(msg);
                }
            }
        }

        protected abstract String getXmlFileName();

        boolean isDelegate() {
            return this.delegate;
        }

        boolean isIgnoreHiddenJarFiles() {
            return this.ignoreHiddenJarFiles;
        }

        String getExtraClassPath() {
            return this.extraClassPath;
        }

        boolean isUseBundledJSF() {
            return this.useBundledJSF;
        }

        String getVersionIdentifier() {
            return this.versionIdentifier;
        }

        public abstract String getCookieSameSiteValue();
    }

    protected abstract class BaseXmlParser {
        protected XMLStreamReader parser = null;

        protected BaseXmlParser() {
        }

        protected abstract void read(InputStream var1) throws XMLStreamException;

        protected void init(InputStream input) throws XMLStreamException {
            try {
                this.read(input);
            }
            finally {
                if (this.parser != null) {
                    try {
                        this.parser.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        protected void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            String localName = this.parser.getLocalName();
            if (!name.equals(localName)) {
                String msg = rb.getString("AS-WEB-UTIL-00032");
                msg = MessageFormat.format(msg, name, localName);
                throw new XMLStreamException(msg);
            }
        }

        protected void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException(rb.getString("AS-WEB-UTIL-00033"));
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }
    }
}

