/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.web.loader.LogFacade;

public class CachingReflectionUtil {
    private static final Logger logger = LogFacade.getLogger();
    private static final Map<String, Class<?>> classCache = new ConcurrentHashMap();
    private static final Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>();
    private static final Map<String, Field> fieldCache = new ConcurrentHashMap<String, Field>();

    public static Class<?> getClassFromCache(String className, ClassLoader classLoader) {
        Class cls = classCache.computeIfAbsent(className, k -> {
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.FINE, "Class not found: " + className, e);
                return null;
            }
        });
        return cls;
    }

    public static Method getMethodFromCache(Class<?> cls, String methodName, boolean isPrivate, Class<?> ... parameterTypes) {
        return methodCache.computeIfAbsent(methodName, k -> {
            try {
                if (isPrivate) {
                    Method method = cls.getDeclaredMethod(methodName, parameterTypes);
                    method.setAccessible(true);
                    return method;
                }
                return cls.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.FINE, "Method not found: " + methodName, e);
                return null;
            }
        });
    }

    public static Field getFieldFromCache(Class<?> cls, String fieldName, boolean isPrivate) {
        return fieldCache.computeIfAbsent(fieldName, k -> {
            try {
                if (isPrivate) {
                    Field field = cls.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    return field;
                }
                return cls.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                logger.log(Level.FINE, "Field not found: " + fieldName, e);
                return null;
            }
        });
    }
}

