/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.persistence.jpa.PersistenceUnitInfoImpl;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;
import org.glassfish.persistence.jpa.schemageneration.SchemaGenerationProcessor;
import org.glassfish.persistence.jpa.schemageneration.SchemaGenerationProcessorFactory;

public class PersistenceUnitLoader {
    private ProviderContainerContractInfo providerContainerContractInfo;
    private EntityManagerFactory emf;
    private SchemaGenerationProcessor schemaGenerationProcessor;
    private static Logger logger = LogDomains.getLogger(PersistenceUnitLoader.class, (String)"javax.org.glassfish.persistence");
    private static final StringManager localStrings = StringManager.getManager(PersistenceUnitLoader.class);
    private static Map<String, String> integrationProperties;
    private static final String ECLIPSELINK_WEAVING_PROPERTY = "eclipselink.weaving";
    private static final String VALIDATION_MODE_PROPERTY = "jakarta.persistence.validation.mode";
    private static final String VALIDATOR_FACTORY = "jakarta.persistence.validation.factory";
    private static final String DISABLE_UPGRADE_FROM_TOPLINK_ESSENTIALS = "org.glassfish.persistence.jpa.disable.upgrade.from.toplink.essentials";

    public PersistenceUnitLoader(PersistenceUnitDescriptor puToInstatntiate, ProviderContainerContractInfo providerContainerContractInfo) {
        this.providerContainerContractInfo = providerContainerContractInfo;
        this.setSystemPropertyToEnableDoPrivilegedInEclipseLink();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(providerContainerContractInfo.getClassLoader());
        this.emf = this.loadPU(puToInstatntiate);
        Thread.currentThread().setContextClassLoader(cl);
    }

    public EntityManagerFactory getEMF() {
        return this.emf;
    }

    private void setSystemPropertyToEnableDoPrivilegedInEclipseLink() {
        String PROPERTY_NAME = "eclipselink.security.usedoprivileged";
        if (System.getProperty("eclipselink.security.usedoprivileged") == null) {
            System.setProperty("eclipselink.security.usedoprivileged", String.valueOf(Boolean.TRUE));
        }
    }

    private EntityManagerFactory loadPU(PersistenceUnitDescriptor pud) {
        ValidationMode validationMode;
        Map<String, Object> schemaGenerationOverrides;
        PersistenceProvider provider;
        this.checkForUpgradeFromTopLinkEssentials(pud);
        this.checkForDataSourceOverride(pud);
        this.calculateDefaultDataSource(pud);
        PersistenceUnitInfoImpl pInfo = new PersistenceUnitInfoImpl(pud, this.providerContainerContractInfo);
        String applicationLocation = this.providerContainerContractInfo.getApplicationLocation();
        boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
        if (fineMsgLoggable) {
            logger.fine("Loading persistence unit for application: \"" + applicationLocation + "\"pu Root is: " + pud.getPuRoot());
            logger.fine("PersistenceInfo for this pud is :\n" + pInfo);
        }
        try {
            provider = (PersistenceProvider)PersistenceProvider.class.cast(this.providerContainerContractInfo.getClassLoader().loadClass(pInfo.getPersistenceProviderClassName()).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.schemaGenerationProcessor = SchemaGenerationProcessorFactory.createSchemaGenerationProcessor(pud);
        if (this.providerContainerContractInfo.isJava2DBRequired()) {
            this.schemaGenerationProcessor.init(pud, this.providerContainerContractInfo.getDeploymentContext());
            schemaGenerationOverrides = this.schemaGenerationProcessor.getOverridesForSchemaGeneration();
        } else {
            schemaGenerationOverrides = this.schemaGenerationProcessor.getOverridesForSuppressingSchemaGeneration();
        }
        HashMap<String, String> overRides = new HashMap<String, String>(integrationProperties);
        if (schemaGenerationOverrides != null) {
            overRides.putAll(schemaGenerationOverrides);
        }
        if ((validationMode = this.getValidationMode(pud)) == ValidationMode.AUTO || validationMode == ValidationMode.CALLBACK) {
            overRides.put(VALIDATOR_FACTORY, (String)this.providerContainerContractInfo.getValidatorFactory());
        }
        if (!this.providerContainerContractInfo.isWeavingEnabled()) {
            overRides.put(ECLIPSELINK_WEAVING_PROPERTY, System.getProperty(ECLIPSELINK_WEAVING_PROPERTY, "false"));
        }
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)pInfo, overRides);
        if (fineMsgLoggable) {
            logger.logp(Level.FINE, "PersistenceUnitLoader", "loadPU", "emf = {0}", emf);
        }
        PersistenceUnitsDescriptor parent = pud.getParent();
        RootDeploymentDescriptor containingBundle = parent.getParent();
        this.providerContainerContractInfo.registerEMF(pInfo.getPersistenceUnitName(), pud.getPuRoot(), containingBundle, emf);
        if (fineMsgLoggable) {
            logger.fine("Finished loading persistence unit for application: " + applicationLocation);
        }
        return emf;
    }

    private void checkForDataSourceOverride(PersistenceUnitDescriptor pud) {
        String jtaDataSourceOverride = this.providerContainerContractInfo.getJTADataSourceOverride();
        if (jtaDataSourceOverride != null) {
            pud.setJtaDataSource(jtaDataSourceOverride);
        }
    }

    private void calculateDefaultDataSource(PersistenceUnitDescriptor pud) {
        String jtaDataSourceName = this.calculateJtaDataSourceName(pud.getTransactionType(), pud.getJtaDataSource(), pud.getNonJtaDataSource(), pud.getName());
        String nonJtaDataSourceName = this.calculateNonJtaDataSourceName(pud.getJtaDataSource(), pud.getNonJtaDataSource());
        pud.setJtaDataSource(jtaDataSourceName);
        pud.setNonJtaDataSource(nonJtaDataSourceName);
    }

    private String calculateJtaDataSourceName(String transactionType, String userSuppliedJTADSName, String userSuppliedNonJTADSName, String puName) {
        String DSName;
        if (PersistenceUnitTransactionType.valueOf((String)transactionType) != PersistenceUnitTransactionType.JTA) {
            logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getJtaDataSource", "This PU is configured as non-jta, so jta-data-source is null");
            return null;
        }
        if (!PersistenceUnitLoader.isNullOrEmpty(userSuppliedJTADSName)) {
            DSName = userSuppliedJTADSName;
        } else if (PersistenceUnitLoader.isNullOrEmpty(userSuppliedNonJTADSName)) {
            DSName = this.providerContainerContractInfo.getDefaultDataSourceName();
        } else {
            String msg = localStrings.getString("puinfo.jta-ds-not-configured", new Object[]{puName});
            throw new RuntimeException(msg);
        }
        logger.logp(Level.FINE, "PersistenceUnitLoaderImpl", "_getJtaDataSource", "JTADSName = {0}", DSName);
        return DSName;
    }

    private String calculateNonJtaDataSourceName(String userSuppliedJTADSName, String userSuppliedNonJTADSName) {
        String DSName = !PersistenceUnitLoader.isNullOrEmpty(userSuppliedNonJTADSName) ? userSuppliedNonJTADSName : (!PersistenceUnitLoader.isNullOrEmpty(userSuppliedJTADSName) ? userSuppliedJTADSName : this.providerContainerContractInfo.getDefaultDataSourceName());
        logger.logp(Level.FINE, "PersistenceUnitInfoImpl", "_getNonJtaDataSource", "nonJTADSName = {0}", DSName);
        return DSName;
    }

    static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private void checkForUpgradeFromTopLinkEssentials(PersistenceUnitDescriptor pud) {
        if (Boolean.getBoolean(DISABLE_UPGRADE_FROM_TOPLINK_ESSENTIALS)) {
            return;
        }
        boolean upgradeTopLinkEssentialsProperties = false;
        String providerClassName = pud.getProvider();
        if (providerClassName == null || providerClassName.isEmpty()) {
            upgradeTopLinkEssentialsProperties = true;
        } else if ("oracle.toplink.essentials.PersistenceProvider".equals(providerClassName) || "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider".equals(providerClassName)) {
            try {
                this.providerContainerContractInfo.getClassLoader().loadClass(providerClassName);
            }
            catch (ClassNotFoundException e) {
                String defaultProvider = PersistenceUnitInfoImpl.getDefaultprovider();
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "puloader.defaulting.provider.on.upgrade", new Object[]{pud.getName(), defaultProvider});
                }
                pud.setProvider(defaultProvider);
                upgradeTopLinkEssentialsProperties = true;
            }
        }
        if (upgradeTopLinkEssentialsProperties) {
            String TOPLINK = "toplink";
            String ECLIPSELINK = "eclipselink";
            Properties properties = pud.getProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("toplink")) continue;
                String translatedKey = "eclipselink" + key.substring("toplink".length());
                pud.addProperty(translatedKey, entry.getValue());
            }
        }
    }

    void doJava2DB() {
        if (this.schemaGenerationProcessor.isContainerDDLExecutionRequired()) {
            boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
            if (fineMsgLoggable) {
                logger.fine("<--- To Create Tables");
            }
            this.schemaGenerationProcessor.executeCreateDDL();
            if (fineMsgLoggable) {
                logger.fine("---> Done Create Tables");
            }
        }
    }

    private ValidationMode getValidationMode(PersistenceUnitDescriptor pud) {
        ValidationMode validationMode = pud.getValidationMode();
        String validationModeFromProperty = (String)pud.getProperties().get(VALIDATION_MODE_PROPERTY);
        if (validationModeFromProperty != null) {
            validationMode = ValidationMode.valueOf((String)validationModeFromProperty);
        }
        return validationMode;
    }

    static {
        HashMap<String, String> props = new HashMap<String, String>();
        String ECLIPSELINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "eclipselink.target-server";
        props.put("eclipselink.target-server", System.getProperty("eclipselink.target-server", "Glassfish"));
        String TOPLINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "toplink.target-server";
        props.put("toplink.target-server", System.getProperty("toplink.target-server", "SunAS9"));
        String HIBERNATE_TRANSACTION_MANAGER_LOOKUP_CLASS_PROPERTY = "hibernate.transaction.manager_lookup_class";
        props.put("hibernate.transaction.manager_lookup_class", System.getProperty("hibernate.transaction.manager_lookup_class", "org.hibernate.transaction.SunONETransactionManagerLookup"));
        integrationProperties = Collections.unmodifiableMap(props);
    }
}

