/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.GeneratorException;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.util.TypeUtil;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.ClientArtifactsManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.rmic.Main;

public class StaticRmiStubGenerator {
    private static final StringManager localStrings = StringManager.getManager(StaticRmiStubGenerator.class);
    private static final Logger _logger = LogDomains.getLogger(StaticRmiStubGenerator.class, (String)"javax.enterprise.system.container.ejb");
    private static final String ORG_OMG_STUB_PREFIX = "org.omg.stub.";
    private List<String> rmicOptionsList;

    public StaticRmiStubGenerator(ServiceLocator services) {
        String jh;
        String jreHome = System.getProperty("java.home");
        File jdkDir = null;
        if (jreHome != null) {
            jdkDir = OS.isDarwin() ? new File(jreHome) : new File(jreHome).getParentFile();
            jdkDir = this.getValidDirectory(jdkDir);
        }
        if (jdkDir == null && (jh = System.getProperty("JAVA_HOME")) != null) {
            jdkDir = this.getValidDirectory(new File(jh));
        }
        if (jdkDir == null) {
            _logger.warning("Cannot identify JDK location.");
        }
        JavaConfig jc = (JavaConfig)services.getService(JavaConfig.class, "default-instance-name", new Annotation[0]);
        String rmicOptions = jc.getRmicOptions();
        this.rmicOptionsList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(rmicOptions, " ");
        while (st.hasMoreTokens()) {
            String op = st.nextToken();
            this.rmicOptionsList.add(op);
            _logger.log(Level.INFO, "Detected Rmic option: " + op);
        }
    }

    public void ejbc(DeploymentContext deploymentCtx) throws Exception {
        File stubsDir = deploymentCtx.getScratchDir("ejb");
        String explodedDir = deploymentCtx.getSource().getURI().getSchemeSpecificPart();
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)deploymentCtx.getModuleMetaData(EjbBundleDescriptor.class);
        long startTime = this.now();
        String classPath = (String)deploymentCtx.getTransientAppMetaData("org.glassfish.ejb.spi.module.classpath", String.class);
        ClassLoader jcl = ejbBundle.getClassLoader();
        String gnrtrTMP = stubsDir.getCanonicalPath();
        this.progress(localStrings.getStringWithDefault("generator.processing_beans", "Processing beans..."));
        HashSet<String> allStubClasses = new HashSet<String>();
        Set<String> ejbStubClasses = this.getStubClasses(jcl, ejbBundle);
        allStubClasses.addAll(ejbStubClasses);
        this.rmic(classPath, allStubClasses, stubsDir, gnrtrTMP, explodedDir);
        _logger.log(Level.INFO, "[RMIC] RMIC execution time: " + (this.now() - startTime) + " msec");
        ArrayList<String> allClientFiles = new ArrayList<String>();
        this.addGeneratedFiles(allStubClasses, allClientFiles, stubsDir);
        ClientArtifactsManager cArtifactsManager = ClientArtifactsManager.get((DeploymentContext)deploymentCtx);
        for (String file : allClientFiles) {
            cArtifactsManager.add(stubsDir, new File(file));
        }
        _logger.log(Level.INFO, "ejbc.end", ((Application)deploymentCtx.getModuleMetaData(Application.class)).getRegistrationName());
        _logger.log(Level.INFO, "[RMIC] Total time: " + (this.now() - startTime) + " msec");
    }

    private void rmic(String classPath, Set<String> stubClasses, File destDir, String repository, String explodedDir) throws GeneratorException, IOException {
        if (stubClasses.size() == 0) {
            _logger.log(Level.INFO, "[RMIC] No code generation required");
            return;
        }
        this.progress(localStrings.getStringWithDefault("generator.compiling_rmi_iiop", "Compiling RMI-IIOP code."));
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.addAll(this.rmicOptionsList);
        cmds.add("-classpath");
        StringBuilder sb = new StringBuilder().append(System.getProperty("java.class.path"));
        sb.append(File.pathSeparator).append(explodedDir).append(File.pathSeparator).append(repository).append(File.pathSeparator).append(classPath);
        cmds.add(sb.toString());
        cmds.add("-d");
        cmds.add(destDir.toString());
        cmds.addAll(stubClasses);
        _logger.info("[RMIC] options: " + cmds);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Main compiler = new Main((OutputStream)baos, "rmic");
        boolean success = compiler.compile(cmds.toArray(new String[cmds.size()]));
        String output = baos.toString();
        if (!success) {
            _logger.warning("[RMIC] Errors: " + output);
            throw new GeneratorException(localStrings.getString("generator.rmic_compilation_failed_see_log"));
        }
    }

    private void addGeneratedFiles(Set<String> stubClasses, List<String> allClientFiles, File stubsDir) {
        for (String stubClass : stubClasses) {
            String stubFile = stubsDir.toString() + File.separator + this.getStubName(stubClass).replace('.', File.separatorChar) + ".class";
            allClientFiles.add(stubFile);
        }
        _logger.log(Level.INFO, "[RMIC] Generated client files: " + allClientFiles);
    }

    private String getStubName(String fullName) {
        String className = fullName;
        String packageName = "";
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot != -1) {
            className = fullName.substring(lastDot + 1, fullName.length());
            packageName = fullName.substring(0, lastDot + 1);
        }
        String stubName = packageName + "_" + className + "_Stub";
        if (this.isSpecialPackage(fullName)) {
            stubName = ORG_OMG_STUB_PREFIX + stubName;
        }
        return stubName;
    }

    private boolean isSpecialPackage(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith("javax.") || name.startsWith("jakarta.");
    }

    private Set getRemoteSuperInterfaces(ClassLoader jcl, String homeRemoteIntf) throws ClassNotFoundException {
        Set allSuperInterfaces = TypeUtil.getSuperInterfaces((ClassLoader)jcl, (String)homeRemoteIntf, (String)"java.rmi.Remote");
        HashSet<String> remoteSuperInterfaces = new HashSet<String>();
        for (String intfName : allSuperInterfaces) {
            Class<?> intfClass = jcl.loadClass(intfName);
            if (!Remote.class.isAssignableFrom(intfClass) || intfName.equals("jakarta.ejb.EJBHome") || intfName.equals("jakarta.ejb.EJBObject")) continue;
            remoteSuperInterfaces.add(intfName);
        }
        return remoteSuperInterfaces;
    }

    private Set<String> getStubClasses(ClassLoader jcl, EjbBundleDescriptor ejbBundle) throws IOException, ClassNotFoundException {
        HashSet<String> stubClasses = new HashSet<String>();
        for (EjbDescriptor desc : ejbBundle.getEjbs()) {
            if (!desc.isRemoteInterfacesSupported()) continue;
            String home = desc.getHomeClassName();
            String remote = desc.getRemoteClassName();
            stubClasses.add(home);
            Set homeSuperIntfs = this.getRemoteSuperInterfaces(jcl, home);
            stubClasses.addAll(homeSuperIntfs);
            stubClasses.add(remote);
            Set remoteSuperIntfs = this.getRemoteSuperInterfaces(jcl, remote);
            stubClasses.addAll(remoteSuperIntfs);
        }
        return stubClasses;
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private void progress(String message) {
        try {
            _logger.log(Level.INFO, message);
        }
        catch (Throwable t) {
            _logger.log(Level.FINER, "Cannot set status message", t);
        }
    }

    private File getValidDirectory(File f) {
        try {
            if (f != null && f.isDirectory()) {
                return f.getCanonicalFile();
            }
        }
        catch (IOException e) {
            _logger.log(Level.INFO, e.getMessage(), e);
        }
        return null;
    }
}

