/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.view.editparts;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.FBDebugViewRootEditPart;
import org.eclipse.fordiac.ide.debug.ui.view.figure.FBDebugViewFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.WithAnchor;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.WithEditPart;
import org.eclipse.gef.EditPart;

public class DebugViewWithEditPart
extends WithEditPart {
    protected void activateFigure() {
        IFigure targetFigure = this.getTargetFigure();
        if (targetFigure != null) {
            targetFigure.add(this.getFigure());
        } else {
            super.activateFigure();
        }
    }

    protected void deactivateFigure() {
        IFigure targetFigure = this.getTargetFigure();
        if (targetFigure != null) {
            targetFigure.remove(this.getFigure());
            this.getConnectionFigure().setSourceAnchor(null);
            this.getConnectionFigure().setTargetAnchor(null);
        } else {
            super.deactivateFigure();
        }
    }

    protected void createEditPolicies() {
    }

    private IFigure getTargetFigure() {
        FBDebugViewFigure debugViewFigure = this.getDebugViewFigure();
        if (debugViewFigure != null) {
            return this.isInput() ? debugViewFigure.getInputWiths() : debugViewFigure.getOutputWiths();
        }
        return null;
    }

    private FBDebugViewFigure getDebugViewFigure() {
        Object e = this.getRoot().getChildren().getFirst();
        if (e instanceof FBDebugViewRootEditPart) {
            FBDebugViewRootEditPart debugViewEP = (FBDebugViewRootEditPart)((Object)e);
            return debugViewEP.getFigure();
        }
        return null;
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        ConnectionAnchor sourceConnectionAnchor = super.getSourceConnectionAnchor();
        if (sourceConnectionAnchor instanceof WithAnchor) {
            WithAnchor withAnchor = (WithAnchor)sourceConnectionAnchor;
            if (this.isInput()) {
                return this.createInputAnchor(withAnchor);
            }
            return this.createOutputAnchor(withAnchor);
        }
        return sourceConnectionAnchor;
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        ConnectionAnchor targetConnectionAnchor = super.getTargetConnectionAnchor();
        if (targetConnectionAnchor instanceof WithAnchor) {
            WithAnchor withAnchor = (WithAnchor)targetConnectionAnchor;
            if (this.isInput()) {
                return this.createInputAnchor(withAnchor);
            }
            return this.createOutputAnchor(withAnchor);
        }
        return targetConnectionAnchor;
    }

    private ConnectionAnchor createInputAnchor(WithAnchor anchor) {
        return new WithAnchor(anchor.getOwner(), anchor.getPos(), (EditPart)this){

            public Point getLocation(Point reference) {
                Rectangle r = Rectangle.SINGLETON;
                r.setBounds(this.getBox());
                r.translate(0, -1);
                r.resize(1, 1);
                int leftX = DebugViewWithEditPart.this.getFigure().getParent().getBounds().getRight().x - (int)(10.0 * (double)this.getPos());
                int centerY = r.y + r.height / 2;
                return new Point(leftX, centerY);
            }
        };
    }

    private ConnectionAnchor createOutputAnchor(WithAnchor anchor) {
        return new WithAnchor(anchor.getOwner(), anchor.getPos(), (EditPart)this){

            public Point getLocation(Point reference) {
                Rectangle r = Rectangle.SINGLETON;
                r.setBounds(this.getBox());
                r.translate(-1, -1);
                r.resize(1, 1);
                this.getOwner().translateToAbsolute((Translatable)r);
                int leftX = DebugViewWithEditPart.this.getFigure().getParent().getBounds().x + (int)(10.0 * (double)this.getPos());
                int centerY = r.y + r.height / 2;
                return new Point(leftX, centerY);
            }
        };
    }
}

