/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.bootfile.wizard;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.deployment.bootfile.Messages;
import org.eclipse.fordiac.ide.deployment.bootfile.wizard.DownloadSelectionTree;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.widget.DirectoryChooserControl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;

public class CreateBootFilesWizardPage
extends WizardExportResourcesPage {
    private static final String SETTING_CURRENT_DIR = "currentDir";
    private final IStructuredSelection selection;
    private DirectoryChooserControl dcc;
    private DownloadSelectionTree systemTree;

    public CreateBootFilesWizardPage(IStructuredSelection selection) {
        this(Messages.FordiacCreateBootfilesWizard_PageName, selection);
    }

    protected CreateBootFilesWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, CreateBootFilesWizardPage.createResourceSelection(selection));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setDescription(Messages.FordiacCreateBootfilesWizard_PageDESCRIPTION);
        this.setTitle(Messages.FordiacCreateBootfilesWizard_PageTITLE);
        this.checkSelectedElements();
        this.updatePageCompletion();
    }

    public Object[] getSelectedElements() {
        return this.systemTree.getCheckedElements();
    }

    protected void createOptionsGroup(Composite parent) {
    }

    protected void createDestinationGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parent.getFont());
        this.createSystemsContainer(composite);
        this.createDestinationDirectorySelection(composite);
    }

    private void createSystemsContainer(Composite composite) {
        this.systemTree = new DownloadSelectionTree(composite, 66308);
        this.systemTree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.systemTree.addCheckStateListener(event -> this.updatePageCompletion());
    }

    private void createDestinationDirectorySelection(Composite composite) {
        GridData stretch = new GridData();
        stretch.grabExcessHorizontalSpace = true;
        stretch.horizontalAlignment = 4;
        this.dcc = new DirectoryChooserControl(composite, 0, Messages.CreateBootFilesWizardPage_Destination);
        this.dcc.addChooserValueChangedListener(newDirectory -> this.updatePageCompletion());
        this.dcc.setLayoutData((Object)stretch);
    }

    protected void updateWidgetEnablements() {
        this.checkSelectedResources();
        super.updateWidgetEnablements();
    }

    private void checkSelectedResources() {
        this.systemTree.setInput(this.getSelectedSystems());
    }

    private List<AutomationSystem> getSelectedSystems() {
        return this.getSelectedResources().stream().map(arg_0 -> ((TypeLibraryManager)TypeLibraryManager.INSTANCE).getTypeEntryForFile(arg_0)).filter(SystemEntry.class::isInstance).map(SystemEntry.class::cast).map(SystemEntry::getSystem).filter(Objects::nonNull).toList();
    }

    protected boolean validateSourceGroup() {
        if (this.getSelectedSystems().isEmpty()) {
            this.setErrorMessage(Messages.CreateBootFilesWizardPage_NoSystemSelected);
            return false;
        }
        return super.validateSourceGroup();
    }

    protected boolean validateDestinationGroup() {
        if (this.dcc.getValue() == null || "".equals(this.dcc.getValue())) {
            this.setErrorMessage(Messages.CreateBootFilesWizardPage_DestinationNotSelected);
            return false;
        }
        if (this.systemTree.getCheckedElements().length == 0) {
            this.setErrorMessage(Messages.CreateBootFilesWizardPage_NothingSelectedForBootFileGeneration);
            return false;
        }
        return super.validateDestinationGroup();
    }

    protected void restoreWidgetValues() {
        String cachedDir;
        super.restoreWidgetValues();
        if (this.getDialogSettings() != null && (cachedDir = this.getDialogSettings().get(SETTING_CURRENT_DIR)) != null) {
            this.setDirectory(cachedDir);
        }
    }

    protected void internalSaveWidgetValues() {
        super.internalSaveWidgetValues();
        this.getDialogSettings().put(SETTING_CURRENT_DIR, this.getDirectory());
    }

    public void saveWidgetValues() {
        super.saveWidgetValues();
    }

    public void setDirectory(String dir) {
        this.dcc.setValue(dir);
    }

    public String getDirectory() {
        return this.dcc.getValue();
    }

    private void checkSelectedElements() {
        Object[] objectArray = this.selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof AutomationSystem) {
                this.expandSystem(obj);
            } else if (obj instanceof Device) {
                Device dev = (Device)obj;
                this.expandDevice(dev);
            } else if (obj instanceof Resource) {
                Resource res = (Resource)obj;
                this.expandResource(res);
            }
            ++n2;
        }
        this.systemTree.setSelection((ISelection)this.selection);
        this.systemTree.setCheckedElements(this.selection.toArray());
    }

    private void expandResource(Resource obj) {
        this.expandDevice(obj.getDevice());
    }

    private void expandDevice(Device obj) {
        this.expandSystem(obj.getAutomationSystem());
        this.systemTree.setExpandedState(obj, true);
    }

    private void expandSystem(Object obj) {
        this.systemTree.setExpandedState(obj, true);
    }

    public void handleEvent(Event event) {
    }

    private static IStructuredSelection createResourceSelection(IStructuredSelection selection) {
        HashSet selectedASFiles = new HashSet();
        selection.toList().forEach(obj -> {
            EObject eo;
            EObject root;
            IFile file;
            if (obj instanceof IFile && "SYS".equalsIgnoreCase((file = (IFile)obj).getFileExtension())) {
                selectedASFiles.add(file);
            }
            if (obj instanceof EObject && (root = EcoreUtil.getRootContainer((EObject)(eo = (EObject)obj))) instanceof LibraryElement) {
                LibraryElement libEl = (LibraryElement)root;
                selectedASFiles.add(libEl.getTypeEntry().getFile());
            }
        });
        return new StructuredSelection(selectedASFiles.toArray());
    }
}

