/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.UintType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyUnsignedValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class UIntValue
implements AnyUnsignedValue {
    public static final UIntValue DEFAULT = new UIntValue(0);
    private final short value;

    private UIntValue(short value) {
        this.value = value;
    }

    public static UIntValue toUIntValue(short value) {
        return new UIntValue(value);
    }

    public static UIntValue toUIntValue(Number value) {
        return new UIntValue(value.shortValue());
    }

    public static UIntValue toUIntValue(String value) {
        return UIntValue.toUIntValue((Number)NumericValueConverter.INSTANCE.toValue(value));
    }

    public static UIntValue toUIntValue(AnyMagnitudeValue value) {
        return UIntValue.toUIntValue(value.shortValue());
    }

    public UintType getType() {
        return IecTypes.ElementaryTypes.UINT;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return Short.toUnsignedInt(this.value);
    }

    @Override
    public long longValue() {
        return Short.toUnsignedLong(this.value);
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.longValue());
    }

    public int hashCode() {
        return Short.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UIntValue other = (UIntValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Integer.toUnsignedString(this.intValue());
    }
}

