/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import org.eclipse.fordiac.ide.model.data.AnyDateType;
import org.eclipse.fordiac.ide.model.data.AnyDurationType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EnumeratedType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.value.TypedValue;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public abstract class AbstractVariable<T extends Value>
implements Variable<T> {
    private final String name;
    private final INamedElement type;

    protected AbstractVariable(String name, INamedElement type) {
        this.name = name;
        this.type = type;
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean pretty) {
        DataType dataType;
        INamedElement iNamedElement = this.type;
        if (iNamedElement instanceof DataType && IecTypes.GenericTypes.isAnyType((DataType)(dataType = (DataType)iNamedElement)) && !(this.getValue().getType() instanceof AnyDurationType) && !(this.getValue().getType() instanceof AnyDateType) && !(this.getValue().getType() instanceof EnumeratedType)) {
            return this.getValue().getType().getName() + "#" + this.getValue().toString(pretty);
        }
        return this.getValue().toString(pretty);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public INamedElement getType() {
        return this.type;
    }

    @Override
    public final void setValue(String value) throws IllegalArgumentException {
        this.setValue(value, null);
    }

    @Override
    public void setValue(String value, TypeLibrary typeLibrary) {
        if (value == null || value.isEmpty()) {
            this.setValue(ValueOperations.defaultValue(this.type));
        } else {
            INamedElement iNamedElement = this.type;
            if (iNamedElement instanceof DataType) {
                DataType dataType = (DataType)iNamedElement;
                this.setValue(new TypedValueConverter(dataType, typeLibrary != null ? typeLibrary.getDataTypeLibrary() : null).toTypedValue(value));
            } else {
                throw new UnsupportedOperationException("The type " + this.type.getName() + " is not supported");
            }
        }
    }

    @Override
    public void setValue(TypedValue value) {
        this.setValue(ValueOperations.wrapValue(value.value(), (INamedElement)value.type()));
    }

    @Override
    public final boolean validateValue(String value) {
        return this.validateValue(value, null);
    }

    @Override
    public boolean validateValue(String value, TypeLibrary typeLibrary) {
        try {
            ValueOperations.parseValue(value, this.getType(), typeLibrary != null ? typeLibrary.getDataTypeLibrary() : null);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected RuntimeException createCastException(Value value) {
        throw new ClassCastException("Cannot assign value with incompatible type " + value.getType().getName() + " as " + this.type.getName());
    }

    protected RuntimeException createCastException(TypedValue value) {
        throw new ClassCastException("Cannot assign value with incompatible type " + value.type().getName() + " as " + this.type.getName());
    }
}

