/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style.theme;

import java.util.ArrayList;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.fillhandle.config.FillHandleConfigAttributes;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeConfigAttributes;
import org.eclipse.nebula.widgets.nattable.hideshow.indicator.HideIndicatorConfigAttributes;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.theme.IThemeExtension;
import org.eclipse.nebula.widgets.nattable.tree.config.TreeConfigAttributes;
import org.eclipse.swt.graphics.Color;

public abstract class ThemeConfiguration
extends AbstractRegistryConfiguration {
    protected boolean styleCornerLikeColumnHeader = false;
    protected final ArrayList<IThemeExtension> extensions = new ArrayList();

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        this.createPainterInstances();
        this.configureDefaultStyle(configRegistry);
        this.configureColumnHeaderStyle(configRegistry);
        this.configureRowHeaderStyle(configRegistry);
        this.configureCornerStyle(configRegistry);
        this.configureHoverStyle(configRegistry);
        this.configureHoverSelectionStyle(configRegistry);
        this.configureDefaultSelectionStyle(configRegistry);
        this.configureColumnHeaderSelectionStyle(configRegistry);
        this.configureRowHeaderSelectionStyle(configRegistry);
        this.configureCornerSelectionStyle(configRegistry);
        this.configureSelectionAnchorStyle(configRegistry);
        this.configureAlternatingRowStyle(configRegistry);
        this.configureColumnGroupHeaderStyle(configRegistry);
        this.configureRowGroupHeaderStyle(configRegistry);
        this.configureSortHeaderStyle(configRegistry);
        this.configureSelectedSortHeaderStyle(configRegistry);
        this.configureFilterRowStyle(configRegistry);
        this.configureTreeStyle(configRegistry);
        this.configureFreezeStyle(configRegistry);
        this.configureGridLineStyle(configRegistry);
        this.configureSummaryRowStyle(configRegistry);
        this.configureEditErrorStyle(configRegistry);
        this.configureFillHandleStyle(configRegistry);
        this.configureCopyBorderStyle(configRegistry);
        this.configureDataChangeStyle(configRegistry);
        this.configureHideIndicatorStyle(configRegistry);
        for (IThemeExtension extension : this.extensions) {
            extension.registerStyles(configRegistry);
        }
    }

    public void createPainterInstances() {
    }

    protected void configureDefaultStyle(IConfigRegistry configRegistry) {
        ICellPainter defaultPainter;
        IStyle defaultStyle = this.getDefaultCellStyle();
        if (!ThemeConfiguration.isStyleEmpty(defaultStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, defaultStyle);
        }
        if ((defaultPainter = this.getDefaultCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, defaultPainter);
        }
    }

    protected abstract IStyle getDefaultCellStyle();

    protected abstract ICellPainter getDefaultCellPainter();

    protected void configureColumnHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter columnHeaderCellPainter;
        IStyle columnHeaderStyle = this.getColumnHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(columnHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, columnHeaderStyle, DisplayMode.NORMAL, "COLUMN_HEADER");
        }
        if ((columnHeaderCellPainter = this.getColumnHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, columnHeaderCellPainter, DisplayMode.NORMAL, "COLUMN_HEADER");
        }
    }

    protected abstract IStyle getColumnHeaderStyle();

    protected abstract ICellPainter getColumnHeaderCellPainter();

    protected void configureRowHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter rowHeaderCellPainter;
        IStyle rowHeaderStyle = this.getRowHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(rowHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, rowHeaderStyle, DisplayMode.NORMAL, "ROW_HEADER");
        }
        if ((rowHeaderCellPainter = this.getRowHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, rowHeaderCellPainter, DisplayMode.NORMAL, "ROW_HEADER");
        }
    }

    protected abstract IStyle getRowHeaderStyle();

    protected abstract ICellPainter getRowHeaderCellPainter();

    protected void configureCornerStyle(IConfigRegistry configRegistry) {
        ICellPainter cornerCellPainter;
        IStyle cornerStyle;
        IStyle iStyle = cornerStyle = this.styleCornerLikeColumnHeader ? this.getColumnHeaderStyle() : this.getCornerStyle();
        if (!ThemeConfiguration.isStyleEmpty(cornerStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cornerStyle, DisplayMode.NORMAL, "CORNER");
        }
        ICellPainter iCellPainter = cornerCellPainter = this.styleCornerLikeColumnHeader ? this.getColumnHeaderCellPainter() : this.getCornerCellPainter();
        if (cornerCellPainter != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cornerCellPainter, DisplayMode.NORMAL, "CORNER");
        }
    }

    protected abstract IStyle getCornerStyle();

    protected abstract ICellPainter getCornerCellPainter();

    protected void configureHoverStyle(IConfigRegistry configRegistry) {
        ICellPainter rowHeaderHoverCellPainter;
        IStyle rowHeaderHoverStyle;
        ICellPainter columnHeaderHoverCellPainter;
        IStyle columnHeaderHoverStyle;
        ICellPainter bodyHoverCellPainter;
        IStyle bodyHoverStyle;
        ICellPainter defaultHoverCellPainter;
        IStyle defaultHoverStyle = this.getDefaultHoverStyle();
        if (!ThemeConfiguration.isStyleEmpty(defaultHoverStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, defaultHoverStyle, DisplayMode.HOVER);
        }
        if ((defaultHoverCellPainter = this.getDefaultHoverCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, defaultHoverCellPainter, DisplayMode.HOVER);
        }
        if (!ThemeConfiguration.isStyleEmpty(bodyHoverStyle = this.getBodyHoverStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, bodyHoverStyle, DisplayMode.HOVER, "BODY");
        }
        if ((bodyHoverCellPainter = this.getBodyHoverCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, bodyHoverCellPainter, DisplayMode.HOVER, "BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(columnHeaderHoverStyle = this.getColumnHeaderHoverStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, columnHeaderHoverStyle, DisplayMode.HOVER, "COLUMN_HEADER");
        }
        if ((columnHeaderHoverCellPainter = this.getColumnHeaderHoverCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, columnHeaderHoverCellPainter, DisplayMode.HOVER, "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(rowHeaderHoverStyle = this.getRowHeaderHoverStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, rowHeaderHoverStyle, DisplayMode.HOVER, "ROW_HEADER");
        }
        if ((rowHeaderHoverCellPainter = this.getRowHeaderHoverCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, rowHeaderHoverCellPainter, DisplayMode.HOVER, "ROW_HEADER");
        }
    }

    protected abstract IStyle getDefaultHoverStyle();

    protected abstract ICellPainter getDefaultHoverCellPainter();

    protected abstract IStyle getBodyHoverStyle();

    protected abstract ICellPainter getBodyHoverCellPainter();

    protected abstract IStyle getColumnHeaderHoverStyle();

    protected abstract ICellPainter getColumnHeaderHoverCellPainter();

    protected abstract IStyle getRowHeaderHoverStyle();

    protected abstract ICellPainter getRowHeaderHoverCellPainter();

    protected void configureHoverSelectionStyle(IConfigRegistry configRegistry) {
        ICellPainter rowHeaderHoverCellPainter;
        IStyle rowHeaderHoverStyle;
        ICellPainter columnHeaderHoverCellPainter;
        IStyle columnHeaderHoverStyle;
        ICellPainter bodyHoverCellPainter;
        IStyle bodyHoverStyle;
        ICellPainter defaultHoverCellPainter;
        IStyle defaultHoverStyle = this.getDefaultHoverSelectionStyle();
        if (!ThemeConfiguration.isStyleEmpty(defaultHoverStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, defaultHoverStyle, DisplayMode.SELECT_HOVER);
        }
        if ((defaultHoverCellPainter = this.getDefaultHoverSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, defaultHoverCellPainter, DisplayMode.SELECT_HOVER);
        }
        if (!ThemeConfiguration.isStyleEmpty(bodyHoverStyle = this.getBodyHoverSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, bodyHoverStyle, DisplayMode.SELECT_HOVER, "BODY");
        }
        if ((bodyHoverCellPainter = this.getBodyHoverSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, bodyHoverCellPainter, DisplayMode.SELECT_HOVER, "BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(columnHeaderHoverStyle = this.getColumnHeaderHoverSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, columnHeaderHoverStyle, DisplayMode.SELECT_HOVER, "COLUMN_HEADER");
        }
        if ((columnHeaderHoverCellPainter = this.getColumnHeaderHoverSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, columnHeaderHoverCellPainter, DisplayMode.SELECT_HOVER, "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(rowHeaderHoverStyle = this.getRowHeaderHoverSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, rowHeaderHoverStyle, DisplayMode.SELECT_HOVER, "ROW_HEADER");
        }
        if ((rowHeaderHoverCellPainter = this.getRowHeaderHoverSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, rowHeaderHoverCellPainter, DisplayMode.SELECT_HOVER, "ROW_HEADER");
        }
    }

    protected abstract IStyle getDefaultHoverSelectionStyle();

    protected abstract ICellPainter getDefaultHoverSelectionCellPainter();

    protected abstract IStyle getBodyHoverSelectionStyle();

    protected abstract ICellPainter getBodyHoverSelectionCellPainter();

    protected abstract IStyle getColumnHeaderHoverSelectionStyle();

    protected abstract ICellPainter getColumnHeaderHoverSelectionCellPainter();

    protected abstract IStyle getRowHeaderHoverSelectionStyle();

    protected abstract ICellPainter getRowHeaderHoverSelectionCellPainter();

    protected void configureDefaultSelectionStyle(IConfigRegistry configRegistry) {
        ICellPainter defaultSelectionCellPainter;
        IStyle defaultSelectionStyle = this.getDefaultSelectionCellStyle();
        if (!ThemeConfiguration.isStyleEmpty(defaultSelectionStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, defaultSelectionStyle, DisplayMode.SELECT);
        }
        if ((defaultSelectionCellPainter = this.getDefaultSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, defaultSelectionCellPainter, DisplayMode.SELECT);
        }
    }

    protected abstract IStyle getDefaultSelectionCellStyle();

    protected abstract ICellPainter getDefaultSelectionCellPainter();

    protected void configureColumnHeaderSelectionStyle(IConfigRegistry configRegistry) {
        ICellPainter fullSelectionColumnHeaderCellPainter;
        IStyle fullSelectionColumnHeaderStyle;
        ICellPainter columnHeaderCellPainter;
        IStyle columnHeaderStyle = this.getColumnHeaderSelectionStyle();
        if (!ThemeConfiguration.isStyleEmpty(columnHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, columnHeaderStyle, DisplayMode.SELECT, "COLUMN_HEADER");
        }
        if ((columnHeaderCellPainter = this.getColumnHeaderSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, columnHeaderCellPainter, DisplayMode.SELECT, "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(fullSelectionColumnHeaderStyle = this.getColumnHeaderFullSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, fullSelectionColumnHeaderStyle, DisplayMode.SELECT, "COLUMN_HEADER_FULL");
        }
        if ((fullSelectionColumnHeaderCellPainter = this.getColumnHeaderFullSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, fullSelectionColumnHeaderCellPainter, DisplayMode.SELECT, "COLUMN_HEADER_FULL");
        }
    }

    protected abstract IStyle getColumnHeaderSelectionStyle();

    protected abstract ICellPainter getColumnHeaderSelectionCellPainter();

    protected abstract IStyle getColumnHeaderFullSelectionStyle();

    protected abstract ICellPainter getColumnHeaderFullSelectionCellPainter();

    protected void configureRowHeaderSelectionStyle(IConfigRegistry configRegistry) {
        ICellPainter fullSelectionRowHeaderCellPainter;
        IStyle fullSelectionRowHeaderStyle;
        ICellPainter rowHeaderCellPainter;
        IStyle rowHeaderStyle = this.getRowHeaderSelectionStyle();
        if (!ThemeConfiguration.isStyleEmpty(rowHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, rowHeaderStyle, DisplayMode.SELECT, "ROW_HEADER");
        }
        if ((rowHeaderCellPainter = this.getRowHeaderSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, rowHeaderCellPainter, DisplayMode.SELECT, "ROW_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(fullSelectionRowHeaderStyle = this.getRowHeaderFullSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, fullSelectionRowHeaderStyle, DisplayMode.SELECT, "ROW_HEADER_FULL");
        }
        if ((fullSelectionRowHeaderCellPainter = this.getRowHeaderFullSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, fullSelectionRowHeaderCellPainter, DisplayMode.SELECT, "ROW_HEADER_FULL");
        }
    }

    protected abstract IStyle getRowHeaderSelectionStyle();

    protected abstract ICellPainter getRowHeaderSelectionCellPainter();

    protected abstract IStyle getRowHeaderFullSelectionStyle();

    protected abstract ICellPainter getRowHeaderFullSelectionCellPainter();

    protected void configureCornerSelectionStyle(IConfigRegistry configRegistry) {
        ICellPainter cornerCellPainter;
        IStyle cornerStyle;
        IStyle iStyle = cornerStyle = this.styleCornerLikeColumnHeader ? this.getColumnHeaderSelectionStyle() : this.getCornerSelectionStyle();
        if (!ThemeConfiguration.isStyleEmpty(cornerStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cornerStyle, DisplayMode.SELECT, "CORNER");
        }
        ICellPainter iCellPainter = cornerCellPainter = this.styleCornerLikeColumnHeader ? this.getColumnHeaderSelectionCellPainter() : this.getCornerSelectionCellPainter();
        if (cornerCellPainter != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cornerCellPainter, DisplayMode.SELECT, "CORNER");
        }
    }

    protected abstract IStyle getCornerSelectionStyle();

    protected abstract ICellPainter getCornerSelectionCellPainter();

    protected void configureSelectionAnchorStyle(IConfigRegistry configRegistry) {
        IStyle gridLineStyle;
        ICellPainter selectionAnchorPainter;
        IStyle selectionAnchorStyle;
        ICellPainter anchorPainter;
        IStyle anchorStyle = this.getSelectionAnchorStyle();
        if (!ThemeConfiguration.isStyleEmpty(anchorStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, anchorStyle, DisplayMode.NORMAL, "selectionAnchor");
        }
        if ((anchorPainter = this.getSelectionAnchorCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, anchorPainter, DisplayMode.NORMAL, "selectionAnchor");
        }
        if (!ThemeConfiguration.isStyleEmpty(selectionAnchorStyle = this.getSelectionAnchorSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, selectionAnchorStyle, DisplayMode.SELECT, "selectionAnchor");
        }
        if ((selectionAnchorPainter = this.getSelectionAnchorSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, selectionAnchorPainter, DisplayMode.SELECT, "selectionAnchor");
        }
        if (!ThemeConfiguration.isStyleEmpty(gridLineStyle = this.getSelectionAnchorGridLineStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, gridLineStyle, DisplayMode.SELECT, "selectionAnchorGridLine");
        }
    }

    protected abstract IStyle getSelectionAnchorStyle();

    protected abstract ICellPainter getSelectionAnchorCellPainter();

    protected abstract IStyle getSelectionAnchorSelectionStyle();

    protected abstract ICellPainter getSelectionAnchorSelectionCellPainter();

    protected abstract IStyle getSelectionAnchorGridLineStyle();

    protected void configureAlternatingRowStyle(IConfigRegistry configRegistry) {
        ICellPainter oddCellPainter;
        IStyle oddStyle;
        ICellPainter evenCellPainter;
        IStyle evenStyle = this.getEvenRowStyle();
        if (!ThemeConfiguration.isStyleEmpty(evenStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, evenStyle, DisplayMode.NORMAL, "EVEN_BODY");
        }
        if ((evenCellPainter = this.getEvenRowCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, evenCellPainter, DisplayMode.NORMAL, "EVEN_BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(oddStyle = this.getOddRowStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, oddStyle, DisplayMode.NORMAL, "ODD_BODY");
        }
        if ((oddCellPainter = this.getOddRowCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, oddCellPainter, DisplayMode.NORMAL, "ODD_BODY");
        }
    }

    protected abstract IStyle getEvenRowStyle();

    protected abstract ICellPainter getEvenRowCellPainter();

    protected abstract IStyle getOddRowStyle();

    protected abstract ICellPainter getOddRowCellPainter();

    protected void configureColumnGroupHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter columnGroupHeaderCellPainter;
        IStyle columnGroupHeaderStyle = this.getColumnGroupHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(columnGroupHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, columnGroupHeaderStyle, DisplayMode.NORMAL, "COLUMN_GROUP_HEADER");
        }
        if ((columnGroupHeaderCellPainter = this.getColumnGroupHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, columnGroupHeaderCellPainter, DisplayMode.NORMAL, "COLUMN_GROUP_HEADER");
        }
    }

    protected abstract IStyle getColumnGroupHeaderStyle();

    protected abstract ICellPainter getColumnGroupHeaderCellPainter();

    protected void configureRowGroupHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter rowGroupHeaderCellPainter;
        IStyle rowGroupHeaderStyle = this.getRowGroupHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(rowGroupHeaderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, rowGroupHeaderStyle, DisplayMode.NORMAL, "ROW_GROUP_HEADER");
        }
        if ((rowGroupHeaderCellPainter = this.getRowGroupHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, rowGroupHeaderCellPainter, DisplayMode.NORMAL, "ROW_GROUP_HEADER");
        }
    }

    protected abstract IStyle getRowGroupHeaderStyle();

    protected abstract ICellPainter getRowGroupHeaderCellPainter();

    protected void configureSortHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter cellPainter;
        IStyle sortStyle = this.getSortHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(sortStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, sortStyle, DisplayMode.NORMAL, "SORT_DOWN");
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, sortStyle, DisplayMode.NORMAL, "SORT_UP");
        }
        if ((cellPainter = this.getSortHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, DisplayMode.NORMAL, "SORT_DOWN");
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, DisplayMode.NORMAL, "SORT_UP");
        }
    }

    protected abstract IStyle getSortHeaderStyle();

    protected abstract ICellPainter getSortHeaderCellPainter();

    protected void configureSelectedSortHeaderStyle(IConfigRegistry configRegistry) {
        ICellPainter cellPainter;
        IStyle sortStyle = this.getSelectedSortHeaderStyle();
        if (!ThemeConfiguration.isStyleEmpty(sortStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, sortStyle, DisplayMode.SELECT, "SORT_DOWN");
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, sortStyle, DisplayMode.SELECT, "SORT_UP");
        }
        if ((cellPainter = this.getSelectedSortHeaderCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, DisplayMode.SELECT, "SORT_DOWN");
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, DisplayMode.SELECT, "SORT_UP");
        }
    }

    protected abstract IStyle getSelectedSortHeaderStyle();

    protected abstract ICellPainter getSelectedSortHeaderCellPainter();

    protected void configureFilterRowStyle(IConfigRegistry configRegistry) {
        ICellPainter cellPainter;
        IStyle filterRowStyle = this.getFilterRowStyle();
        if (!ThemeConfiguration.isStyleEmpty(filterRowStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, filterRowStyle, DisplayMode.NORMAL, "FILTER_ROW");
        }
        if ((cellPainter = this.getFilterRowCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, DisplayMode.NORMAL, "FILTER_ROW");
        }
    }

    protected abstract IStyle getFilterRowStyle();

    protected abstract ICellPainter getFilterRowCellPainter();

    protected void configureTreeStyle(IConfigRegistry configRegistry) {
        ICellPainter treeSelectionPainter;
        ICellPainter treePainter;
        ICellPainter selectionCellPainter;
        IStyle treeSelectionStyle;
        ICellPainter cellPainter;
        IStyle treeStyle = this.getTreeStyle();
        if (!ThemeConfiguration.isStyleEmpty(treeStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, treeStyle, DisplayMode.NORMAL, "TREE_COLUMN_CELL");
        }
        if ((cellPainter = this.getTreeCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, DisplayMode.NORMAL, "TREE_COLUMN_CELL");
        }
        if (!ThemeConfiguration.isStyleEmpty(treeSelectionStyle = this.getTreeSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, treeSelectionStyle, DisplayMode.SELECT, "TREE_COLUMN_CELL");
        }
        if ((selectionCellPainter = this.getTreeSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, selectionCellPainter, DisplayMode.SELECT, "TREE_COLUMN_CELL");
        }
        if ((treePainter = this.getTreeStructurePainter()) != null) {
            configRegistry.registerConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, treePainter, DisplayMode.NORMAL);
        }
        if ((treeSelectionPainter = this.getTreeStructureSelectionPainter()) != null) {
            configRegistry.registerConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, treeSelectionPainter, DisplayMode.SELECT);
        }
    }

    protected abstract IStyle getTreeStyle();

    protected abstract ICellPainter getTreeCellPainter();

    protected abstract IStyle getTreeSelectionStyle();

    protected abstract ICellPainter getTreeSelectionCellPainter();

    protected abstract ICellPainter getTreeStructurePainter();

    protected abstract ICellPainter getTreeStructureSelectionPainter();

    protected void configureSummaryRowStyle(IConfigRegistry configRegistry) {
        ICellPainter cellPainter;
        IStyle style = this.getSummaryRowStyle();
        if (!ThemeConfiguration.isStyleEmpty(style)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, style, DisplayMode.NORMAL, "SummaryRow");
        }
        if ((cellPainter = this.getSummaryRowCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, DisplayMode.NORMAL, "SummaryRow");
        }
        if (!ThemeConfiguration.isStyleEmpty(style = this.getSummaryRowSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, style, DisplayMode.SELECT, "SummaryRow");
        }
        if ((cellPainter = this.getSummaryRowSelectionCellPainter()) != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, cellPainter, DisplayMode.SELECT, "SummaryRow");
        }
    }

    protected abstract IStyle getSummaryRowStyle();

    protected abstract ICellPainter getSummaryRowCellPainter();

    protected abstract IStyle getSummaryRowSelectionStyle();

    protected abstract ICellPainter getSummaryRowSelectionCellPainter();

    protected void configureFreezeStyle(IConfigRegistry configRegistry) {
        if (this.getFreezeSeparatorColor() != null) {
            configRegistry.registerConfigAttribute(FreezeConfigAttributes.SEPARATOR_COLOR, this.getFreezeSeparatorColor());
        }
        if (this.getFreezeSeparatorWidth() != null) {
            configRegistry.registerConfigAttribute(FreezeConfigAttributes.SEPARATOR_WIDTH, this.getFreezeSeparatorWidth());
        }
    }

    protected abstract Color getFreezeSeparatorColor();

    protected abstract Integer getFreezeSeparatorWidth();

    protected void configureGridLineStyle(IConfigRegistry configRegistry) {
        if (this.getGridLineColor() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.GRID_LINE_COLOR, this.getGridLineColor());
        }
        if (this.getRenderColumnHeaderGridLines() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, this.getRenderColumnHeaderGridLines(), DisplayMode.NORMAL, "COLUMN_HEADER");
        }
        if (this.getRenderCornerGridLines() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, this.getRenderCornerGridLines(), DisplayMode.NORMAL, "CORNER");
        }
        if (this.getRenderRowHeaderGridLines() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, this.getRenderRowHeaderGridLines(), DisplayMode.NORMAL, "ROW_HEADER");
        }
        if (this.getRenderBodyGridLines() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, this.getRenderBodyGridLines(), DisplayMode.NORMAL, "BODY");
        }
        if (this.getRenderFilterRowGridLines() != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, this.getRenderFilterRowGridLines(), DisplayMode.NORMAL, "FILTER_ROW");
        }
    }

    protected abstract Color getGridLineColor();

    protected abstract Boolean getRenderColumnHeaderGridLines();

    protected abstract Boolean getRenderCornerGridLines();

    protected abstract Boolean getRenderRowHeaderGridLines();

    protected abstract Boolean getRenderBodyGridLines();

    protected abstract Boolean getRenderFilterRowGridLines();

    protected void configureEditErrorStyle(IConfigRegistry configRegistry) {
        if (!ThemeConfiguration.isStyleEmpty(this.getConversionErrorStyle())) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_STYLE, this.getConversionErrorStyle(), DisplayMode.EDIT);
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getValidationErrorStyle())) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_STYLE, this.getValidationErrorStyle(), DisplayMode.EDIT);
        }
    }

    protected abstract IStyle getConversionErrorStyle();

    protected abstract IStyle getValidationErrorStyle();

    protected void configureFillHandleStyle(IConfigRegistry configRegistry) {
        BorderStyle fillHandleRegionBorderStyle;
        BorderStyle fillHandleBorderStyle;
        Color fillHandleColor = this.getFillHandleColor();
        if (fillHandleColor != null) {
            configRegistry.registerConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_COLOR, fillHandleColor, DisplayMode.NORMAL);
        }
        if ((fillHandleBorderStyle = this.getFillHandleBorderStyle()) != null) {
            configRegistry.registerConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_BORDER_STYLE, fillHandleBorderStyle, DisplayMode.NORMAL);
        }
        if ((fillHandleRegionBorderStyle = this.getFillHandleRegionBorderStyle()) != null) {
            configRegistry.registerConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_REGION_BORDER_STYLE, fillHandleRegionBorderStyle, DisplayMode.NORMAL);
        }
    }

    protected abstract Color getFillHandleColor();

    protected abstract BorderStyle getFillHandleBorderStyle();

    protected abstract BorderStyle getFillHandleRegionBorderStyle();

    protected void configureCopyBorderStyle(IConfigRegistry configRegistry) {
        IStyle copyBorderStyle = this.getCopyBorderStyle();
        if (!ThemeConfiguration.isStyleEmpty(copyBorderStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, copyBorderStyle, DisplayMode.NORMAL, "copyBorderStyle");
        }
    }

    protected abstract IStyle getCopyBorderStyle();

    protected void configureDataChangeStyle(IConfigRegistry configRegistry) {
        IStyle selectedDataChangeStyle;
        IStyle dataChangeStyle = this.getDataChangeStyle();
        if (!ThemeConfiguration.isStyleEmpty(dataChangeStyle)) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, dataChangeStyle, DisplayMode.NORMAL, "DIRTY");
        }
        if (!ThemeConfiguration.isStyleEmpty(selectedDataChangeStyle = this.getDataChangeSelectionStyle())) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, selectedDataChangeStyle, DisplayMode.SELECT, "DIRTY");
        }
    }

    protected abstract IStyle getDataChangeStyle();

    protected abstract IStyle getDataChangeSelectionStyle();

    protected void configureHideIndicatorStyle(IConfigRegistry configRegistry) {
        if (this.getHideIndicatorColor() != null) {
            configRegistry.registerConfigAttribute(HideIndicatorConfigAttributes.HIDE_INDICATOR_COLOR, this.getHideIndicatorColor());
        }
        if (this.getHideIndicatorWidth() != null) {
            configRegistry.registerConfigAttribute(HideIndicatorConfigAttributes.HIDE_INDICATOR_LINE_WIDTH, this.getHideIndicatorWidth());
        }
    }

    protected abstract Color getHideIndicatorColor();

    protected abstract Integer getHideIndicatorWidth();

    public static boolean isStyleEmpty(IStyle style) {
        if (style == null) {
            return true;
        }
        return style.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR) == null && style.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR) == null && style.getAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR) == null && style.getAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR) == null && style.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT) == null && style.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT) == null && style.getAttributeValue(CellStyleAttributes.FONT) == null && style.getAttributeValue(CellStyleAttributes.IMAGE) == null && style.getAttributeValue(CellStyleAttributes.BORDER_STYLE) == null && style.getAttributeValue(CellStyleAttributes.PASSWORD_ECHO_CHAR) == null && style.getAttributeValue(CellStyleAttributes.TEXT_DECORATION) == null;
    }

    public void unregisterThemeStyleConfigurations(IConfigRegistry configRegistry) {
        if (!ThemeConfiguration.isStyleEmpty(this.getDefaultCellStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE);
        }
        if (this.getDefaultCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER);
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getDefaultSelectionCellStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT);
        }
        if (this.getDefaultSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT);
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "COLUMN_HEADER");
        }
        if (this.getColumnHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnHeaderSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "COLUMN_HEADER");
        }
        if (this.getColumnHeaderSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnHeaderFullSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "COLUMN_HEADER_FULL");
        }
        if (this.getColumnHeaderFullSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "COLUMN_HEADER_FULL");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "ROW_HEADER");
        }
        if (this.getRowHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "ROW_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowHeaderSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "ROW_HEADER");
        }
        if (this.getRowHeaderSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "ROW_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowHeaderFullSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "ROW_HEADER_FULL");
        }
        if (this.getRowHeaderFullSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "ROW_HEADER_FULL");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getCornerStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "CORNER");
        }
        if (this.getCornerCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "CORNER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getCornerSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "CORNER");
        }
        if (this.getCornerSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "CORNER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getDefaultHoverStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.HOVER);
        }
        if (this.getDefaultHoverCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.HOVER);
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getBodyHoverStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.HOVER, "BODY");
        }
        if (this.getBodyHoverCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.HOVER, "BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnHeaderHoverStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.HOVER, "COLUMN_HEADER");
        }
        if (this.getColumnHeaderHoverCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.HOVER, "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowHeaderHoverStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.HOVER, "ROW_HEADER");
        }
        if (this.getRowHeaderHoverCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.HOVER, "ROW_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getDefaultHoverSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT_HOVER);
        }
        if (this.getDefaultHoverSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT_HOVER);
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getBodyHoverSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT_HOVER, "BODY");
        }
        if (this.getBodyHoverSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT_HOVER, "BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnHeaderHoverSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT_HOVER, "COLUMN_HEADER");
        }
        if (this.getColumnHeaderHoverSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT_HOVER, "COLUMN_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowHeaderHoverSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT_HOVER, "ROW_HEADER");
        }
        if (this.getRowHeaderHoverSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT_HOVER, "ROW_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSelectionAnchorStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "selectionAnchor");
        }
        if (this.getSelectionAnchorCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "selectionAnchor");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSelectionAnchorSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "selectionAnchor");
        }
        if (this.getSelectionAnchorSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "selectionAnchor");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSelectionAnchorGridLineStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "selectionAnchorGridLine");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getEvenRowStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "EVEN_BODY");
        }
        if (this.getEvenRowCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "EVEN_BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getOddRowStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "ODD_BODY");
        }
        if (this.getOddRowCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "ODD_BODY");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getColumnGroupHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "COLUMN_GROUP_HEADER");
        }
        if (this.getColumnGroupHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "COLUMN_GROUP_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getRowGroupHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "ROW_GROUP_HEADER");
        }
        if (this.getRowGroupHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "ROW_GROUP_HEADER");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSortHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "SORT_DOWN");
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "SORT_UP");
        }
        if (this.getSortHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "SORT_DOWN");
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "SORT_UP");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSelectedSortHeaderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "SORT_DOWN");
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "SORT_UP");
        }
        if (this.getSelectedSortHeaderCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "SORT_DOWN");
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "SORT_UP");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getFilterRowStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "FILTER_ROW");
        }
        if (this.getFilterRowCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "FILTER_ROW");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getTreeStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "TREE_COLUMN_CELL");
        }
        if (this.getTreeCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "TREE_COLUMN_CELL");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getTreeSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "TREE_COLUMN_CELL");
        }
        if (this.getTreeSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "TREE_COLUMN_CELL");
        }
        if (this.getTreeStructurePainter() != null) {
            configRegistry.unregisterConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, DisplayMode.NORMAL);
        }
        if (this.getTreeStructureSelectionPainter() != null) {
            configRegistry.unregisterConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, DisplayMode.SELECT);
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSummaryRowStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "SummaryRow");
        }
        if (this.getSummaryRowCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, "SummaryRow");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getSummaryRowSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "SummaryRow");
        }
        if (this.getSummaryRowSelectionCellPainter() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.SELECT, "SummaryRow");
        }
        if (this.getFreezeSeparatorColor() != null) {
            configRegistry.unregisterConfigAttribute(FreezeConfigAttributes.SEPARATOR_COLOR);
        }
        if (this.getFreezeSeparatorWidth() != null) {
            configRegistry.unregisterConfigAttribute(FreezeConfigAttributes.SEPARATOR_WIDTH);
        }
        if (this.getGridLineColor() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.GRID_LINE_COLOR);
        }
        if (this.getRenderColumnHeaderGridLines() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, DisplayMode.NORMAL, "COLUMN_HEADER");
        }
        if (this.getRenderCornerGridLines() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, DisplayMode.NORMAL, "CORNER");
        }
        if (this.getRenderRowHeaderGridLines() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, DisplayMode.NORMAL, "ROW_HEADER");
        }
        if (this.getRenderBodyGridLines() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, DisplayMode.NORMAL, "BODY");
        }
        if (this.getRenderFilterRowGridLines() != null) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, DisplayMode.NORMAL, "FILTER_ROW");
        }
        if (this.getConversionErrorStyle() != null) {
            configRegistry.unregisterConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_STYLE, DisplayMode.EDIT);
        }
        if (this.getValidationErrorStyle() != null) {
            configRegistry.unregisterConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_STYLE, DisplayMode.EDIT);
        }
        if (this.getFillHandleColor() != null) {
            configRegistry.unregisterConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_COLOR, DisplayMode.NORMAL, "selectionHandleCell");
        }
        if (this.getFillHandleBorderStyle() != null) {
            configRegistry.unregisterConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_BORDER_STYLE, DisplayMode.NORMAL, "selectionHandleCell");
        }
        if (this.getFillHandleRegionBorderStyle() != null) {
            configRegistry.unregisterConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_REGION_BORDER_STYLE, DisplayMode.NORMAL, "FILL_HANDLE_REGION");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getCopyBorderStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "copyBorderStyle");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getDataChangeStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, "DIRTY");
        }
        if (!ThemeConfiguration.isStyleEmpty(this.getDataChangeSelectionStyle())) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "DIRTY");
        }
        if (this.getHideIndicatorColor() != null) {
            configRegistry.unregisterConfigAttribute(HideIndicatorConfigAttributes.HIDE_INDICATOR_COLOR);
        }
        if (this.getHideIndicatorWidth() != null) {
            configRegistry.unregisterConfigAttribute(HideIndicatorConfigAttributes.HIDE_INDICATOR_LINE_WIDTH);
        }
        for (IThemeExtension extension : this.extensions) {
            extension.unregisterStyles(configRegistry);
        }
    }

    public void addThemeExtension(IThemeExtension extension) {
        this.extensions.add(extension);
    }

    public void removeThemeExtension(IThemeExtension extension) {
        this.extensions.remove(extension);
    }
}

