/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

public class BoxedMutableIntSet
extends AbstractMutableSet<Integer>
implements MutableSet<Integer> {
    private final MutableIntSet delegate;

    public BoxedMutableIntSet(MutableIntSet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    public Integer getFirst() {
        throw new UnsupportedOperationException();
    }

    public Integer getLast() {
        throw new UnsupportedOperationException();
    }

    public void each(Procedure<? super Integer> procedure) {
        this.delegate.each(arg_0 -> procedure.value(arg_0));
    }

    @Override
    public boolean add(Integer item) {
        return this.delegate.add(item.intValue());
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Integer && this.delegate.contains(((Integer)object).intValue());
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Integer && this.delegate.remove(((Integer)object).intValue());
    }

    public void clear() {
        this.delegate.clear();
    }

    public ParallelUnsortedSetIterable<Integer> asParallel(ExecutorService executorService, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    public Iterator<Integer> iterator() {
        return new BoxedPrimitiveIntSetIterator(this.delegate.intIterator());
    }

    private static final class BoxedPrimitiveIntSetIterator
    implements Iterator<Integer> {
        private final MutableIntIterator delegate;

        private BoxedPrimitiveIntSetIterator(MutableIntIterator iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Integer next() {
            return this.delegate.next();
        }
    }
}

