/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.handlers.UpdateFBTypeHandler;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class UpdateAllFBTypesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompoundCommand command = UpdateAllFBTypesHandler.createCommand();
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        FBNetwork fbnetwork = (FBNetwork)editor.getAdapter(FBNetwork.class);
        CommandStack stack = (CommandStack)editor.getAdapter(CommandStack.class);
        fbnetwork.getBlockFBNetworkElements().forEach(element -> {
            Command updateFBTypeCmd;
            if (element.getType() != null && (updateFBTypeCmd = UpdateFBTypeHandler.getUpdateCommand(element)).canExecute()) {
                command.add(updateFBTypeCmd);
            }
        });
        if (stack != null) {
            stack.execute((Command)command);
        }
        return Status.OK_STATUS;
    }

    private static CompoundCommand createCommand() {
        return new CompoundCommand(){

            public void execute() {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
                try {
                    dialog.run(true, false, monitor -> {
                        monitor.beginTask("Updating", this.getCommands().size());
                        for (Command cmd : this.getCommands()) {
                            Display.getDefault().syncExec(() -> ((Command)cmd).execute());
                            monitor.worked(1);
                        }
                        monitor.done();
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        };
    }
}

