/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.ui.wizard;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.export.ui.Messages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ExportStatusMessageDialog
extends ErrorDialog {
    private final List<String> warnings;
    private final List<String> errors;
    private StyledText text;

    public ExportStatusMessageDialog(Shell parentShell, List<String> warnings, List<String> errors) {
        super(parentShell, Messages.ExportStatusMessageDialog_4diacIDETypeExportErrors, Messages.ExportStatusMessageDialog_DuringTypeExportTheFollowingIssuesHaveBeenIdentified, (IStatus)new Status(1, "org.eclipse.fordiac.ide.export", MessageFormat.format(Messages.ExportStatusMessageDialog_ExportStatusMessageDialog, errors.size(), warnings.size())), 7);
        this.warnings = warnings;
        this.errors = errors;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        super.createDialogAndButtonArea(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.dialogArea);
    }

    protected Control createMessageArea(Composite parent) {
        Control retval = super.createMessageArea(parent);
        ExportStatusMessageDialog.addPlaceholderLabel(parent);
        this.text = new StyledText(parent, 2818);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.text);
        this.text.setEditable(false);
        this.printMessages();
        return retval;
    }

    private static void addPlaceholderLabel(Composite parent) {
        new Label(parent, 0);
    }

    public void printMessages() {
        this.text.setText("");
        int count = 0;
        if (!this.errors.isEmpty()) {
            count += this.printMessageList(Messages.ExportStatusMessageDialog_ErrorsNotEmpty, this.errors, count);
        }
        if (!this.warnings.isEmpty()) {
            this.printMessageList(Messages.ExportStatusMessageDialog_WarningsNotEmpty, this.warnings, count);
        }
    }

    private int printMessageList(String title, List<String> messages, int startCount) {
        int count = startCount;
        this.text.append(title);
        StyleRange style1 = new StyleRange();
        style1.start = count;
        style1.length = title.length();
        style1.fontStyle = 1;
        this.text.setStyleRange(style1);
        count += title.length();
        count += this.addLines(messages);
        this.text.append("\n");
        return count += "\n".length();
    }

    private int addLines(List<String> messages) {
        int count = 0;
        for (String string : messages) {
            if (string == null) continue;
            String line = "    - " + string + "\n";
            this.text.append(line);
            count += line.length();
        }
        return count;
    }
}

