/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contractSpec;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Unit implements Enumerator
{
    S(0, "S", "s"),
    MS(1, "MS", "ms"),
    US(2, "US", "us"),
    NS(3, "NS", "ns");

    public static final int S_VALUE = 0;
    public static final int MS_VALUE = 1;
    public static final int US_VALUE = 2;
    public static final int NS_VALUE = 3;
    private static final Unit[] VALUES_ARRAY;
    public static final List<Unit> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Unit[]{S, MS, US, NS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Unit get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Unit result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Unit getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Unit result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Unit get(int value) {
        switch (value) {
            case 0: {
                return S;
            }
            case 1: {
                return MS;
            }
            case 2: {
                return US;
            }
            case 3: {
                return NS;
            }
        }
        return null;
    }

    private Unit(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

